/*
 * RowChangeSupport.java    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 * created: 2/97 cls
 */


package netscape.peas;




/**
 * The RowChangeSupport is a helper class to which classes which implement
 * fire the RowChangeEvent may delegate their implementations of:
 *    addRowChangeListenter
 *    removeRowChangeListener
 *    fireRowChange
 * It also implements propegateRowChange
 */
public class RowChangeSupport  {

    /**
     * Construct a RowChangeSupport class
     */
    public RowChangeSupport( Object oDelegator ) {
        moDelegator = oDelegator;
    }

    /**
     * Add an object which is a RowChangeListener to set of registered listeners.
     */
    public synchronized void addRowChangeListener( RowChangeListener oListener ) {

        if ( null == mvRowChangeListeners ) {
            mvRowChangeListeners = new java.util.Vector();
        }
        mvRowChangeListeners.addElement( oListener );

    } // addRowChangeListener


    /**
     * Remove oListener from set of registered listeners.
     */
    public synchronized void removeRowChangeListener( RowChangeListener oListener ) {
	    if ( null != mvRowChangeListeners ) {
	        mvRowChangeListeners.removeElement( oListener );
	    }

    } // removePropertyChangeListener


    /**
     * Given an event send it to all our listeners who have not heard of it yet.
     */
    public void propegateRowChange( RowChangeEvent oEvent ) {
        try {
         	java.util.Vector vTargets;
        	synchronized (this) {
        	    if ( mvRowChangeListeners == null) {
        	    	return;
        	    }
        	    vTargets = (java.util.Vector) mvRowChangeListeners.clone();
        	}

        	for ( int i = 0; i < vTargets.size(); i++ ) {
        	    RowChangeListener oTarget = (RowChangeListener)vTargets.elementAt( i );
        	    if ( ! oEvent.isOnVisitedList( oTarget ) ) {
        	        oEvent.addToVisitedList( oTarget );
            	    oTarget.rowChange( oEvent );
            	}
            }
        } catch ( Exception ex ) {
            System.out.println( "Caught exception in RowChangeSupport.propegateRowChange: " + ex );
        }
    }


    /**
     * Fire a RowChageEvent out to all our registered listeners.
     */
    public void fireRowChange( int iChangeType, String sColumnAffected, Object oOldValue, Object oNewValue, RowProvider oRowProvider, NotifyList oNotify ) {

        RowChangeEvent oEvent = new RowChangeEvent( iChangeType, sColumnAffected, oOldValue, oNewValue, oRowProvider );
        oEvent.setNotifyList( oNotify );
        oEvent.addToVisitedList( moDelegator );
        propegateRowChange( oEvent );

    }


    //-------------------------------------------------------------------------
    // Member variables

    private java.util.Vector mvRowChangeListeners;
    private Object moDelegator;

} // RowChangeSupport
