/*
 * JavaDummyCursor.java    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 * created: 2/97 cls
 */


package netscape.peas;


/**
 * Example Cursor object.
 *
 * Implemented as java class so it can be palced in HTML form using JavaScirpt "new" operator,
 * or, as "invisible bean".
 *
 * Fires propertyChange, rowChange, and tableChange events.
 * Implements PropertyChangeListener, RowChangeListener, and TableChangeListener interfaces.
 */
public class JavaDummyCursor extends TableSupport {

    /**
     * Construct a JavaDummyCursor object.  "true" is passed to supertype TableSupport to
     * indicate that this object must own its data context (column names & row numbers).
     */
    public JavaDummyCursor() {

        // a true value for bOwnsDataContext indicates that
        super( true );
        setFetchBufferSize( 10 );
    }


	/**
	 * Subclasses of TableSupport need to do the following in their version of executeQuery:
	 *    - setup the column names, if they are out of data
	 *    - be prepared for calls to fetChMoreRows.
	 *    - call TableSupport's implementation of execute query.  This resets buffer and causes fetching
	 */
	public void executeQuery() {

        // invent some "dummy" meta data
        String aColumnNames[] = new String[giNumColumns];
        aColumnNames[0] = gsName;
        aColumnNames[1] = gsDescription;
        aColumnNames[2] = gsPrice;
        int iNumColumns = giNumColumns;
        miExecuteNum++;

        int aColumnWidths[] = new int[giNumColumns];
        aColumnWidths[0] = 200;
        aColumnWidths[1] = 140;
        aColumnWidths[2] = 50;

        // give to our RowSupport object the information it needs...
        setNumColumns( iNumColumns );

        // setting our column names.
        // this causes TableChangeEvent.COLUMN_INFO_CHANGED and RowChangeEvent.COLUMN_INFO_CHANGED to be fired
        setColumnNames( aColumnNames, aColumnWidths, null );




        // let default implementation handle the rest
        super.executeQuery();

    } // executeQuery


    /**
     * Override of TableSupport's "do-nothing" implementation.
     * Get more rows, if "rowsPending" property  is true, otherwise does nothing.
     */
    public void fetchMoreRows() {

        if ( true == getRowsPending() ) {
            int iStartRow = getNumRowsFetched();
            int iFinishRow = Math.min( giTotalNumRows, iStartRow+getFetchBufferSize()) - 1;

            int iNumCols = getNumColumns();
            Object[] aRowValues = new Object[iNumCols];
            for ( int iRow = iStartRow; iRow<=iFinishRow; iRow++ ) {
                for ( int iCol = 0; iCol < iNumCols; iCol ++ ) {
                    aRowValues[iCol] = new String( "x"+miExecuteNum+"r"+iRow+"c"+iCol );
                }
                // Adds values to our model.  We notify listeners after all values are added
                // using a "ROWS_INSERTED" event
                addRowValues( aRowValues, false );
            }
            setRowsPending( getNumRowsFetched() < giTotalNumRows );
            fireTableChange( TableChangeEvent.ROWS_INSERTED, iStartRow, 0, null, this, null );
        }

    } // fetchMoreRows


    // end of TableReceiver interface
    //-----------------------------------------------------------------------------------------------------------


    //-----------------------------------------------------------------------------------------------------------
    // member variables

    //----------- statics (hard coded data values) -------------------------
    private static final String gsName = "Product";
    private static final String gsDescription = "Description";
    private static final String gsPrice = "Price";
    private static final int giTotalNumRows = 10;
    private static final int giNumColumns = 3;
    int miExecuteNum = 0; // counter
    //----------------------------------------------------------------------


} // JavaDummyCursor
