<JSB>
/*
 * FormAccept.jsb    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */

    <JSB_DESCRIPTOR NAME="netscape.peas.FormAccept"
        DISPLAYNAME="Form Processor"
        SHORTDESCRIPTION="Form submission processor for database operations" ENV="server" ISHIDDEN>

    <JSB_PROPERTY NAME="dbpool" DISPLAYNAME="DBPool" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Name of DBPool to use">

    <JSB_PROPERTY NAME="operation" DISPLAYNAME="Operation" PROPTYPE="JS-expr" TYPE="string"
        VALUESET="INSERT,UPDATE,DELETE" READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="The operation to perform (insert, update, delete)">

    <JSB_PROPERTY NAME="table" DISPLAYNAME="Table Name" PROPTYPE="JS-expr" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Name of table to modify">

    <JSB_PROPERTY NAME="keyFields" DISPLAYNAME="Key Fields (ES2)" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Names and types of key fields (for ES2 only)">

    <JSB_PROPERTY NAME="release" DISPLAYNAME="Release Connection" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD="" DEFAULT_VALUE="true"
        SHORTDESCRIPTION="Whether to release the database connection when finished processing">

    <JSB_PROPERTY NAME="onSuccessServer" DISPLAYNAME="On Success - Server" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Server Script to execute when operation succeeds">

    <JSB_PROPERTY NAME="onFailServer" DISPLAYNAME="On Failure - Server" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Server Script to execute when operation fails">

    <JSB_PROPERTY NAME="onSuccessClient" DISPLAYNAME="On Success - Client" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Client Script to execute when operation succeeds">

    <JSB_PROPERTY NAME="onFailClient" DISPLAYNAME="On Failure - Client" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Client Script to execute when operation fails">


    <JSB_CONSTRUCTOR>
function stripAnd(str) {
    L = str.length
    if (str.substring(L-3, L) == "AND" )
        return str.substring(0, L-3)
    else
        return str
}

function getVal(typeStr, valStr) {
   if (typeStr == "string")
      return "'" + valStr + "'"
   else
      return valStr
}

// This function sets the keyFields object to contains fieldname/datatype pairs, e.g.
// keyFields.address = "String", keyFields.id = "number"
// In server 2.0, comes from user-set property, in 3.0 is gotten automatically

function getColTypes(p) {
   o = new Object()
   if (server.httpdlwVersion.indexOf("3.0") != -1) {

      typeCursor = db.cursor("SELECT * FROM " + p.table )
      typeCursor.next()
      for (i in typeCursor) {
         o[i] = typeof( typeCursor[i] )
      }
   } else {
      parseProperty(o, p.keyFields)
   }
   return o
}

// parses the keyFields property (required for server 2.0 ONLY) as a comma-delimited list of names and
// values, eg. address=String,id=number  (each value must be a JS datatype: String, number, or Date)
function parseProperty(o, str) {
      commaLoc = str.lastIndexOf(",")
      pair = str.substring(commaLoc+1, str.length)
      equalLoc = pair.indexOf("=")
      name = pair.substring(0, equalLoc)
      val = pair.substring(equalLoc+1, str.length)
      str = str.substring(0, commaLoc)
      o[name] = val
      if (str.length>0)
        parseProperty(str)
}


function netscape_peas_FormAccept(params) {
    if ( (params.operation != null) && (params.operation != "") ) {

    fields = new Object()
    oldfields = new Object()
    for (i in request) {
       if ( i.substring(0,5) == "_old_" ) {
          colName = i.substring(5,i.length)
          oldfields[colName] = request[i] // oldfields[i] is the value of a column named "_old_i"
       } else if ( i.substring(0,1) == "_" ) {
          colName = i.substring(1, i.length)
          fields[colName] = request[i]  // fields[i] is the value of a column named "_i"
       }
    } //for

   if (server.httpdlwVersion.indexOf("3.0") != -1) {
      if (params.dbpool == null) {
         debug("Cursor's DBPool property is null - using generic database object.")
         cursorObj = database.cursor(params.SQL, params.updatable)
      } else {
          pool = project[params.dbpool]
          db = pool.connection(pool.id, pool.timeout)
      }
   } else
      db = database

   if  (!db.connected()) {
      displayErrMessages(db)
   } else {

      db.beginTransaction()
      if (params.operation == "INSERT") {
         curs = db.cursor("select * from " + params.table + " where 1=0", true)
         for (i in fields)
            curs[i] = fields[i]
         result = curs.insertRow(params.table)

      } else {  // Common procedure for update and delete
         keyFields = getColTypes(params)
         SQL = "SELECT * FROM " + params.table + " WHERE "

            if (params.operation == "UPDATE") {
               for (i in oldfields)
                  if ( (fields[i] != "") && (fields[i] != null) )
                     SQL += " " + i + " = " + getVal(keyFields[i], oldfields[i]) + " AND"
               curs = db.cursor(stripAnd(SQL), true)
               if (curs.next()) {
                  for (i in fields) {
                     curs[i] = fields[i]
                  }
                  result = curs.updateRow(params.table)
               } else
                  result = "Could not retrieve record to " + params.operation

            } else if (params.operation == "DELETE") {
               for (i in fields)
                  if ( (fields[i] != "") && (fields[i] != null) )
                     SQL += " " + i + " = " + getVal(keyFields[i], fields[i]) + " AND"
               curs = db.cursor(stripAnd(SQL), true)
               if (curs.next()) {
                  result = curs.deleteRow(params.table)
               } else
                  result = "Could not retrieve record to " + params.operation

            } //DELETE
      } //Update or Delete

      db.commitTransaction()

     // Close cursor and release connection
     curs.close()
     if ( (params.release) && (server.httpdlwVersion.indexOf("1.0") == -1) )
         db.release()

     if ((params.onSuccessServer == null) || (params.onSuccessServer == ""))
        params.onSuccessServer =0
     if ((params.onFailServer == null) || (params.onFailServer == ""))
        params.onFailServer =0

     if (result == 0) {
        eval(params.onSuccessServer)
        write("<SCRIPT>" + params.onSuccessClient + "</SCRIPT>")
     } else {
        eval(params.onFailServer)
        write("<SCRIPT>" + params.onFailClient + "</SCRIPT>")
     }

  } // end of stuff to do if connection successful
 }
} //netscape_peas_FormAccept

    </JSB_CONSTRUCTOR>
</JSB>
