<JSB>
/*
 * DBConnection.jsb    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */
    <JSB_DESCRIPTOR NAME="netscape.peas.DBConnection"
        DISPLAYNAME="Database Connection"
        SHORTDESCRIPTION="LiveWire Database Connection" ENV="server" ISHIDDEN>

    <JSB_PROPERTY NAME="dbType" DISPLAYNAME="Database Type" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        VALUESET="ORACLE,INFORMIX,SYBASE,ODBC-SQL Anywhere,ODBC-SQL Server,ODBC-Access"
        SHORTDESCRIPTION="Database type">

    <JSB_PROPERTY NAME="dbServer" DISPLAYNAME="Database Server" PROPTYPE="JS-expr" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Name of database server">

    <JSB_PROPERTY NAME="userName" DISPLAYNAME="User Name" PROPTYPE="JS-expr" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="User name on database server">

    <JSB_PROPERTY NAME="password" DISPLAYNAME="Password" PROPTYPE="JS-expr" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="password on database server">

    <JSB_PROPERTY NAME="dbName" DISPLAYNAME="Database Name" PROPTYPE="JS-expr" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Database name">

    <JSB_PROPERTY NAME="maxConnections" DISPLAYNAME="Max. Connections" PROPTYPE="JS" TYPE="number"
        READMETHOD="" WRITEMETHOD=""
        VALUESET="1:32767"
        SHORTDESCRIPTION="Max number of database connections to cache">

    <JSB_PROPERTY NAME="autoCommit" DISPLAYNAME="AutoCommit" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Whether to commit open transactions after each client request">

    <JSB_PROPERTY NAME="timeout" DISPLAYNAME="Timeout Interval" PROPTYPE="JS" TYPE="number"
        READMETHOD="" WRITEMETHOD=""
        VALUESET="1:32767"
        SHORTDESCRIPTION="Timeout interval to wait for available connection (ES3)">

    <JSB_METHOD NAME="connection" TYPE="void">
        <JSB_PARAMETER NAME="dbType" TYPE="string" VALUESET="ORACLE,ODBC,INFORMIX,SYBASE">
        <JSB_PARAMETER NAME="dbServer" TYPE="string">
        <JSB_PARAMETER NAME="userName" TYPE="string">
        <JSB_PARAMETER NAME="password" TYPE="string">
        <JSB_PARAMETER NAME="dbName" TYPE="string">
        <JSB_PARAMETER NAME="name" TYPE="string">
        <JSB_PARAMETER NAME="maxConnections" TYPE="number" VALUESET="1:32767">
    </JSB_METHOD>

    <JSB_METHOD NAME="disconnect" TYPE="void">            </JSB_METHOD>

    <JSB_METHOD NAME="connected" TYPE="boolean">          </JSB_METHOD>

    <JSB_METHOD NAME="beginTransaction" TYPE="string">    </JSB_METHOD>

    <JSB_METHOD NAME="commitTransaction" TYPE="string">   </JSB_METHOD>

    <JSB_METHOD NAME="rollbackTransaction" TYPE="string"> </JSB_METHOD>

    <JSB_METHOD NAME="SQLTable" TYPE="string">
        <JSB_PARAMETER NAME="Querystring" TYPE="string">
    </JSB_METHOD>

    <JSB_METHOD NAME="execute" TYPE="string">
        <JSB_PARAMETER NAME="SQLstring" TYPE="string">
    </JSB_METHOD>

    <JSB_CONSTRUCTOR>
function displayErrMsgs(db) {
    write("Error: Unable to connect to database.  Check that your username and password are correct")
    write("and that you have specified the correct name for the database server, database name, and type.")
    write("<P>Major Error Message: " + db.majorErrorMessage() )
    write("<P>Minor Error Message: " + db.minorErrorMessage() )
    write("<P>Major Error Code: " + db.majorErrorCode() )
    write("<P>Minor Error Code: " + db.minorErrorCode() )
}

function netscape_peas_DBConnection(params) {
	if  (params.dbName == null)
		params.dbName = ""
	if  (params.password == null)
		params.password = ""
      if (params.dbType.indexOf("ODBC") != -1)
		params.dbType = "ODBC"

    project.dbType = params.dbType
    project.dbServer = params.dbServer
    project.userName = params.userName
    project.password = params.password
    project.dbName = params.dbName

    client.currentUserName = params.userName

    // ----------------- Server 3.0 ----------------------
	if (server.httpdlwVersion.indexOf("3.0") != -1) {
		if (project.sharedConnectionPool == null)
			project.sharedConnectionPool = new DbPool(params.dbType, params.dbServer, params.userName, params.password, params.dbName, params.maxConnections, params.autoCommit)

	    connectionObj = project.sharedConnectionPool.connection(params.id, params.timeout)

      	if  ( !connectionObj.connected() )
      	    displayErrMsgs(connectionObj)
    	      else {
               project.currentConnection = connectionObj
     		   return connectionObj
            }

    // ----------------- Server 2.0 ----------------------
    	} else {
    	    with (client) {
                dbType = params.dbType
                dbServer = params.dbServer
                userName = params.userName
                password = params.password
                dbName = params.dbName
    	    }
          	dbObj = new Object()
          	with (params) {
              	database.connect(dbType, dbServer, userName, password, dbName)
            }
        	if  ( !database.connected() )
        		displayErrMsgs(database)
        	else
        		return dbObj
	    }
} // netscape_peas_DBConnection

    </JSB_CONSTRUCTOR>
</JSB>
