<JSB>
/*
 * CustomTable.jsb    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */
     <JSB_DESCRIPTOR NAME="netscape.peas.CustomTable" DISPLAYNAME="Custom Table"
        SHORTDESCRIPTION="Custom Database Table Display (server-side)"
        ISHIDDEN ENV="server">

    <JSB_PROPERTY NAME="align" DISPLAYNAME="Alignment" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD="" VALUESET="left,right"
        SHORTDESCRIPTION="Alignment of table on page">

    <JSB_PROPERTY NAME="bgColor" DISPLAYNAME="Background Color" PROPTYPE="JS" TYPE="color"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Background color of table">

    <JSB_PROPERTY NAME="border" DISPLAYNAME="BorderWidth" PROPTYPE="JS" TYPE="number"
        READMETHOD="" WRITEMETHOD="" VALUESET="1:99"
        SHORTDESCRIPTION="Width of table border">

    <JSB_PROPERTY NAME="captionPos" DISPLAYNAME="Caption Position" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD="" VALUESET="top,bottom"
        SHORTDESCRIPTION="Position of caption">

    <JSB_PROPERTY NAME="captionFontSize" DISPLAYNAME="Caption Font Size" PROPTYPE="JS" TYPE="number"
        READMETHOD="" WRITEMETHOD="" VALUESET="1:7"
        SHORTDESCRIPTION="Font size of caption">

    <JSB_PROPERTY NAME="caption" DISPLAYNAME="Caption Text" PROPTYPE="JS-expr" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Text for table caption">

    <JSB_PROPERTY NAME="cellPadding" DISPLAYNAME="Cell Padding" PROPTYPE="JS" TYPE="number"
        READMETHOD="" WRITEMETHOD="" VALUESET="1:9"
        SHORTDESCRIPTION="Pixels between cell border and contents">

    <JSB_PROPERTY NAME="cellSpacing" DISPLAYNAME="Cell Spacing" PROPTYPE="JS" TYPE="number"
        READMETHOD="" WRITEMETHOD="" VALUESET="1:9"
        SHORTDESCRIPTION="Pixels between cells">

    <JSB_PROPERTY NAME="colHeadings" DISPLAYNAME="Column Headings?" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Whether to display column headings">

    <JSB_PROPERTY NAME="enableSortSelection" DISPLAYNAME="Enable Sort Selection?" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Whether to enable links in columns to specify sorting">

    <JSB_PROPERTY NAME="dataSource" DISPLAYNAME="Data Source" PROPTYPE="JS-expr" TYPE="object"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Name of cursor from which to get data">

    <JSB_PROPERTY NAME="detailPage" DISPLAYNAME="Detail Page" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="URL of detail page to link to (if any)">

    <JSB_PROPERTY NAME="detailTarget" DISPLAYNAME="Detail Target" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Frame name of detail link (if any)">

    <JSB_PROPERTY NAME="FkeyCol" DISPLAYNAME="Foreign Key Column" PROPTYPE="JS-expr" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Foreign Key Column for detail linking (if any)">

    <JSB_PROPERTY NAME="hAlign" DISPLAYNAME="Horizontal alignment" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD="" VALUESET="left,right,center"
        SHORTDESCRIPTION="Horizontal alignment of contents within cells">

    <JSB_PROPERTY NAME="headBGColor" DISPLAYNAME="Heading BG Color" PROPTYPE="JS" TYPE="color"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Background color of heading">

    <JSB_PROPERTY NAME="keyCol" DISPLAYNAME="Key Column" PROPTYPE="JS-expr" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Key Column for detail linking (if any)">

    <JSB_PROPERTY NAME="nowrap" DISPLAYNAME="No Wrapping" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Whether to wrap cell contents or not">

    <JSB_PROPERTY NAME="vAlign" DISPLAYNAME="Vertical Alignment" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD="" VALUESET="top,center,bottom,baseline"
        SHORTDESCRIPTION="Vertical alignment of contents within cells">

    <JSB_PROPERTY NAME="width" DISPLAYNAME="Width" PROPTYPE="JS" TYPE="number"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Width of table (pixels or percent)">

    <JSB_PROPERTY NAME="release" DISPLAYNAME="Release Connection" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""  DEFAULT_VALUE="true"
        SHORTDESCRIPTION="Whether to release the database connection when finished processing">

    <JSB_CONSTRUCTOR>
function detailLink(ct, c, colName) {
   if ( (ct.detailPage != null) && (ct.FkeyCol != null) && (ct.keyCol == colName) ) {
      if ( null != ct.detailTarget ) {
        sTarget = " TARGET='" + ct.detailTarget + "'";
      } else {
        sTarget = "";
      }
      linkStr = "<A HREF='" + ct.detailPage + "?" + ct.FkeyCol + "=" + escape(c[colName]) + "'" + sTarget + ">" + c[colName] + "</A>"
      return linkStr
   }
   else
      return c[colName]
} //detailLink

function createSortLink(ct, colName) {
   if (ct.enableSortSelection)
      return ("<SCRIPT>document.write(\"" + colName + "\".link(setSearch(document.URL,\"" + colName + "\")))</SCRIPT>")
   else
      return colName
}

function netscape_peas_CustomTable(params) {
   write("<SCRIPT SRC='cCustomTable.js'></SCRIPT>")
   curs = params.dataSource
   h = "<TABLE ALIGN=" + params.align + " BGCOLOR=" + params.bgColor + " BORDER=" + params.border
   h += " CELLPADDING=" + params.cellPadding + " CELLSPACING=" + params.cellSpacing + " WIDTH=" + params.width + " >"

   if (params.caption != null)
      h += "<CAPTION ALIGN=" + params.captionPos + "><FONT SIZE=" + params.captionFontSize + ">" + params.caption + "</FONT></CAPTION>"

   // If colHeadings true, display column names as headings, otherwise omit
   if (params.colHeadings) {
      h += "<TR>"
      for (i = 0; i < curs.columns(); i++) {
         h += "<TH BGCOLOR=" + params.headBGColor + ">" + createSortLink(params, curs.columnName(i)) + "</TH>"
	  }
      h += "</TR>"
   }

   while  ( curs.next() ) {
      h+= "<TR ALIGN=" + params.hAlign + " VALIGN=" + params.vAlign + ">"
      for (i = 0; i < curs.columns(); i++) {
         h += "<TD" + ( (params.nowrap) ? " NOWRAP>" : ">") + detailLink(params, curs, curs.columnName(i)) + "</TD>"
	}
      h += "</TR>"
   }
   h += "</TABLE>"
   curs.close()
   if ( (params.release) && (server.httpdlwVersion.indexOf("1.0") == -1) )
      curs.DBConnection.release()

   write( h )
} // function netscape_peas_CustomTable
    </JSB_CONSTRUCTOR>
</JSB>
