<JSB>
/*
 * BufferedCursor.jsb    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */
     <JSB_DESCRIPTOR NAME="netscape.peas.BufferedCursor" DISPLAYNAME="Buffered Cursor" ISHIDDEN ENV="both"
        SHORTDESCRIPTION="JavaScript-Buffered Database Cursor">

    <JSB_PROPERTY NAME="database" DISPLAYNAME="Database" PROPTYPE="JS-expr" TYPE="object" ENV="server"
        SHORTDESCRIPTION="Name of LiveWire database object to operate on">

    <JSB_PROPERTY NAME="SQL" DISPLAYNAME="SQL Query" ISRUNTIME PROPTYPE="JS" TYPE="SQLQuery" ENV="server"
        SHORTDESCRIPTION="SQL query that defines cursor">

    <JSB_PROPERTY NAME="updatable" DISPLAYNAME="Updatable" PROPTYPE="JS-expr" TYPE="boolean" ENV="both"
        SHORTDESCRIPTION="Specifies if cursor is updatable">

    <JSB_PROPERTY NAME="maxRows" DISPLAYNAME="Max. Rows" PROPTYPE="JS" TYPE="number" ENV="server"
        VALUESET="1:32767"
        SHORTDESCRIPTION="Maximum number of rows to fetch">

    <JSB_PROPERTY NAME="numRows" DISPLAYNAME="Number Rows" ISRUNTIME PROPTYPE="JS" TYPE="number" ENV="both"
        VALUESET="1:32767"
        SHORTDESCRIPTION="Number of rows actually fetched">

    <JSB_PROPERTY NAME="currentRowNumber" DISPLAYNAME="Current Row Number" ISRUNTIME PROPTYPE="JS" TYPE="number" ENV="client"
        VALUESET="1:32767"
        READMETHOD="" WRITEMETHOD="setCurrentRowNumber"
        SHORTDESCRIPTION="Current Row Number (run time)">

    <JSB_METHOD NAME="next" TYPE="boolean" ENV="client"> </JSB_METHOD>

    <JSB_METHOD NAME="previous" TYPE="boolean" ENV="client"> </JSB_METHOD>

    <JSB_METHOD NAME="setCurrentRowNumber" TYPE="void" ENV="client">
        <JSB_PARAMETER NAME="newRowNumber" TYPE="Int">
    </JSB_METHOD>


    <JSB_EVENT NAME="onChange" LISTENERMETHODS="onChange" LISTENERTYPE="onChangeListener" EVENTMODEL="JS">

    <JSB_CONSTRUCTOR>
writeln("<SCRIPT SRC='cBufferedCursor.js'></SCRIPT>")

function netscape_peas_BufferedCursor(params) {
    	if ( (params.database == null) || (params.database == "") )
    	     params.database = "database"

	if (server.httpdlwVersion.indexOf("1.0") != -1)  // Server 2.0 (LiveWire version 1.0)
           cursorObj = database.cursor(params.SQL, params.updatable)
  	else {                                          // Server 3.0
  	    dbObj = eval(params.database)
          cursorObj = dbObj.cursor(params.SQL, params.updatable)
    }
           cursorObj.cursorName = params.id
           cursorObj.maxRows = params.maxRows
           createClientSideJSCursor(cursorObj)
           return cursorObj
} // netscape_peas_BufferedCursor
    </JSB_CONSTRUCTOR>
</JSB>

<JSB_LISTENER NAME="onChangeListener">
    <JSB_METHOD NAME="onChange" TYPE="void">
        <JSB_PARAMETER NAME="propertyName" TYPE="string">
        <JSB_PARAMETER NAME="oldValue" TYPE="undefined">
        <JSB_PARAMETER NAME="newValue" TYPE="undefined">
    </JSB_METHOD>
</JSB_LISTENER>
