/*
 * LDAPTableQueryBeanInfo.java    1.1
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */
package netscape.ldap.beans;

import java.beans.*;

/**
 * BeanInfo for LDAPTableQuery.
 *
 * History:
 *  v1.0: Rob Weltman
 *  v1.1: cdk_team
 */
public class LDAPTableQueryBeanInfo extends SimpleBeanInfo {

    public LDAPTableQueryBeanInfo() throws Exception {
        super();
        beanClass = Class.forName( "netscape.ldap.beans.LDAPTableQuery" );

        // Publish events --------------------------------------------------
        try {
            _eventSetDescriptor = new EventSetDescriptor[3];

            _eventSetDescriptor[0] = new EventSetDescriptor(beanClass,
					"propertyChange",
					Class.forName("java.beans.PropertyChangeListener"),
			        "propertyChange");

            _eventSetDescriptor[1] = new EventSetDescriptor(beanClass,
					"rowChange",
					Class.forName("netscape.peas.RowChangeListener"),
			        "rowChange");

            _eventSetDescriptor[2] = new EventSetDescriptor(beanClass,
					"tableChange",
					Class.forName("netscape.peas.TableChangeListener"),
			        "tableChange");

        } catch (Exception e) {
            System.out.println("BIG PROBLEM!");
            throw new Error(e.toString());
        }

        // Publish descriptor ---------------------------------------------
        try {
            _beanDescriptor = new BeanDescriptor(beanClass);
			_beanDescriptor.setDisplayName( "LDAP property retrieval" );
			_beanDescriptor.setShortDescription(
				"LDAP table-based property retrieval" );
        } catch (Exception e) {
        }
    }


    public EventSetDescriptor[] getEventSetDescriptors() {
        return _eventSetDescriptor;
    }


    public int getDefaultEventIndex() {
        return -1;
    }

    public int getDefaultPropertyIndex() {
        return -1;
    }

    public BeanDescriptor getBeanDescriptor() {
		return _beanDescriptor;
	}

    private static Class beanClass;
	private BeanDescriptor _beanDescriptor;
    private EventSetDescriptor[] _eventSetDescriptor;
}


