/*
 * netscape.palomar.util.NSCustomizer.java    1.0 97/11/06
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * This file is not modifiable.
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape; and iii) the file is unmodified.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */
package netscape.palomar.util;

import java.beans.Customizer;

/**
 * NSCustomizer can be implemented to get additional customizer
 * capabilities when loaded in Netscape Visual JavaScript
 */
public interface NSCustomizer extends Customizer, Observer {

    /**
     * If a customizer implements JSCustomizer, then this
     * setObjectInspectable will be called instead of the the
     * regular setObject.  This allows the customizer to have access
     * to both the Java Bean, as well as the tag object that
     * contains the bean on the page.
     */
    public void setObjectInspectable(Object bean, Inspectable tag) throws CascadedException ;

    /**
     * If the customizer returns a Netscape IFC View, it will be used
     * and placed into an internal window.
	 *
	 * If the customizer returns an AWT Panel, it will be used and 
	 * placed externally.
     */
    public Object getCustomizerView() throws CascadedException ;

}
