/*
 * CircleVisual.java   1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */
package netscape.samples.simple;

import java.awt.*;

/**
 * A component that is the design time visual for a JavaScript Bean.
 *
 * Draws a red circle.
 *
 */
public class CircleVisual extends Component {
     /**
      * Called to draw to component.
      */
     public void paint(Graphics g) {
        Dimension size = getSize();
        int width = size.width - 1;
        int height = size.height - 1;

        g.setFont(getFont());
        g.setColor(Color.red);

        g.fillOval(0,0,width,height);
     }

 /**
  * Lets return our preferred size.
  */
 public Dimension preferredSize() {
    return _preferredSize;
 }

 private Dimension _preferredSize = new Dimension(30,30);

}

