/*
 * ParseJSB.java    1.0 97/11/06
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 * -garys
 */
package netscape.samples.jsbdoc; 

import java.io.*;
import java.util.*;

public class ParseJSB {
    private static String JSBname = "";
    private static String docComments = "";
    private static String parsedDoc = "";
    private static String line = "";
    private static Vector fileLines   = new Vector();

    public ParseJSB() {
    }

    public ParseJSB(String name) {
        JSBname = name;
    }

    public static void setFileLines(Vector fl) {
        fileLines = fl;
    }
    public static Vector getFileLines() {
        return fileLines;
    }

    public static void setParsedDoc() {
        setJSBtags();
        setDoc();
    }
    public static String getParsedDoc() {
        return parsedDoc;
    }

    private static int currentLine = 0;
    private static Vector JSBtags     = new Vector();
    private static String JSBparam = "";

    public static void setJSBtags() {
        while(currentLine < fileLines.size()) {
            setLine();
            docComments += getComments();
            if(line.indexOf("<JSB_") != -1 && line.indexOf("//") == -1 && line.indexOf("*") == -1) {
                try {
                    String saveLine = line;
                    while(line.indexOf(">") == -1) {
                        setLine();
                        saveLine += " " + line;
                    }
                    line = saveLine;
                    
                    JSBparam = "";
                    setJSBdescripter();
                    setJSB_METHOD();
                    setJSB_LISTENER();
                    setJSB_CONSTRUCTOR();
                    String tag = "";
                    String attributes = "";
                    if(line.indexOf("<JSB_") != -1 && line.indexOf(" ") > line.indexOf("<JSB_")) {
                        try {
                            tag = line.substring(line.indexOf("JSB_"), line.indexOf(" ",line.indexOf("JSB_")) );
                            attributes = line.substring(line.indexOf(" ",line.indexOf("JSB_")), line.indexOf(">",line.indexOf("JSB_")));
                        } catch (Exception e) {
                            System.out.println("Error on line " + currentLine + ":\n" + e);
                        }
                    }
                    if(tag.equals("")) continue;
                    String JSBpairs = "";
                    StringTokenizer st = new StringTokenizer(attributes,"\"");
                    while(st.hasMoreTokens()) {
                        JSBpairs += "<DD>" + st.nextToken().trim();
                        if(st.hasMoreTokens()) JSBpairs += st.nextToken().trim() +"\n";
                    }
                    JSBtags.addElement(new String(tag +"\n"+ JSBpairs +"\n"+ JSBparam  +"\n<P>\n"+ docComments));
                    docComments = "";
                } catch (Exception e) {
                    System.out.println("Error line " + currentLine + ":\n" + e);
                }
            }
        }
    }

    private static Hashtable tagIndex = new Hashtable();
    private static Hashtable tagDesc  = new Hashtable();

    public static void setDoc() {
        for(int i=0; i < JSBtags.size(); i++) {
            String ref, tag, tagName, attributes = "";
            ref = JSBtags.elementAt(i).toString();
            tag = ref.substring(0, ref.indexOf("\n"));
            if(tag.indexOf("JSB_") == -1) continue; 
            if(tag.indexOf("JSB_CONSTRUCTOR") != -1) {
                //System.out.println("JSB_CONSTRUCTOR"+ i +"=" + tag);
            } else {
                int beg = ref.indexOf("=", ref.indexOf("NAME")) +1;
                if(ref.indexOf("\n",beg) == -1) tagName = ref.substring(beg);
                else tagName = ref.substring(beg, ref.indexOf("\n",beg));
                attributes = ref.substring(ref.indexOf("\n", beg));
                if(tag.indexOf("JSB_METHOD") != -1 && JSB_METHODdesc.get(tagName) != null) attributes += JSB_METHODdesc.get(tagName).toString();

                if(tagIndex.get(tag) == null) {
                    String tagIndexHeading = "</UL>\n\n<!--"+ tag +" Index-->\n<B>"+ tag +" Index</B>\n<UL>\n <B><LI><A HREF=\"#"+ tagName +"\">"+ tagName +"</A></B>\n";
                    String tagDescHeading  = "</UL>\n\n<!--"+ tag +" Desc--> \n<H2><FONT COLOR=\"green\">"+ tag +"s</FONT></H2>\n<UL>\n <H2><LI><A NAME=\""+ tagName +"\">"+ tagName +"</A></H2>\n<DL>\n<DD>NAME=" + tagName + attributes + "\n</DL>\n";
                    tagIndex.put(tag, tagIndexHeading);
                    tagDesc.put(tag, tagDescHeading);
                } else {
                    String prevIndex = tagIndex.get(tag).toString();
                    String prevDesc = tagDesc.get(tag).toString();
                    //tagIndex.remove(tag);
                    tagIndex.put(tag, prevIndex + " <B><LI><A HREF=\"#"+ tagName +"\">"+ tagName +"</A></B>\n");
                    tagDesc.put(tag,  prevDesc  + " <H2><LI><A NAME=\""+ tagName +"\">" + tagName +"</A></H2>\n<DL>\n<DD>NAME=" + tagName + attributes + "\n</DL>\n");
                }
            }
        }
        String tagIndexTotal = "";
        Enumeration enum = tagIndex.elements();
        while(enum.hasMoreElements()) {
            tagIndexTotal = enum.nextElement() + tagIndexTotal;
        }
        String tagDescTotal = "";
        enum = tagDesc.elements();
        while(enum.hasMoreElements()) {
            tagDescTotal = enum.nextElement() + tagDescTotal;
        }
        String JSB_CONSTRUCTORindex = "";
        String JSB_CONSTRUCTORdesc  = "";
        if(JSB_CONSTRUCTOR != "") {
            JSB_CONSTRUCTORindex = "\n<!--JSB_CONSTRUCTOR Index-->\n<B>JSB_CONSTRUCTOR Index</B>\n<UL>\n <B><LI><A HREF=\"#"+ JSB_CONSTRUCTORname +"\">"+ JSB_CONSTRUCTORname +"</A></B>\n";
            JSB_CONSTRUCTORdesc  = "\n<!--JSB_CONSTRUCTOR Desc--> \n<H2><FONT COLOR=\"green\">JSB_CONSTRUCTORs</FONT></H2>\n<UL>\n <H2><LI><A NAME=\""+ JSB_CONSTRUCTORname +"\">"+ JSB_CONSTRUCTORname +"</A></H2>\n<DL>\n<DD>" + JSB_CONSTRUCTOR + "\n</UL>\n";
        }
        Date now = new Date();
        parsedDoc = "<!-- NewFile -->\n<HTML>\n<HEAD>\n<!-- Generated by jsbdoc on " + now +" -->\n";
        parsedDoc += "<TITLE>"+ JSBname +" - jsbdoc </TITLE>\n</HEAD>\n<BODY>\n<A NAME=\"_top_\"></A>\n<H2>JavaScript Bean</H2>\n<H1>"+ JSBname +"</H1>\n"+ JSBdescripter +"<HR><BR>\n";
        parsedDoc +=  JSB_CONSTRUCTORindex + tagIndexTotal + "\n</UL>\n\n<HR>\n" + JSB_CONSTRUCTORdesc + tagDescTotal + "\n</UL>\n";
        parsedDoc += "<HR>\nGenerated by jsbdoc on "+ now +"\n</BODY></HTML>";
    }

    private static String JSBdescripter = "";

    public static void setJSBdescripter() {
        if(line.indexOf("JSB_DESCRIPTOR") != -1 && line.indexOf("\"") != -1) {
            int firstQuote = line.indexOf("\"", line.indexOf(" NAME=")) +1; 
            String name = line.substring(firstQuote, line.indexOf("\"", firstQuote)); 
            JSBdescripter = "<PRE>\nObject\n    |\n    +----" + name + "</PRE>"; 
        }
    }

    private static String JSBpackage = "";

    public static void setJSBpackage() {
        if(line.indexOf("JSB_DESCRIPTOR") != -1) {
            int firstQuote = line.indexOf("\"", line.indexOf(" NAME=")) +1; 
            JSBpackage = line.substring(firstQuote, line.indexOf(JSBname, firstQuote) -1); 
            String spaces = "";
            for(int i=0; i < JSBpackage.length() -1; i++) { spaces += " "; }
            JSBpackage = "<PRE>\n" + JSBpackage + "\n" + spaces + "|\n" + spaces + "+----" + JSBname + "</PRE>"; 
        }
    }

    private static Hashtable JSB_METHODdesc = new Hashtable();

    public static void setJSB_METHOD() {
        if(line.indexOf("JSB_METHOD") != -1) { //could have subtags (params)
            String saveLine = line;
            if(line.indexOf(" NAME") != -1) { //has no subtags
                int firstQuote = line.indexOf("\"", line.indexOf(" NAME=")) +1; 
                String JSB_METHODname = line.substring(firstQuote, line.indexOf("\"", firstQuote)); 
                JSB_METHODdesc.put(JSB_METHODname, docComments);
                docComments = "";
            }
            if(line.indexOf("</JSB_METHOD") != -1) { //has no param subtags
            } else {
                setLine();
                while(line.indexOf("JSB_PARAMETER") != -1 && line.indexOf("</JSB_METHOD") == -1) {
                    JSBparam += "   <DD>" + line.substring(line.indexOf("<") +1, line.indexOf(">")) +"\n";
                    setLine();
                }
            }
            line = saveLine;
        }
    }

    public static void setJSB_LISTENER() {
        if(line.indexOf("JSB_LISTENER") != -1) { //could have subtags (params)
            String saveLine = line;
            if(line.indexOf("</JSB_LISTENER") != -1) { //has no subtags
            } else {
                setLine();
                while(line.indexOf("JSB_") != -1 && line.indexOf("</JSB_LISTENER") == -1) {
                    if(line.indexOf("</JSB_") > -1) JSBparam += "<P>\n";
                    else JSBparam += "   <DD>" + line.substring(line.indexOf("<") +1, line.indexOf(">")) +"\n";
                    setLine();
                }
            }
            line = saveLine;
        }
    }

    private static String JSB_CONSTRUCTORname = "";
    private static String JSB_CONSTRUCTOR = "";
    private static Hashtable functionDesc = new Hashtable();

    public static void setJSB_CONSTRUCTOR() {
        //if(JSB_CONSTRUCTOR != "") return;
        if(line.indexOf("JSB_CONSTRUCTOR") != -1) {
            String saveComments = getComments();
            if(line.indexOf("</JSB_CONSTRUCTOR") != -1) { 
                JSB_CONSTRUCTOR = line;  //on same line
            } else if(line.indexOf(" ", line.indexOf("JSB_CONSTRUCTOR")) != -1) { 
                JSB_CONSTRUCTOR = line;  //could contain attributes
            } else {
                setLine();
                while(line.indexOf("</JSB_CONSTRUCTOR") == -1) {
                    docComments += getComments();
                    if(line.indexOf("function ") != -1 && line.indexOf(JSBname) != -1) {
                        if(line.indexOf("{") > line.indexOf("function ")) line = line.substring(0, line.lastIndexOf("{"));
                        JSB_CONSTRUCTOR = line;
                        if(line.indexOf(" ") > line.indexOf("function")) line = line.substring(line.indexOf(" ", line.indexOf("function")) +1);
                        if(line.indexOf("(") > -1) JSB_CONSTRUCTORname = line.substring(0, line.indexOf("("));
                        JSB_CONSTRUCTOR = "\n<PRE><XMP>function " + line + "</XMP></PRE>\n" + docComments;
                        docComments = "";
                    } else if(line.indexOf("function ") != -1 && line.indexOf("(") > line.indexOf("function ") ) {
                        String funName = line.substring(line.indexOf(" ",line.indexOf("function ")) +1, line.indexOf("("));
                        funName.trim();
                        if(JSBdescripter.indexOf(".") != -1 && funName.indexOf("_") != -1) {
                             int lastScore = funName.lastIndexOf("_");
                             funName = funName.substring(lastScore +1);
                        }
                        if(JSB_METHODdesc.get(funName) != null) {
                            String tagComments = JSB_METHODdesc.get(funName).toString();
                            JSB_METHODdesc.put(funName, tagComments + docComments);
                        }
                        docComments = "";
                    }
                    setLine();
                }
            }
            JSB_CONSTRUCTOR = saveComments + JSB_CONSTRUCTOR;
            line = "JSB_CONSTRUCTOR ";
        }
    }

    public static String getComments() {
        String comments = "";
	    if(line.indexOf("/**") != -1 && line.indexOf("*/") == -1) {
            setLine();
            while (line.indexOf("*") != -1 && line.indexOf("*/") == -1 && line.indexOf("<JSB_") == -1) {
                if(line.indexOf("@see") != -1) {
                    comments += "<DL>\n    <DT> <B>See Also:</B>\n    <DD> <A HREF=\"#"+ line.substring( (line.indexOf("@see") +5), line.length() ) +"\">"+ line.substring( (line.indexOf("@see") +4), line.length() ) +"</A>\n</DL>\n";
                } else {
                    comments += line.substring(line.indexOf("* ") +2) + "\n"; 
                }
                setLine();
            }
        } else if(line.indexOf("/**") == -1 && line.indexOf("*/") != -1) {
            setLine();
            comments += ""; 
        }
        if(comments != "" && comments != " ") {
            comments = "\n <DD>" + comments;
        }
        return comments;
    }

    public static void setLine() {
        line = fileLines.elementAt(currentLine++).toString();
        line = line.trim();
    }

    public static void main(String args[]) {
        System.out.println("this is a class used for jsbdoc");
    }
}
