/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.metadata.AbstractMetadata;
import org.apache.sis.metadata.InvalidMetadataException;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.util.Classes;
import org.apache.sis.util.CorruptedObjectException;
import org.apache.sis.util.resources.Errors;

public class Merger {
    private final Map<Object, Boolean> done = new IdentityHashMap<Object, Boolean>();
    protected final Locale locale;

    public Merger(Locale locale) {
        this.locale = locale;
    }

    private Errors errors() {
        return Errors.getResources(this.locale);
    }

    private static String name(ModifiableMetadata modifiableMetadata, String string) {
        return Classes.getShortName(modifiableMetadata.getInterface()) + '.' + string;
    }

    public final void copy(Object object, ModifiableMetadata modifiableMetadata) {
        if (!this.copy(object, modifiableMetadata, false)) {
            throw new InvalidMetadataException(this.errors().getString((short)43, "target", modifiableMetadata.getStandard().getInterface(object.getClass()), Classes.getClass(modifiableMetadata)));
        }
    }

    private boolean copy(Object object, ModifiableMetadata modifiableMetadata, boolean bl) {
        MetadataStandard metadataStandard = modifiableMetadata.getStandard();
        if (!metadataStandard.getInterface(object.getClass()).isInstance(modifiableMetadata)) {
            return false;
        }
        Object object2 = this.done.put(object, Boolean.FALSE);
        Map<String, Object> map = this.done.put(modifiableMetadata, Boolean.TRUE);
        if (object2 != null || map != null) {
            if (Boolean.FALSE.equals(object2) && Boolean.TRUE.equals(map)) {
                return true;
            }
            throw new IllegalArgumentException(this.errors().getString((short)167));
        }
        object2 = modifiableMetadata.asMap();
        map = object instanceof AbstractMetadata ? ((AbstractMetadata)object).asMap() : metadataStandard.asValueMap(object, null, KeyNamePolicy.JAVABEANS_PROPERTY, ValueExistencePolicy.NON_EMPTY);
        boolean bl2 = true;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string = entry.getKey();
            Object object3 = entry.getValue();
            Object object4 = bl ? object2.get(string) : JDK8.putIfAbsentConservative(object2, string, object3);
            if (object4 == null) continue;
            if (object4 instanceof ModifiableMetadata) {
                bl2 = this.copy(object3, (ModifiableMetadata)object4, bl);
                if (bl2) continue;
                if (bl) break;
                throw new InvalidMetadataException(this.errors().getString((short)59, Merger.name(modifiableMetadata, string), ((ModifiableMetadata)object4).getInterface(), Classes.getClass(object3)));
            }
            if (object4 instanceof Collection) {
                Object object5;
                Iterator iterator;
                if (bl) continue;
                Collection collection = (Collection)object4;
                LinkedList linkedList = new LinkedList((Collection)object3);
                block5: for (Object e : collection) {
                    if (!(e instanceof ModifiableMetadata)) continue;
                    iterator = linkedList.iterator();
                    while (iterator.hasNext()) {
                        object5 = iterator.next();
                        switch (this.resolve(object5, (ModifiableMetadata)e)) {
                            case MERGE: {
                                if (!this.copy(object5, (ModifiableMetadata)e, false)) break;
                            }
                            case IGNORE: {
                                iterator.remove();
                                continue block5;
                            }
                        }
                    }
                }
                for (Object e : linkedList) {
                    iterator = object2.put(string, e);
                    if (iterator instanceof Collection && (object5 = (Collection)((Object)iterator)).size() <= collection.size()) {
                        assert (collection.containsAll((Collection<?>)object5)) : string;
                        continue;
                    }
                    throw new InvalidMetadataException(this.errors().getString((short)160, Classes.getShortClassName(collection)));
                }
                continue;
            }
            bl2 = object4.equals(object3);
            if (bl2) continue;
            if (bl) break;
            this.merge(modifiableMetadata, string, object3, object4);
            bl2 = true;
        }
        if (!(!bl || Boolean.FALSE.equals(this.done.remove(object)) && Boolean.TRUE.equals(this.done.remove(modifiableMetadata)))) {
            throw new CorruptedObjectException();
        }
        return bl2;
    }

    protected Resolution resolve(Object object, ModifiableMetadata modifiableMetadata) {
        return this.copy(object, modifiableMetadata, true) ? Resolution.MERGE : Resolution.SEPARATE;
    }

    protected void merge(ModifiableMetadata modifiableMetadata, String string, Object object, Object object2) {
        throw new InvalidMetadataException(this.errors().getString((short)164, Merger.name(modifiableMetadata, string)));
    }

    public static enum Resolution {
        MERGE,
        SEPARATE,
        IGNORE;

    }
}

