/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.builder;

import java.nio.file.Path;
import javax.measure.quantity.Dimensionless;
import org.apache.sis.internal.referencing.provider.DatumShiftGridFile;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.operation.Matrix;

final class ResidualGrid
extends DatumShiftGridFile<Dimensionless, Dimensionless> {
    private static final long serialVersionUID = -6661539177698674636L;
    private static final ParameterDescriptorGroup PARAMETERS;
    private final double[] offsets;
    private final int numDim;
    private final LinearTransform gridToTarget;

    ResidualGrid(LinearTransform linearTransform, LinearTransform linearTransform2, int n, int n2, int n3, double[] dArray, double d) {
        super(Units.UNITY, Units.UNITY, true, linearTransform, n, n2, PARAMETERS, new Path[0]);
        this.gridToTarget = linearTransform2;
        this.numDim = n3;
        this.offsets = dArray;
        this.accuracy = d;
    }

    private ResidualGrid(ResidualGrid residualGrid, double[] dArray) {
        super(residualGrid);
        this.gridToTarget = residualGrid.gridToTarget;
        this.numDim = residualGrid.numDim;
        this.accuracy = residualGrid.accuracy;
        this.offsets = dArray;
    }

    @Override
    protected DatumShiftGridFile<Dimensionless, Dimensionless> setData(Object[] objectArray) {
        return new ResidualGrid(this, (double[])objectArray[0]);
    }

    @Override
    protected Object[] getData() {
        return new Object[]{this.offsets};
    }

    @Override
    public Matrix gridToTarget() {
        return this.gridToTarget.getMatrix();
    }

    @Override
    public int getTranslationDimensions() {
        return this.numDim;
    }

    @Override
    public double getCellPrecision() {
        return this.accuracy;
    }

    @Override
    public double getCellValue(int n, int n2, int n3) {
        return this.offsets[(n2 + n3 * this.nx) * this.numDim + n];
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            return this.numDim == ((ResidualGrid)object).numDim;
        }
        return false;
    }

    static {
        ParameterBuilder parameterBuilder = new ParameterBuilder();
        PARAMETERS = ((ParameterBuilder)parameterBuilder.addName("Localization grid")).createGroup(new GeneralParameterDescriptor[0]);
    }
}

