/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.parameter.ParameterValueList;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.parameter.Verifier;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterCardinalityException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;

@XmlType(name="ParameterValueGroupType", propOrder={"values", "descriptor"})
@XmlRootElement(name="ParameterValueGroup")
public class DefaultParameterValueGroup
extends Parameters
implements LenientComparable,
Serializable {
    private static final long serialVersionUID = -1985309386356545126L;
    private ParameterValueList values;

    public DefaultParameterValueGroup(ParameterDescriptorGroup parameterDescriptorGroup) {
        ArgumentChecks.ensureNonNull("descriptor", parameterDescriptorGroup);
        this.values = new ParameterValueList(parameterDescriptorGroup);
    }

    public DefaultParameterValueGroup(ParameterValueGroup parameterValueGroup) {
        ArgumentChecks.ensureNonNull("parameters", parameterValueGroup);
        this.values = new ParameterValueList(parameterValueGroup.getDescriptor());
        this.values.addAll(parameterValueGroup.values());
    }

    @Override
    boolean isKnownImplementation() {
        return this.getClass() == DefaultParameterValueGroup.class;
    }

    @Override
    @XmlElement(name="group")
    public ParameterDescriptorGroup getDescriptor() {
        return this.values != null ? this.values.descriptor : null;
    }

    @Override
    public List<GeneralParameterValue> values() {
        return this.values;
    }

    @Override
    public ParameterValue<?> parameter(String string) throws ParameterNotFoundException {
        ArgumentChecks.ensureNonNull("name", string);
        ParameterValue<Object> parameterValue = this.parameterIfExist(string);
        if (parameterValue == null) {
            GeneralParameterDescriptor generalParameterDescriptor = this.values.descriptor.descriptor(string);
            if (!(generalParameterDescriptor instanceof ParameterDescriptor) || generalParameterDescriptor.getMaximumOccurs() == 0) {
                throw new ParameterNotFoundException(Resources.format((short)61, Verifier.getDisplayName(this.values.descriptor), string), string);
            }
            parameterValue = ((ParameterDescriptor)generalParameterDescriptor).createValue();
            this.values.addUnchecked(parameterValue);
        }
        return parameterValue;
    }

    @Override
    ParameterValue<?> parameterIfExist(String string) throws ParameterNotFoundException {
        GeneralParameterDescriptor generalParameterDescriptor;
        ParameterValueList parameterValueList = this.values;
        int n = -1;
        int n2 = -1;
        int n3 = parameterValueList.size();
        for (int i = 0; i < n3; ++i) {
            generalParameterDescriptor = parameterValueList.descriptor(i);
            if (!(generalParameterDescriptor instanceof ParameterDescriptor) || !IdentifiedObjects.isHeuristicMatchForName(generalParameterDescriptor, string)) continue;
            if (n < 0) {
                n = i;
                continue;
            }
            n2 = i;
        }
        if (n2 < 0) {
            return n >= 0 ? (ParameterValue)parameterValueList.get(n) : null;
        }
        GeneralParameterDescriptor generalParameterDescriptor2 = parameterValueList.descriptor(n);
        String string2 = generalParameterDescriptor2 == (generalParameterDescriptor = parameterValueList.descriptor(n2)) ? Errors.format((short)173, string, n, n2) : Errors.format((short)1, IdentifiedObjects.toString(generalParameterDescriptor2.getName()), IdentifiedObjects.toString(generalParameterDescriptor.getName()), string);
        throw new ParameterNotFoundException(string2, string);
    }

    @Override
    public List<ParameterValueGroup> groups(String string) throws ParameterNotFoundException {
        ParameterDescriptorGroup parameterDescriptorGroup;
        ArgumentChecks.ensureNonNull("name", string);
        ParameterValueList parameterValueList = this.values;
        ArrayList<ParameterValueGroup> arrayList = new ArrayList<ParameterValueGroup>(4);
        int n = parameterValueList.size();
        for (int i = 0; i < n; ++i) {
            GeneralParameterDescriptor generalParameterDescriptor = parameterValueList.descriptor(i);
            if (!(generalParameterDescriptor instanceof ParameterDescriptorGroup) || !IdentifiedObjects.isHeuristicMatchForName(generalParameterDescriptor, string)) continue;
            arrayList.add((ParameterValueGroup)parameterValueList.get(i));
        }
        if (arrayList.isEmpty() && !((parameterDescriptorGroup = parameterValueList.descriptor).descriptor(string) instanceof ParameterDescriptorGroup)) {
            throw new ParameterNotFoundException(Resources.format((short)61, Verifier.getDisplayName(parameterDescriptorGroup), string), string);
        }
        return arrayList;
    }

    @Override
    public ParameterValueGroup addGroup(String string) throws ParameterNotFoundException, InvalidParameterCardinalityException {
        ParameterValueList parameterValueList = this.values;
        ParameterDescriptorGroup parameterDescriptorGroup = parameterValueList.descriptor;
        GeneralParameterDescriptor generalParameterDescriptor = parameterDescriptorGroup.descriptor(string);
        if (!(generalParameterDescriptor instanceof ParameterDescriptorGroup)) {
            throw new ParameterNotFoundException(Resources.format((short)61, parameterDescriptorGroup.getName(), string), string);
        }
        ParameterValueGroup parameterValueGroup = ((ParameterDescriptorGroup)generalParameterDescriptor).createValue();
        parameterValueList.add(parameterValueGroup);
        return parameterValueGroup;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (object != null) {
            if (comparisonMode == ComparisonMode.STRICT) {
                if (this.getClass() == object.getClass()) {
                    DefaultParameterValueGroup defaultParameterValueGroup = (DefaultParameterValueGroup)object;
                    return Objects.equals(this.values.descriptor, defaultParameterValueGroup.values.descriptor) && Objects.equals(this.values, defaultParameterValueGroup.values);
                }
            } else if (object instanceof ParameterValueGroup) {
                return DefaultParameterValueGroup.equals(this, (ParameterValueGroup)object, comparisonMode);
            }
        }
        return false;
    }

    static boolean equals(Parameters parameters, ParameterValueGroup parameterValueGroup, ComparisonMode comparisonMode) {
        if (!Utilities.deepEquals(parameters.getDescriptor(), parameterValueGroup.getDescriptor(), comparisonMode)) {
            return false;
        }
        if (!comparisonMode.isIgnoringMetadata()) {
            return Utilities.deepEquals(parameters.values(), parameterValueGroup.values(), comparisonMode);
        }
        LinkedList<GeneralParameterValue> linkedList = new LinkedList<GeneralParameterValue>(parameters.values());
        block0: for (GeneralParameterValue generalParameterValue : parameterValueGroup.values()) {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                if (!Utilities.deepEquals(iterator.next(), generalParameterValue, comparisonMode)) continue;
                iterator.remove();
                continue block0;
            }
            return false;
        }
        return linkedList.isEmpty();
    }

    @Override
    public final boolean equals(Object object) {
        return this.equals(object, ComparisonMode.STRICT);
    }

    public int hashCode() {
        return this.values.descriptor.hashCode() ^ this.values.hashCode();
    }

    @Override
    public DefaultParameterValueGroup clone() {
        DefaultParameterValueGroup defaultParameterValueGroup = (DefaultParameterValueGroup)super.clone();
        defaultParameterValueGroup.values = new ParameterValueList(defaultParameterValueGroup.values);
        return defaultParameterValueGroup;
    }

    private DefaultParameterValueGroup() {
    }

    private void setDescriptor(ParameterDescriptorGroup parameterDescriptorGroup) {
        if (this.values == null) {
            this.values = new ParameterValueList(parameterDescriptorGroup);
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultParameterValue.class, "setDescriptor", "group");
        }
    }

    @XmlElement(name="parameterValue", required=true)
    private GeneralParameterValue[] getValues() {
        List<GeneralParameterValue> list = this.values();
        return list.toArray(new GeneralParameterValue[list.size()]);
    }

    private void setValues(GeneralParameterValue[] generalParameterValueArray) {
        ParameterValueList parameterValueList = this.values;
        if (parameterValueList == null) {
            parameterValueList = new ParameterValueList(new DefaultParameterDescriptorGroup());
        }
        IdentityHashMap<GeneralParameterDescriptor, GeneralParameterDescriptor> identityHashMap = new IdentityHashMap<GeneralParameterDescriptor, GeneralParameterDescriptor>(4);
        ((DefaultParameterDescriptorGroup)parameterValueList.descriptor).merge(DefaultParameterValueGroup.getDescriptors(generalParameterValueArray), identityHashMap);
        parameterValueList.clear();
        this.setValues(generalParameterValueArray, identityHashMap, parameterValueList);
    }

    private void setValues(GeneralParameterValue[] generalParameterValueArray, Map<GeneralParameterDescriptor, GeneralParameterDescriptor> map, ParameterValueList parameterValueList) {
        if (generalParameterValueArray == null) {
            generalParameterValueArray = this.values.toArray();
        }
        for (GeneralParameterValue generalParameterValue : generalParameterValueArray) {
            GeneralParameterDescriptor generalParameterDescriptor = map.get(generalParameterValue.getDescriptor());
            if (generalParameterDescriptor != null) {
                if (generalParameterValue instanceof DefaultParameterValue) {
                    ((DefaultParameterValue)generalParameterValue).setDescriptor((ParameterDescriptor)generalParameterDescriptor);
                } else if (generalParameterValue instanceof DefaultParameterValueGroup) {
                    ((DefaultParameterValueGroup)generalParameterValue).setValues(null, map, new ParameterValueList((ParameterDescriptorGroup)generalParameterDescriptor));
                }
            }
            parameterValueList.add(generalParameterValue);
        }
        this.values = parameterValueList;
    }
}

