/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.sis.internal.converter.SurjectiveConverter;
import org.apache.sis.internal.simple.SimpleCharacterIterator;
import org.apache.sis.measure.FormatField;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.Containers;

final class FormattedCharacterIterator
extends SimpleCharacterIterator
implements AttributedCharacterIterator {
    private static final long serialVersionUID = -5864519830922231670L;
    private final Map<AttributedCharacterIterator.Attribute, Entry> attributes = new IdentityHashMap<AttributedCharacterIterator.Attribute, Entry>(8);
    private transient Set<AttributedCharacterIterator.Attribute> attributeKeys;
    private transient AttributedCharacterIterator.Attribute runAttribute;
    private transient int start;
    private transient int limit;
    private transient int validity;

    FormattedCharacterIterator(CharSequence charSequence) {
        super(charSequence);
    }

    final void addFieldLimit(AttributedCharacterIterator.Attribute attribute, Object object, int n) {
        this.upper = this.text.length();
        Entry entry = new Entry(attribute, object, n, this.upper, this.attributes);
        assert ((entry = entry.previous) == null || n >= entry.limit);
    }

    final void append(AttributedCharacterIterator attributedCharacterIterator, StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        int n2 = 0;
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            stringBuffer.append(c);
            if (attributedCharacterIterator.getIndex() == n2) {
                n2 = attributedCharacterIterator.getRunLimit();
                for (Map.Entry<AttributedCharacterIterator.Attribute, Object> entry : attributedCharacterIterator.getAttributes().entrySet()) {
                    AttributedCharacterIterator.Attribute attribute = entry.getKey();
                    if (attributedCharacterIterator.getRunLimit(attribute) != n2) continue;
                    Entry entry2 = new Entry(attribute, entry.getValue(), n + attributedCharacterIterator.getRunStart(attribute), n + n2, this.attributes);
                }
            }
            c = attributedCharacterIterator.next();
        }
        this.upper = stringBuffer.length();
    }

    private void update(AttributedCharacterIterator.Attribute attribute, Collection<Entry> collection) {
        int n = this.getIndex();
        if (attribute == null || attribute != this.runAttribute || n != this.validity) {
            this.runAttribute = attribute;
            this.validity = n;
            this.start = 0;
            this.limit = this.upper;
            if (collection == null) {
                collection = attribute == FormatField.ALL ? this.attributes.values() : Collections.singleton(this.attributes.get(attribute));
            }
            Iterator<Entry> iterator = collection.iterator();
            while (iterator.hasNext()) {
                Entry entry;
                Entry entry2 = entry = iterator.next();
                while (entry != null) {
                    if (n >= entry.start && n < entry.limit) {
                        if (entry.start > this.start) {
                            this.start = entry.start;
                        }
                        if (entry.limit < this.limit) {
                            this.limit = entry.limit;
                        }
                        entry2 = null;
                    }
                    entry = entry.previous;
                }
                while (entry2 != null) {
                    if (entry2.start > n && entry2.start < this.limit) {
                        this.limit = entry2.start;
                    }
                    if (entry2.limit <= n && entry2.limit > this.start) {
                        this.start = entry2.limit;
                    }
                    entry2 = entry2.previous;
                }
            }
        }
    }

    @Override
    public int getRunStart() {
        this.update(FormatField.ALL, null);
        return this.start;
    }

    @Override
    public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
        ArgumentChecks.ensureNonNull("attribute", attribute);
        this.update(attribute, null);
        return this.start;
    }

    @Override
    public int getRunStart(Set<? extends AttributedCharacterIterator.Attribute> set) {
        this.update(null, this.entries(set));
        return this.start;
    }

    @Override
    public int getRunLimit() {
        this.update(FormatField.ALL, null);
        return this.limit;
    }

    @Override
    public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
        ArgumentChecks.ensureNonNull("attribute", attribute);
        this.update(attribute, null);
        return this.limit;
    }

    @Override
    public int getRunLimit(Set<? extends AttributedCharacterIterator.Attribute> set) {
        this.update(null, this.entries(set));
        return this.limit;
    }

    private Collection<Entry> entries(Set<? extends AttributedCharacterIterator.Attribute> set) {
        ArrayList<Entry> arrayList = new ArrayList<Entry>(set.size());
        for (AttributedCharacterIterator.Attribute attribute : set) {
            Entry entry = this.attributes.get(attribute);
            if (entry == null) continue;
            arrayList.add(entry);
        }
        return arrayList;
    }

    @Override
    public Map<AttributedCharacterIterator.Attribute, Object> getAttributes() {
        int n = this.getIndex();
        return Containers.derivedMap(this.attributes, new Filter(this.attributes, n), new Selector(n));
    }

    @Override
    public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
        int n = this.getIndex();
        Entry entry = this.attributes.get(attribute);
        while (entry != null) {
            if (n >= entry.start && n < entry.limit) {
                return entry.value;
            }
            entry = entry.previous;
        }
        return null;
    }

    @Override
    public Set<AttributedCharacterIterator.Attribute> getAllAttributeKeys() {
        if (this.attributeKeys == null) {
            this.attributeKeys = Collections.unmodifiableSet(this.attributes.keySet());
        }
        return this.attributeKeys;
    }

    private static class Filter
    extends SurjectiveConverter<AttributedCharacterIterator.Attribute, AttributedCharacterIterator.Attribute>
    implements Serializable {
        private static final long serialVersionUID = 6951804952836918035L;
        private final Map<AttributedCharacterIterator.Attribute, Entry> attributes;
        private final int index;

        Filter(Map<AttributedCharacterIterator.Attribute, Entry> map, int n) {
            this.attributes = map;
            this.index = n;
        }

        @Override
        public AttributedCharacterIterator.Attribute apply(AttributedCharacterIterator.Attribute attribute) {
            Entry entry = this.attributes.get(attribute);
            while (entry != null) {
                if (this.index >= entry.start && this.index < entry.limit) {
                    return attribute;
                }
                entry = entry.previous;
            }
            return null;
        }

        @Override
        public Class<AttributedCharacterIterator.Attribute> getSourceClass() {
            return AttributedCharacterIterator.Attribute.class;
        }

        @Override
        public Class<AttributedCharacterIterator.Attribute> getTargetClass() {
            return AttributedCharacterIterator.Attribute.class;
        }
    }

    private static final class Selector
    extends SurjectiveConverter<Entry, Object>
    implements Serializable {
        private static final long serialVersionUID = -7281235148346378214L;
        private final int index;

        Selector(int n) {
            this.index = n;
        }

        @Override
        public Object apply(Entry entry) {
            while (entry != null) {
                if (this.index >= entry.start && this.index < entry.limit) {
                    return entry.value;
                }
                entry = entry.previous;
            }
            return null;
        }

        @Override
        public Class<Entry> getSourceClass() {
            return Entry.class;
        }

        @Override
        public Class<Object> getTargetClass() {
            return Object.class;
        }
    }

    private static final class Entry
    implements Serializable {
        private static final long serialVersionUID = 3297480138621390486L;
        final Object value;
        final int start;
        final int limit;
        final Entry previous;

        Entry(AttributedCharacterIterator.Attribute attribute, Object object, int n, int n2, Map<AttributedCharacterIterator.Attribute, Entry> map) {
            this.value = object;
            this.start = n;
            this.limit = n2;
            this.previous = map.put(attribute, this);
        }
    }
}

