/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.impl.PathSegmentImpl;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.message.Message;

public class RequestPreprocessor {
    private static final String ACCEPT_QUERY = "_type";
    private static final String CTYPE_QUERY = "_ctype";
    private static final String METHOD_QUERY = "_method";
    private static final String METHOD_HEADER = "X-HTTP-Method-Override";
    private static final Map<String, String> SHORTCUTS = new HashMap<String, String>();
    private Map<Object, Object> languageMappings;
    private Map<Object, Object> extensionMappings;

    public RequestPreprocessor() {
        this(null, null);
    }

    public RequestPreprocessor(Map<Object, Object> languageMappings, Map<Object, Object> extensionMappings) {
        this.languageMappings = languageMappings == null ? Collections.emptyMap() : languageMappings;
        this.extensionMappings = extensionMappings == null ? Collections.emptyMap() : extensionMappings;
    }

    public String preprocess(Message m, UriInfo u) {
        this.handleExtensionMappings(m, u);
        this.handleLanguageMappings(m, u);
        MultivaluedMap<String, String> queries = u.getQueryParameters();
        this.handleTypeQuery(m, queries);
        this.handleCType(m, queries);
        this.handleMethod(m, queries, new HttpHeadersImpl(m));
        return new UriInfoImpl(m, null).getPath();
    }

    private void handleLanguageMappings(Message m, UriInfo uriInfo) {
        if (this.languageMappings.isEmpty()) {
            return;
        }
        PathSegmentImpl ps = new PathSegmentImpl(uriInfo.getPath(false), false);
        String path = ps.getPath();
        for (Map.Entry<Object, Object> entry : this.languageMappings.entrySet()) {
            if (!path.endsWith("." + entry.getKey())) continue;
            this.updateAcceptLanguageHeader(m, entry.getValue().toString());
            this.updatePath(m, path, entry.getKey().toString(), ps.getMatrixString());
            break;
        }
    }

    private void handleExtensionMappings(Message m, UriInfo uriInfo) {
        if (this.extensionMappings.isEmpty()) {
            return;
        }
        PathSegmentImpl ps = new PathSegmentImpl(uriInfo.getPath(false), false);
        String path = ps.getPath();
        for (Map.Entry<Object, Object> entry : this.extensionMappings.entrySet()) {
            String key = entry.getKey().toString();
            if (!path.endsWith("." + key)) continue;
            this.updateAcceptTypeHeader(m, entry.getValue().toString());
            this.updatePath(m, path, key, ps.getMatrixString());
            if (!"wadl".equals(key)) break;
            String query = (String)m.get(Message.QUERY_STRING);
            if (StringUtils.isEmpty(query)) {
                query = "_wadl";
            } else if (!query.contains("_wadl")) {
                query = query + "&_wadl";
            }
            m.put(Message.QUERY_STRING, query);
            break;
        }
    }

    private void updateAcceptLanguageHeader(Message m, String anotherValue) {
        ArrayList<String> acceptLanguage = (ArrayList<String>)((Map)m.get(Message.PROTOCOL_HEADERS)).get("Accept-Language");
        if (acceptLanguage == null) {
            acceptLanguage = new ArrayList<String>();
        }
        acceptLanguage.add(anotherValue);
        ((Map)m.get(Message.PROTOCOL_HEADERS)).put("Accept-Language", acceptLanguage);
    }

    private void updatePath(Message m, String path, String suffix, String matrixString) {
        String newPath = path.substring(0, path.length() - (suffix.length() + 1));
        if (matrixString != null) {
            newPath = newPath + matrixString;
        }
        HttpUtils.updatePath(m, newPath);
    }

    private void handleMethod(Message m, MultivaluedMap<String, String> queries, HttpHeaders headers) {
        List<String> list;
        String method = queries.getFirst(METHOD_QUERY);
        if (method == null && (list = headers.getRequestHeader(METHOD_HEADER)) != null && list.size() == 1) {
            method = list.get(0);
        }
        if (method != null) {
            m.put("org.apache.cxf.request.method", method);
        }
    }

    private void handleTypeQuery(Message m, MultivaluedMap<String, String> queries) {
        String type = queries.getFirst(ACCEPT_QUERY);
        if (type != null) {
            if (SHORTCUTS.containsKey(type)) {
                type = SHORTCUTS.get(type);
            }
            this.updateAcceptTypeHeader(m, type);
        }
    }

    private void handleCType(Message m, MultivaluedMap<String, String> queries) {
        String type = queries.getFirst(CTYPE_QUERY);
        if (type != null) {
            if (SHORTCUTS.containsKey(type)) {
                type = SHORTCUTS.get(type);
            }
            m.put("Content-Type", type);
        }
    }

    private void updateAcceptTypeHeader(Message m, String acceptValue) {
        m.put("Accept", acceptValue);
        ((Map)m.get(Message.PROTOCOL_HEADERS)).put("Accept", Collections.singletonList(acceptValue));
    }

    static {
        SHORTCUTS.put("json", "application/json");
        SHORTCUTS.put("text", "text/*");
        SHORTCUTS.put("xml", "application/xml");
        SHORTCUTS.put("atom", "application/atom+xml");
        SHORTCUTS.put("html", "text/html");
        SHORTCUTS.put("wadl", "application/vnd.sun.wadl+xml");
    }
}

