/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.png;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.clib.CLibImageWriter;
import com.sun.media.imageioimpl.plugins.clib.OutputStreamAdapter;
import com.sun.media.imageioimpl.plugins.png.CLibPNGImageWriteParam;
import com.sun.media.imageioimpl.plugins.png.CLibPNGMetadata;
import com.sun.medialib.codec.jiio.mediaLibImage;
import com.sun.medialib.codec.png.Encoder;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

final class CLibPNGImageWriter
extends CLibImageWriter {
    CLibPNGImageWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new CLibPNGImageWriteParam(this.getLocale());
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        CLibPNGMetadata m = new CLibPNGMetadata();
        if (param != null && param.getDestinationType() != null) {
            imageType = param.getDestinationType();
        }
        if (imageType != null) {
            m.initialize(imageType, imageType.getSampleModel().getNumBands(), param, 0);
        }
        return m;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        if (inData == null) {
            throw new IllegalArgumentException("inData == null!");
        }
        if (imageType == null) {
            throw new IllegalArgumentException("imageType == null!");
        }
        CLibPNGMetadata outData = null;
        if (inData instanceof CLibPNGMetadata) {
            outData = (CLibPNGMetadata)((CLibPNGMetadata)inData).clone();
        } else {
            try {
                outData = new CLibPNGMetadata(inData);
            }
            catch (IIOInvalidTreeException e) {
                outData = new CLibPNGMetadata();
            }
        }
        outData.initialize(imageType, imageType.getSampleModel().getNumBands(), param, outData.IHDR_interlaceMethod);
        return outData;
    }

    /*
     * WARNING - void declaration
     */
    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        void var9_10;
        ImageTypeSpecifier imageType;
        if (this.output == null) {
            throw new IllegalStateException("output == null");
        }
        OutputStreamAdapter stream = null;
        if (!(this.output instanceof ImageOutputStream)) {
            throw new IllegalArgumentException("!(output instanceof ImageOutputStream)");
        }
        stream = new OutputStreamAdapter((ImageOutputStream)this.output);
        RenderedImage renderedImage = image.getRenderedImage();
        ImageUtil.canEncodeImage(this, renderedImage.getColorModel(), renderedImage.getSampleModel());
        int[] supportedFormats = new int[]{2, 9, 1, 4, 3, 15, 10};
        mediaLibImage mlImage = this.getMediaLibImage(renderedImage, param, true, supportedFormats);
        Encoder encoder = null;
        try {
            encoder = new Encoder(mlImage);
        }
        catch (Throwable t) {
            throw new IIOException("codecLib error", t);
        }
        if (param != null && param.getDestinationType() != null) {
            imageType = param.getDestinationType();
        } else if (mlImage.getType() == 0) {
            if (renderedImage.getColorModel() instanceof IndexColorModel) {
                imageType = new ImageTypeSpecifier(renderedImage.getColorModel(), renderedImage.getSampleModel());
            } else {
                int dataType = renderedImage.getSampleModel().getDataType();
                imageType = ImageTypeSpecifier.createGrayscale(1, dataType, false);
            }
        } else if (mlImage.getChannels() == renderedImage.getSampleModel().getNumBands()) {
            imageType = new ImageTypeSpecifier(renderedImage);
        } else {
            SampleModel sm = renderedImage.getSampleModel();
            int dataType = sm.getDataType();
            int bitDepth = sm.getSampleSize(0);
            int numBands = mlImage.getChannels();
            switch (numBands) {
                case 1: {
                    imageType = ImageTypeSpecifier.createGrayscale(bitDepth, dataType, false);
                    break;
                }
                case 2: {
                    imageType = ImageTypeSpecifier.createGrayscale(bitDepth, dataType, false, false);
                    break;
                }
                case 3: {
                    ColorSpace cs = ColorSpace.getInstance(1000);
                    imageType = ImageTypeSpecifier.createInterleaved(cs, new int[]{0, 1, 2}, dataType, false, false);
                    break;
                }
                default: {
                    throw new IIOException("Cannot encode image with " + numBands + " bands!");
                }
            }
        }
        IIOMetadata imageMetadata = image.getMetadata();
        imageMetadata = imageMetadata != null ? this.convertImageMetadata(imageMetadata, (ImageTypeSpecifier)var9_10, param) : this.getDefaultImageMetadata((ImageTypeSpecifier)var9_10, param);
        ((CLibPNGMetadata)imageMetadata).writeMetadata(encoder);
        ColorModel colorModel = null;
        if (param != null) {
            ImageTypeSpecifier destinationType = param.getDestinationType();
            if (destinationType != null) {
                colorModel = destinationType.getColorModel();
            }
            if (param.getCompressionMode() == 2) {
                try {
                    int compressionLevel = (int)(9.0f * (1.0f - param.getCompressionQuality()));
                    encoder.setCompressionLevel(compressionLevel);
                }
                catch (Throwable t) {
                    throw new IIOException("codecLib error", t);
                }
                if (param instanceof CLibPNGImageWriteParam) {
                    try {
                        encoder.setStrategy(((CLibPNGImageWriteParam)param).getStrategy());
                    }
                    catch (Throwable t) {
                        throw new IIOException("codecLib error", t);
                    }
                }
            }
        } else {
            try {
                encoder.setStrategy(0);
            }
            catch (Throwable t) {
                throw new IIOException("codecLib error", t);
            }
        }
        if (colorModel == null) {
            colorModel = renderedImage.getColorModel();
        }
        if (!((CLibPNGMetadata)imageMetadata).iCCP_present && colorModel != null && ImageUtil.isNonStandardICCColorSpace(colorModel.getColorSpace())) {
            String profileName;
            ICC_ColorSpace iccColorSpace = (ICC_ColorSpace)colorModel.getColorSpace();
            ICC_Profile iccProfile = iccColorSpace.getProfile();
            byte[] iccProfileData = iccColorSpace.getProfile().getData();
            byte[] desc = iccProfile.getData(1684370275);
            if (desc != null) {
                long len = (desc[8] & 0xFF) << 24 | (desc[9] & 0xFF) << 16 | (desc[10] & 0xFF) << 8 | desc[11] & 0xFF;
                profileName = new String(desc, 12, (int)len);
            } else {
                profileName = "ICCProfile";
            }
            profileName = CLibPNGMetadata.toPrintableLatin1(profileName);
            encoder.setEmbeddedICCProfile(profileName, iccProfileData);
        }
        try {
            encoder.encode((OutputStream)stream);
        }
        catch (Throwable t) {
            throw new IIOException("codecLib error", t);
        }
    }
}

