/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.model.geom;

import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.xslf.model.geom.ArcToCommand;
import org.apache.poi.xslf.model.geom.ClosePathCommand;
import org.apache.poi.xslf.model.geom.Context;
import org.apache.poi.xslf.model.geom.CurveToCommand;
import org.apache.poi.xslf.model.geom.LineToCommand;
import org.apache.poi.xslf.model.geom.MoveToCommand;
import org.apache.poi.xslf.model.geom.PathCommand;
import org.apache.poi.xslf.model.geom.QuadToCommand;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTAdjPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DArcTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DClose;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DCubicBezierTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DLineTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DMoveTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DQuadBezierTo;
import org.openxmlformats.schemas.drawingml.x2006.main.STPathFillMode;

public class Path {
    private final List<PathCommand> commands;
    boolean _fill;
    boolean _stroke;
    long _w;
    long _h;

    public Path() {
        this(true, true);
    }

    public Path(boolean fill, boolean stroke) {
        this.commands = new ArrayList<PathCommand>();
        this._w = -1L;
        this._h = -1L;
        this._fill = fill;
        this._stroke = stroke;
    }

    public Path(CTPath2D spPath) {
        this._fill = spPath.getFill() != STPathFillMode.NONE;
        this._stroke = spPath.getStroke();
        this._w = spPath.isSetW() ? spPath.getW() : -1L;
        this._h = spPath.isSetH() ? spPath.getH() : -1L;
        this.commands = new ArrayList<PathCommand>();
        for (XmlObject ch : spPath.selectPath("*")) {
            CTAdjPoint2D pt2;
            CTAdjPoint2D pt1;
            XmlObject bez;
            CTAdjPoint2D pt;
            if (ch instanceof CTPath2DMoveTo) {
                pt = ((CTPath2DMoveTo)ch).getPt();
                this.commands.add(new MoveToCommand(pt));
                continue;
            }
            if (ch instanceof CTPath2DLineTo) {
                pt = ((CTPath2DLineTo)ch).getPt();
                this.commands.add(new LineToCommand(pt));
                continue;
            }
            if (ch instanceof CTPath2DArcTo) {
                CTPath2DArcTo arc = (CTPath2DArcTo)ch;
                this.commands.add(new ArcToCommand(arc));
                continue;
            }
            if (ch instanceof CTPath2DQuadBezierTo) {
                bez = (CTPath2DQuadBezierTo)ch;
                pt1 = bez.getPtArray(0);
                pt2 = bez.getPtArray(1);
                this.commands.add(new QuadToCommand(pt1, pt2));
                continue;
            }
            if (ch instanceof CTPath2DCubicBezierTo) {
                bez = (CTPath2DCubicBezierTo)ch;
                pt1 = bez.getPtArray(0);
                pt2 = bez.getPtArray(1);
                CTAdjPoint2D pt3 = bez.getPtArray(2);
                this.commands.add(new CurveToCommand(pt1, pt2, pt3));
                continue;
            }
            if (ch instanceof CTPath2DClose) {
                this.commands.add(new ClosePathCommand());
                continue;
            }
            throw new IllegalStateException("Unsupported path segment: " + ch);
        }
    }

    public void addCommand(PathCommand cmd) {
        this.commands.add(cmd);
    }

    public GeneralPath getPath(Context ctx) {
        GeneralPath path = new GeneralPath();
        for (PathCommand cmd : this.commands) {
            cmd.execute(path, ctx);
        }
        return path;
    }

    public boolean isStroked() {
        return this._stroke;
    }

    public boolean isFilled() {
        return this._fill;
    }

    public long getW() {
        return this._w;
    }

    public long getH() {
        return this._h;
    }
}

