/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CharStringRenderer;
import org.apache.fontbox.cff.DataOutput;
import org.apache.fontbox.cff.encoding.CFFEncoding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AFMFormatter {
    private AFMFormatter() {
    }

    public static byte[] format(CFFFont font) throws IOException {
        DataOutput output = new DataOutput();
        AFMFormatter.printFont(font, output);
        return output.getBytes();
    }

    private static void printFont(CFFFont font, DataOutput output) throws IOException {
        AFMFormatter.printFontMetrics(font, output);
    }

    private static void printFontMetrics(CFFFont font, DataOutput output) throws IOException {
        List<CharMetric> metrics = AFMFormatter.renderFont(font);
        output.println("StartFontMetrics 2.0");
        output.println("FontName " + font.getName());
        output.println("FullName " + font.getProperty("FullName"));
        output.println("FamilyName " + font.getProperty("FamilyName"));
        output.println("Weight " + font.getProperty("Weight"));
        CFFEncoding encoding = font.getEncoding();
        if (encoding.isFontSpecific()) {
            output.println("EncodingScheme FontSpecific");
        }
        Rectangle2D bounds = AFMFormatter.getBounds(metrics);
        output.println("FontBBox " + (int)bounds.getX() + " " + (int)bounds.getY() + " " + (int)bounds.getMaxX() + " " + (int)bounds.getMaxY());
        AFMFormatter.printDirectionMetrics(font, output);
        AFMFormatter.printCharMetrics(font, metrics, output);
        output.println("EndFontMetrics");
    }

    private static void printDirectionMetrics(CFFFont font, DataOutput output) throws IOException {
        output.println("UnderlinePosition " + font.getProperty("UnderlinePosition"));
        output.println("UnderlineThickness " + font.getProperty("UnderlineThickness"));
        output.println("ItalicAngle " + font.getProperty("ItalicAngle"));
        output.println("IsFixedPitch " + font.getProperty("isFixedPitch"));
    }

    private static void printCharMetrics(CFFFont font, List<CharMetric> metrics, DataOutput output) throws IOException {
        output.println("StartCharMetrics " + metrics.size());
        Collections.sort(metrics);
        for (CharMetric metric : metrics) {
            output.print("C " + metric.code + " ;");
            output.print(" ");
            output.print("WX " + metric.width + " ;");
            output.print(" ");
            output.print("N " + metric.name + " ;");
            output.print(" ");
            output.print("B " + (int)metric.bounds.getX() + " " + (int)metric.bounds.getY() + " " + (int)metric.bounds.getMaxX() + " " + (int)metric.bounds.getMaxY() + " ;");
            output.println();
        }
        output.println("EndCharMetrics");
    }

    private static List<CharMetric> renderFont(CFFFont font) throws IOException {
        ArrayList<CharMetric> metrics = new ArrayList<CharMetric>();
        CharStringRenderer renderer = font.createRenderer();
        Collection<CFFFont.Mapping> mappings = font.getMappings();
        for (CFFFont.Mapping mapping : mappings) {
            CharMetric metric = new CharMetric();
            metric.code = mapping.getCode();
            metric.name = mapping.getName();
            renderer.render(mapping.toType1Sequence());
            metric.width = renderer.getWidth();
            metric.bounds = renderer.getBounds();
            metrics.add(metric);
        }
        return metrics;
    }

    private static Rectangle2D getBounds(List<CharMetric> metrics) {
        Rectangle2D.Double bounds = null;
        for (CharMetric metric : metrics) {
            if (bounds == null) {
                bounds = new Rectangle2D.Double();
                bounds.setFrame(metric.bounds);
                continue;
            }
            Rectangle2D.union(bounds, metric.bounds, bounds);
        }
        return bounds;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CharMetric
    implements Comparable<CharMetric> {
        private int code;
        private String name;
        private int width;
        private Rectangle2D bounds;

        private CharMetric() {
        }

        @Override
        public int compareTo(CharMetric that) {
            return this.code - that.code;
        }
    }
}

