/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.pdfbox.exceptions.InvalidPasswordException;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.common.PDMetadata;

public class PrintDocumentMetaData {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            PrintDocumentMetaData.usage();
        } else {
            PDDocument document = null;
            FileInputStream file = null;
            try {
                file = new FileInputStream(args[0]);
                PDFParser parser = new PDFParser(file);
                parser.parse();
                document = parser.getPDDocument();
                if (document.isEncrypted()) {
                    try {
                        document.decrypt("");
                    }
                    catch (InvalidPasswordException e) {
                        System.err.println("Error: Document is encrypted with a password.");
                        System.exit(1);
                    }
                }
                PrintDocumentMetaData meta = new PrintDocumentMetaData();
                meta.printMetadata(document);
            }
            finally {
                if (file != null) {
                    file.close();
                }
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java org.apache.pdfbox.examples.pdmodel.PrintDocumentMetaData <input-pdf>");
    }

    public void printMetadata(PDDocument document) throws IOException {
        PDDocumentInformation info = document.getDocumentInformation();
        PDDocumentCatalog cat = document.getDocumentCatalog();
        PDMetadata metadata = cat.getMetadata();
        System.out.println("Page Count=" + document.getNumberOfPages());
        System.out.println("Title=" + info.getTitle());
        System.out.println("Author=" + info.getAuthor());
        System.out.println("Subject=" + info.getSubject());
        System.out.println("Keywords=" + info.getKeywords());
        System.out.println("Creator=" + info.getCreator());
        System.out.println("Producer=" + info.getProducer());
        System.out.println("Creation Date=" + this.formatDate(info.getCreationDate()));
        System.out.println("Modification Date=" + this.formatDate(info.getModificationDate()));
        System.out.println("Trapped=" + info.getTrapped());
        if (metadata != null) {
            System.out.println("Metadata=" + metadata.getInputStreamAsString());
        }
    }

    private String formatDate(Calendar date) {
        String retval = null;
        if (date != null) {
            SimpleDateFormat formatter = new SimpleDateFormat();
            retval = formatter.format(date.getTime());
        }
        return retval;
    }
}

