/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.jfif;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.BufferReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.jfif.JfifDirectory;

public class JfifReader
implements MetadataReader {
    public void extract(@NotNull BufferReader reader, @NotNull Metadata metadata) {
        JfifDirectory directory = metadata.getOrCreateDirectory(JfifDirectory.class);
        try {
            int ver = reader.getUInt16(5);
            directory.setInt(5, ver);
            short units = reader.getUInt8(7);
            directory.setInt(7, units);
            int height = reader.getUInt16(8);
            directory.setInt(8, height);
            int width = reader.getUInt16(10);
            directory.setInt(10, width);
        }
        catch (BufferBoundsException me) {
            directory.addError(me.getMessage());
        }
    }
}

