/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.transform.CartesianToSpherical;
import org.apache.sis.referencing.operation.transform.CoordinateSystemTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

final class SphericalToCartesian
extends CoordinateSystemTransform
implements Serializable {
    private static final long serialVersionUID = 8001536207920751506L;
    static final SphericalToCartesian INSTANCE = new SphericalToCartesian();

    private Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }

    private SphericalToCartesian() {
        super("Spherical to Cartesian", 3);
        this.context.normalizeGeographicInputs(0.0);
    }

    @Override
    public MathTransform inverse() {
        return CartesianToSpherical.INSTANCE;
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = dArray[n + 2];
        double d4 = Math.cos(d);
        double d5 = Math.sin(d);
        double d6 = Math.cos(d2);
        double d7 = Math.sin(d2);
        double d8 = d3 * d7;
        double d9 = d3 * d6;
        if (dArray2 != null) {
            dArray2[n2] = d9 * d4;
            dArray2[n2 + 1] = d9 * d5;
            dArray2[n2 + 2] = d8;
        }
        if (!bl) {
            return null;
        }
        double d10 = d6 * d4;
        double d11 = d6 * d5;
        return new Matrix3(-d3 * d11, -d8 * d4, d10, d3 * d10, -d8 * d5, d11, 0.0, d9, d7);
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        if (dArray == dArray2) {
            switch (IterationStrategy.suggest(n, 3, n2, 3, n3)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    n += 3 * (n3 - 1);
                    n2 += 3 * (n3 - 1);
                    n4 = -6;
                    n5 = -6;
                    break;
                }
                default: {
                    dArray = Arrays.copyOfRange(dArray, n, n + n3 * 3);
                    n = 0;
                }
            }
        }
        while (--n3 >= 0) {
            double d = dArray[n++];
            double d2 = dArray[n++];
            double d3 = dArray[n++];
            double d4 = d3 * Math.cos(d2);
            dArray2[n2++] = d4 * Math.cos(d);
            dArray2[n2++] = d4 * Math.sin(d);
            dArray2[n2++] = d3 * Math.sin(d2);
            n += n4;
            n2 += n5;
        }
    }
}

