/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.util.Iterator;
import org.apache.sis.math.Vector;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class CompoundDirectPositions
implements DirectPosition,
Iterable<DirectPosition>,
Iterator<DirectPosition> {
    private final Vector[] ordinates;
    private final int last;
    private int index;

    CompoundDirectPositions(Vector ... vectorArray) {
        this.ordinates = vectorArray;
        int n = vectorArray[0].size();
        for (int i = 1; i < vectorArray.length; ++i) {
            if (vectorArray[i].size() == n) continue;
            throw new IllegalArgumentException(Errors.format((short)77));
        }
        this.last = n - 1;
        this.index = n;
    }

    @Override
    public Iterator<DirectPosition> iterator() {
        if (this.hasNext()) {
            throw new UnsupportedOperationException(Errors.format((short)172));
        }
        this.index = -1;
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.last;
    }

    @Override
    public DirectPosition next() {
        ++this.index;
        return this;
    }

    @Override
    public DirectPosition getDirectPosition() {
        return this;
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return null;
    }

    @Override
    public int getDimension() {
        return this.ordinates.length;
    }

    @Override
    public double getOrdinate(int n) {
        return this.ordinates[n].doubleValue(this.index);
    }

    @Override
    public double[] getCoordinate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setOrdinate(int n, double d) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

