/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.FSLeafIndexImpl;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.internal.util.ComparableIntPointerIterator;

public abstract class FSIntIteratorImplBase<T extends FeatureStructure>
implements ComparableIntPointerIterator<T>,
LowLevelIterator {
    private final FSLeafIndexImpl<T> fsLeafIndexImpl;
    private int modificationSnapshot;
    protected final int[] detectIllegalIndexUpdates;
    private final int typeCode;

    public void checkConcurrentModification() {
        if (null != this.detectIllegalIndexUpdates && this.modificationSnapshot != this.detectIllegalIndexUpdates[this.typeCode]) {
            throw new ConcurrentModificationException();
        }
    }

    public void resetConcurrentModification() {
        this.modificationSnapshot = null == this.detectIllegalIndexUpdates ? 0 : this.detectIllegalIndexUpdates[this.typeCode];
    }

    public FSIntIteratorImplBase(FSLeafIndexImpl<T> fsLeafIndexImpl, int[] detectIllegalIndexUpdates) {
        this.fsLeafIndexImpl = fsLeafIndexImpl;
        this.typeCode = detectIllegalIndexUpdates == null ? 0 : fsLeafIndexImpl.getTypeCode();
        this.detectIllegalIndexUpdates = detectIllegalIndexUpdates;
        this.resetConcurrentModification();
    }

    @Override
    public void inc() {
        this.moveToNext();
    }

    @Override
    public void dec() {
        this.moveToPrevious();
    }

    @Override
    public LowLevelIndex ll_getIndex() {
        return this.fsLeafIndexImpl;
    }

    @Override
    public int compareTo(FSIntIteratorImplBase<T> o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int ll_get() throws NoSuchElementException {
        return this.get();
    }

    FSLeafIndexImpl<T> getFSLeafIndexImpl() {
        return this.fsLeafIndexImpl;
    }

    void moveTo(int fs, boolean isExact) {
        this.moveTo(fs);
    }
}

