/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.distribution;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.distribution.DigitalTransferOptions;
import org.opengis.metadata.distribution.Distribution;
import org.opengis.metadata.distribution.Distributor;
import org.opengis.metadata.distribution.Format;
import org.opengis.util.InternationalString;

@TitleProperty(name="description")
@XmlType(name="MD_Distribution_Type", propOrder={"distributionFormats", "distributors", "transferOptions"})
@XmlRootElement(name="MD_Distribution")
public class DefaultDistribution
extends ISOMetadata
implements Distribution {
    private static final long serialVersionUID = 1331353255189686369L;
    private InternationalString description;
    private Collection<Format> distributionFormats;
    private Collection<Distributor> distributors;
    private Collection<DigitalTransferOptions> transferOptions;

    public DefaultDistribution() {
    }

    public DefaultDistribution(Distribution distribution) {
        super(distribution);
        if (distribution != null) {
            this.distributionFormats = this.copyCollection(distribution.getDistributionFormats(), Format.class);
            this.distributors = this.copyCollection(distribution.getDistributors(), Distributor.class);
            this.transferOptions = this.copyCollection(distribution.getTransferOptions(), DigitalTransferOptions.class);
            if (distribution instanceof DefaultDistribution) {
                this.description = ((DefaultDistribution)distribution).getDescription();
            }
        }
    }

    public static DefaultDistribution castOrCopy(Distribution distribution) {
        if (distribution == null || distribution instanceof DefaultDistribution) {
            return (DefaultDistribution)distribution;
        }
        return new DefaultDistribution(distribution);
    }

    @UML(identifier="description", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.description = internationalString;
    }

    @XmlElement(name="distributionFormat")
    public Collection<Format> getDistributionFormats() {
        this.distributionFormats = this.nonNullCollection(this.distributionFormats, Format.class);
        return this.distributionFormats;
    }

    public void setDistributionFormats(Collection<? extends Format> collection) {
        this.distributionFormats = this.writeCollection(collection, this.distributionFormats, Format.class);
    }

    @XmlElement(name="distributor")
    public Collection<Distributor> getDistributors() {
        this.distributors = this.nonNullCollection(this.distributors, Distributor.class);
        return this.distributors;
    }

    public void setDistributors(Collection<? extends Distributor> collection) {
        this.distributors = this.writeCollection(collection, this.distributors, Distributor.class);
    }

    @XmlElement(name="transferOptions")
    public Collection<DigitalTransferOptions> getTransferOptions() {
        this.transferOptions = this.nonNullCollection(this.transferOptions, DigitalTransferOptions.class);
        return this.transferOptions;
    }

    public void setTransferOptions(Collection<? extends DigitalTransferOptions> collection) {
        this.transferOptions = this.writeCollection(collection, this.transferOptions, DigitalTransferOptions.class);
    }
}

