/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.io;

import com.jmatio.io.MatFileFilter;
import com.jmatio.io.MatFileHeader;
import com.jmatio.io.MatTag;
import com.jmatio.io.MatlabIOException;
import com.jmatio.io.stream.BufferedOutputStream;
import com.jmatio.io.stream.ByteBufferInputStream;
import com.jmatio.io.stream.ByteBufferedOutputStream;
import com.jmatio.io.stream.MatFileInputStream;
import com.jmatio.types.ByteStorageSupport;
import com.jmatio.types.MLArray;
import com.jmatio.types.MLCell;
import com.jmatio.types.MLChar;
import com.jmatio.types.MLDouble;
import com.jmatio.types.MLEmptyArray;
import com.jmatio.types.MLInt16;
import com.jmatio.types.MLInt32;
import com.jmatio.types.MLInt64;
import com.jmatio.types.MLInt8;
import com.jmatio.types.MLJavaObject;
import com.jmatio.types.MLNumericArray;
import com.jmatio.types.MLObject;
import com.jmatio.types.MLSingle;
import com.jmatio.types.MLSparse;
import com.jmatio.types.MLStructure;
import com.jmatio.types.MLUInt32;
import com.jmatio.types.MLUInt64;
import com.jmatio.types.MLUInt8;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.InflaterInputStream;
import sun.misc.Cleaner;

public class MatFileReader {
    public static final int MEMORY_MAPPED_FILE = 1;
    public static final int DIRECT_BYTE_BUFFER = 2;
    public static final int HEAP_BYTE_BUFFER = 4;
    private static boolean ALLOW_OBJECT_DESERIALIZATION = false;
    private MatFileHeader matFileHeader;
    private Map<String, MLArray> data;
    private ByteOrder byteOrder;
    private MatFileFilter filter = new MatFileFilter();
    private static final int DIRECT_BUFFER_LIMIT = 0x2000000;

    public static void setAllowObjectDeserialization(boolean allowDeserialization) {
        ALLOW_OBJECT_DESERIALIZATION = allowDeserialization;
    }

    public MatFileReader(String fileName) throws IOException {
        this(new File(fileName), new MatFileFilter());
    }

    public MatFileReader(String fileName, MatFileFilter filter) throws IOException {
        this(new File(fileName), filter);
    }

    public MatFileReader(File file) throws IOException {
        this(file, new MatFileFilter());
    }

    public MatFileReader(File file, MatFileFilter filter) throws IOException {
        this();
        this.read(file, filter, 1);
    }

    public MatFileReader() {
        this.data = new LinkedHashMap<String, MLArray>();
    }

    public synchronized Map<String, MLArray> read(File file) throws IOException {
        return this.read(file, new MatFileFilter(), 1);
    }

    public synchronized Map<String, MLArray> read(File file, int policy) throws IOException {
        return this.read(file, new MatFileFilter(), policy);
    }

    public synchronized Map<String, MLArray> read(File file, MatFileFilter filter, int policy) throws IOException {
        this.filter = filter;
        for (String key : this.data.keySet()) {
            this.data.remove(key);
        }
        AbstractInterruptibleChannel roChannel = null;
        RandomAccessFile raFile = null;
        ByteBuffer buf = null;
        WeakReference<MappedByteBuffer> bufferWeakRef = null;
        try {
            raFile = new RandomAccessFile(file, "r");
            roChannel = raFile.getChannel();
            switch (policy) {
                case 2: {
                    buf = ByteBuffer.allocateDirect((int)((FileChannel)roChannel).size());
                    ((FileChannel)roChannel).read(buf, 0L);
                    buf.rewind();
                    break;
                }
                case 4: {
                    int filesize = (int)((FileChannel)roChannel).size();
                    System.gc();
                    buf = ByteBuffer.allocate(filesize);
                    int numberOfBlocks = filesize / 0x2000000 + (filesize % 0x2000000 > 0 ? 1 : 0);
                    if (numberOfBlocks > 1) {
                        ByteBuffer tempByteBuffer = ByteBuffer.allocateDirect(0x2000000);
                        for (int block = 0; block < numberOfBlocks; ++block) {
                            tempByteBuffer.clear();
                            ((FileChannel)roChannel).read(tempByteBuffer, block * 0x2000000);
                            tempByteBuffer.flip();
                            buf.put(tempByteBuffer);
                        }
                        tempByteBuffer = null;
                    } else {
                        ((FileChannel)roChannel).read(buf, 0L);
                    }
                    buf.rewind();
                    break;
                }
                case 1: {
                    buf = ((FileChannel)roChannel).map(FileChannel.MapMode.READ_ONLY, 0L, (int)((FileChannel)roChannel).size());
                    bufferWeakRef = new WeakReference<MappedByteBuffer>((MappedByteBuffer)buf);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown file allocation policy");
                }
            }
            this.readHeader(buf);
            while (buf.remaining() > 0) {
                this.readData(buf);
            }
            Map<String, MLArray> filesize = this.getContent();
            return filesize;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (roChannel != null) {
                roChannel.close();
            }
            if (raFile != null) {
                raFile.close();
            }
            if (buf != null && bufferWeakRef != null && policy == 1) {
                try {
                    this.clean(buf);
                }
                catch (Exception e) {
                    int GC_TIMEOUT_MS = 1000;
                    buf = null;
                    long start = System.currentTimeMillis();
                    while (bufferWeakRef.get() != null && System.currentTimeMillis() - start <= (long)GC_TIMEOUT_MS) {
                        System.gc();
                        Thread.yield();
                    }
                }
            }
        }
    }

    private void clean(final Object buffer) throws Exception {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Method getCleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
                    getCleanerMethod.setAccessible(true);
                    Cleaner cleaner = (Cleaner)getCleanerMethod.invoke(buffer, new Object[0]);
                    cleaner.clean();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    public MatFileHeader getMatFileHeader() {
        return this.matFileHeader;
    }

    public ArrayList<MLArray> getData() {
        return new ArrayList<MLArray>(this.data.values());
    }

    public MLArray getMLArray(String name) {
        return this.data.get(name);
    }

    public Map<String, MLArray> getContent() {
        return this.data;
    }

    private void readData(ByteBuffer buf) throws IOException {
        ISMatTag tag = new ISMatTag(buf);
        switch (tag.type) {
            case 15: {
                long numOfBytes = tag.size;
                if ((long)buf.remaining() < numOfBytes) {
                    throw new MatlabIOException("Compressed buffer length miscalculated!");
                }
                InflaterInputStream iis = new InflaterInputStream(new ByteBufferInputStream(buf, numOfBytes));
                byte[] result = new byte[1024];
                ByteBufferedOutputStream dos = new ByteBufferedOutputStream(tag.size, false);
                try {
                    int i;
                    do {
                        i = iis.read(result, 0, result.length);
                        int len = Math.max(0, i);
                        ((OutputStream)dos).write(result, 0, len);
                    } while (i > 0);
                }
                catch (IOException e) {
                    throw new MatlabIOException("Could not decompress data: " + e);
                }
                finally {
                    iis.close();
                    dos.flush();
                }
                ByteBuffer out = ((BufferedOutputStream)dos).buffer();
                out.rewind();
                out.order(this.byteOrder);
                try {
                    this.readData(out);
                    break;
                }
                catch (IOException e) {
                    throw e;
                }
                finally {
                    dos.close();
                }
            }
            case 14: {
                int toread;
                int red;
                int pos = buf.position();
                MLArray element = this.readMatrix(buf, true);
                if (element != null && !this.data.containsKey(element.getName())) {
                    this.data.put(element.getName(), element);
                } else {
                    red = buf.position() - pos;
                    toread = tag.size - red;
                    buf.position(buf.position() + toread);
                }
                red = buf.position() - pos;
                toread = tag.size - red;
                if (toread == 0) break;
                throw new MatlabIOException("Matrix was not red fully! " + toread + " remaining in the buffer.");
            }
            default: {
                throw new MatlabIOException("Incorrect data tag: " + tag);
            }
        }
    }

    private MLArray readMatrix(ByteBuffer buf, boolean isRoot) throws IOException {
        MLArray mlArray = null;
        int[] flags = this.readFlags(buf);
        int attributes = flags.length != 0 ? flags[0] : 0;
        int nzmax = flags.length != 0 ? flags[1] : 0;
        int type = attributes & 0xFF;
        int[] dims = this.readDimension(buf);
        String name = this.readName(buf);
        if (isRoot && !this.filter.matches(name)) {
            return null;
        }
        switch (type) {
            case 2: {
                MLStructure struct = new MLStructure(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                int maxlen = buf.getInt();
                tag = new ISMatTag(buf);
                int numOfFields = tag.size / maxlen;
                String[] fieldNames = new String[numOfFields];
                for (int i = 0; i < numOfFields; ++i) {
                    byte[] names = new byte[maxlen];
                    buf.get(names);
                    fieldNames[i] = this.zeroEndByteArrayToString(names);
                }
                buf.position(buf.position() + tag.padding);
                for (int index = 0; index < struct.getM() * struct.getN(); ++index) {
                    for (int i = 0; i < numOfFields; ++i) {
                        tag = new ISMatTag(buf);
                        if (tag.size > 0) {
                            MLArray fieldValue = this.readMatrix(buf, false);
                            struct.setField(fieldNames[i], fieldValue, index);
                            continue;
                        }
                        struct.setField(fieldNames[i], new MLEmptyArray(), index);
                    }
                }
                mlArray = struct;
                break;
            }
            case 1: {
                MLCell cell = new MLCell(name, dims, type, attributes);
                for (int i = 0; i < cell.getM() * cell.getN(); ++i) {
                    ISMatTag tag = new ISMatTag(buf);
                    if (tag.size > 0) {
                        MLArray cellmatrix = this.readMatrix(buf, false);
                        cell.set(cellmatrix, i);
                        continue;
                    }
                    cell.set(new MLEmptyArray(), i);
                }
                mlArray = cell;
                break;
            }
            case 6: {
                mlArray = new MLDouble(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) break;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                break;
            }
            case 7: {
                mlArray = new MLSingle(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) break;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                break;
            }
            case 9: {
                mlArray = new MLUInt8(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) break;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                break;
            }
            case 8: {
                mlArray = new MLInt8(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) break;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                break;
            }
            case 10: {
                mlArray = new MLInt16(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) break;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                break;
            }
            case 12: {
                mlArray = new MLInt32(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) break;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                break;
            }
            case 13: {
                mlArray = new MLUInt32(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) break;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                break;
            }
            case 14: {
                mlArray = new MLInt64(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) break;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                break;
            }
            case 15: {
                mlArray = new MLUInt64(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) break;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                break;
            }
            case 4: {
                MLChar mlchar = new MLChar(name, dims, type, attributes);
                ISMatTag tag = new ISMatTag(buf);
                String str = tag.readToString();
                for (int i = 0; i < str.length(); ++i) {
                    mlchar.setChar(str.charAt(i), i);
                }
                mlArray = mlchar;
                break;
            }
            case 5: {
                MLSparse sparse = new MLSparse(name, dims, attributes, nzmax);
                ISMatTag tag = new ISMatTag(buf);
                int[] ir = tag.readToIntArray();
                tag = new ISMatTag(buf);
                int[] jc = tag.readToIntArray();
                tag = new ISMatTag(buf);
                double[] ad1 = tag.readToDoubleArray();
                int count = 0;
                for (int column = 0; column < sparse.getN(); ++column) {
                    while (count < jc[column + 1]) {
                        sparse.setReal(ad1[count], ir[count], column);
                        ++count;
                    }
                }
                if (sparse.isComplex()) {
                    tag = new ISMatTag(buf);
                    double[] ad2 = tag.readToDoubleArray();
                    count = 0;
                    for (int column = 0; column < sparse.getN(); ++column) {
                        while (count < jc[column + 1]) {
                            sparse.setImaginary(ad2[count], ir[count], column);
                            ++count;
                        }
                    }
                }
                mlArray = sparse;
                break;
            }
            case 17: {
                if (!ALLOW_OBJECT_DESERIALIZATION) break;
                ISMatTag tag = new ISMatTag(buf);
                String className = tag.readToString();
                byte[] nn = new byte[dims.length];
                for (int i = 0; i < dims.length; ++i) {
                    nn[i] = (byte)dims[i];
                }
                String arrName = new String(nn);
                ISMatTag contentTag = new ISMatTag(buf);
                if (contentTag.type == 14) {
                    MLUInt8 content = (MLUInt8)this.readMatrix(buf, false);
                    try (ObjectInputStream ois = new ObjectInputStream(new ByteBufferInputStream(content.getRealByteBuffer(), content.getRealByteBuffer().limit()));){
                        Object o = ois.readObject();
                        mlArray = new MLJavaObject(arrName, className, o);
                        break;
                    }
                }
                throw new IOException("Unexpected java object content");
            }
            case 3: {
                ISMatTag tag = new ISMatTag(buf);
                String className = tag.readToString();
                MLStructure struct = new MLStructure(name, dims, type, attributes);
                tag = new ISMatTag(buf);
                int maxlen = buf.getInt();
                tag = new ISMatTag(buf);
                int numOfFields = tag.size / maxlen;
                String[] fieldNames = new String[numOfFields];
                for (int i = 0; i < numOfFields; ++i) {
                    byte[] names = new byte[maxlen];
                    buf.get(names);
                    fieldNames[i] = this.zeroEndByteArrayToString(names);
                }
                buf.position(buf.position() + tag.padding);
                for (int index = 0; index < 1; ++index) {
                    for (int i = 0; i < numOfFields; ++i) {
                        tag = new ISMatTag(buf);
                        if (tag.size > 0) {
                            MLArray fieldValue = this.readMatrix(buf, false);
                            struct.setField(fieldNames[i], fieldValue, index);
                            continue;
                        }
                        struct.setField(fieldNames[i], new MLEmptyArray(), index);
                    }
                }
                mlArray = new MLObject(name, className, struct);
                break;
            }
            default: {
                throw new MatlabIOException("Incorrect matlab array class: " + MLArray.typeToString(type));
            }
        }
        return mlArray;
    }

    private String zeroEndByteArrayToString(byte[] bytes) throws IOException {
        int i = 0;
        for (i = 0; i < bytes.length && bytes[i] != 0; ++i) {
        }
        return new String(bytes, 0, i);
    }

    private int[] readFlags(ByteBuffer buf) throws IOException {
        ISMatTag tag = new ISMatTag(buf);
        int[] flags = tag.readToIntArray();
        return flags;
    }

    private int[] readDimension(ByteBuffer buf) throws IOException {
        ISMatTag tag = new ISMatTag(buf);
        int[] dims = tag.readToIntArray();
        return dims;
    }

    private String readName(ByteBuffer buf) throws IOException {
        ISMatTag tag = new ISMatTag(buf);
        return tag.readToString();
    }

    private void readHeader(ByteBuffer buf) throws IOException {
        int version;
        byte[] endianIndicator = new byte[2];
        byte[] descriptionBuffer = new byte[116];
        buf.get(descriptionBuffer);
        String description = this.zeroEndByteArrayToString(descriptionBuffer);
        if (!description.matches("MATLAB 5.0 MAT-file.*")) {
            throw new MatlabIOException("This is not a valid MATLAB 5.0 MAT-file.");
        }
        buf.position(buf.position() + 8);
        byte[] bversion = new byte[2];
        buf.get(bversion);
        buf.get(endianIndicator);
        if ((char)endianIndicator[0] == 'I' && (char)endianIndicator[1] == 'M') {
            this.byteOrder = ByteOrder.LITTLE_ENDIAN;
            version = bversion[1] & 0xFF | bversion[0] << 8;
        } else {
            this.byteOrder = ByteOrder.BIG_ENDIAN;
            version = bversion[0] & 0xFF | bversion[1] << 8;
        }
        buf.order(this.byteOrder);
        this.matFileHeader = new MatFileHeader(description, version, endianIndicator);
    }

    private static class ISMatTag
    extends MatTag {
        private final MatFileInputStream mfis;
        private final int padding;
        private final boolean compressed;

        public ISMatTag(ByteBuffer buf) throws IOException {
            super(0, 0);
            int tmp = buf.getInt();
            if (tmp >> 16 == 0) {
                this.type = tmp;
                this.size = buf.getInt();
                this.compressed = false;
            } else {
                this.size = tmp >> 16;
                this.type = tmp & 0xFFFF;
                this.compressed = true;
            }
            this.padding = this.getPadding(this.size, this.compressed);
            this.mfis = new MatFileInputStream(buf, this.type);
        }

        public void readToByteBuffer(ByteBuffer buff, ByteStorageSupport<?> storage) throws IOException {
            int elements = this.size / this.sizeOf();
            this.mfis.readToByteBuffer(buff, elements, storage);
            this.mfis.skip(this.padding);
        }

        public byte[] readToByteArray() throws IOException {
            int elements = this.size / this.sizeOf();
            byte[] ab = new byte[elements];
            for (int i = 0; i < elements; ++i) {
                ab[i] = this.mfis.readByte();
            }
            this.mfis.skip(this.padding);
            return ab;
        }

        public double[] readToDoubleArray() throws IOException {
            int elements = this.size / this.sizeOf();
            double[] ad = new double[elements];
            for (int i = 0; i < elements; ++i) {
                ad[i] = this.mfis.readDouble();
            }
            this.mfis.skip(this.padding);
            return ad;
        }

        public int[] readToIntArray() throws IOException {
            int elements = this.size / this.sizeOf();
            int[] ai = new int[elements];
            for (int i = 0; i < elements; ++i) {
                ai[i] = this.mfis.readInt();
            }
            this.mfis.skip(this.padding);
            return ai;
        }

        public String readToString() throws IOException {
            byte[] bytes = this.readToByteArray();
            return new String(bytes, "UTF-8");
        }

        public char[] readToCharArray() throws IOException {
            int elements = this.size / this.sizeOf();
            char[] ac = new char[elements];
            for (int i = 0; i < elements; ++i) {
                ac[i] = this.mfis.readChar();
            }
            this.mfis.skip(this.padding);
            return ac;
        }
    }
}

