/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser;

import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.util.CastUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;

public class MultiFileDataSourceImpl
implements DataSource {
    FileChannel[] fcs;
    int index = 0;

    public MultiFileDataSourceImpl(File ... f) throws FileNotFoundException {
        this.fcs = new FileChannel[f.length];
        int i = 0;
        while (i < f.length) {
            this.fcs[i] = new FileInputStream(f[i]).getChannel();
            ++i;
        }
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        int numOfBytesToRead = byteBuffer.remaining();
        int numOfBytesRead = 0;
        numOfBytesRead = this.fcs[this.index].read(byteBuffer);
        if (numOfBytesRead != numOfBytesToRead) {
            ++this.index;
            return numOfBytesRead + this.read(byteBuffer);
        }
        return numOfBytesRead;
    }

    public long size() throws IOException {
        long size = 0L;
        FileChannel[] fileChannelArray = this.fcs;
        int n = this.fcs.length;
        int n2 = 0;
        while (n2 < n) {
            FileChannel fileChannel = fileChannelArray[n2];
            size += fileChannel.size();
            ++n2;
        }
        return size;
    }

    public long position() throws IOException {
        long position = 0L;
        int i = 0;
        while (i < this.index) {
            position += this.fcs[i].size();
            ++i;
        }
        return position + this.fcs[this.index].position();
    }

    public void position(long nuPos) throws IOException {
        int i = 0;
        while (i < this.fcs.length) {
            if (nuPos - this.fcs[i].size() < 0L) {
                this.fcs[i].position(nuPos);
                this.index = i;
                break;
            }
            nuPos -= this.fcs[i].size();
            ++i;
        }
    }

    public long transferTo(long startPosition, long count, WritableByteChannel sink) throws IOException {
        if (count == 0L) {
            return 0L;
        }
        long currentPos = 0L;
        FileChannel[] fileChannelArray = this.fcs;
        int n = this.fcs.length;
        int n2 = 0;
        while (n2 < n) {
            FileChannel fc = fileChannelArray[n2];
            long size = fc.size();
            if (startPosition >= currentPos && startPosition < currentPos + size && startPosition + count > currentPos) {
                long bytesToTransfer = Math.min(count, size - (startPosition - currentPos));
                fc.transferTo(startPosition - currentPos, bytesToTransfer, sink);
                return bytesToTransfer + this.transferTo(startPosition + bytesToTransfer, count - bytesToTransfer, sink);
            }
            currentPos += size;
            ++n2;
        }
        return 0L;
    }

    public ByteBuffer map(long startPosition, long size) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(CastUtils.l2i(size));
        this.transferTo(startPosition, size, Channels.newChannel(baos));
        return ByteBuffer.wrap(baos.toByteArray());
    }

    public void close() throws IOException {
        FileChannel[] fileChannelArray = this.fcs;
        int n = this.fcs.length;
        int n2 = 0;
        while (n2 < n) {
            FileChannel fileChannel = fileChannelArray[n2];
            fileChannel.close();
            ++n2;
        }
    }
}

