/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.io.bzip2;

import java.io.IOException;
import java.io.InputStream;
import ucar.unidata.io.bzip2.BZip2Constants;
import ucar.unidata.io.bzip2.BZip2ReadException;
import ucar.unidata.io.bzip2.CRC;

public class CBZip2InputStream
extends InputStream
implements BZip2Constants {
    private static final int START_BLOCK_STATE = 1;
    private static final int RAND_PART_A_STATE = 2;
    private static final int RAND_PART_B_STATE = 3;
    private static final int RAND_PART_C_STATE = 4;
    private static final int NO_RAND_PART_A_STATE = 5;
    private static final int NO_RAND_PART_B_STATE = 6;
    private static final int NO_RAND_PART_C_STATE = 7;
    private int last;
    private int origPtr;
    private int blockSize100k;
    private boolean blockRandomised;
    private int bsBuff;
    private int bsLive;
    private CRC mCrc = new CRC();
    private boolean[] inUse = new boolean[256];
    private int nInUse;
    private char[] seqToUnseq = new char[256];
    private char[] unseqToSeq = new char[256];
    private char[] selector = new char[18002];
    private char[] selectorMtf = new char[18002];
    private int[] tt;
    private char[] ll8;
    private int[] unzftab = new int[256];
    private int[][] limit = new int[6][258];
    private int[][] base = new int[6][258];
    private int[][] perm = new int[6][258];
    private int[] minLens = new int[6];
    private InputStream bsStream;
    private boolean streamEnd = false;
    private int currentChar = -1;
    private int currentState = 1;
    private int storedBlockCRC;
    private int storedCombinedCRC;
    private int computedBlockCRC;
    private int computedCombinedCRC;
    int i2;
    int count;
    int chPrev;
    int ch2;
    int i;
    int tPos;
    int rNToGo = 0;
    int rTPos = 0;
    int j2;
    char z;

    public CBZip2InputStream() {
    }

    public CBZip2InputStream(InputStream zStream) {
        this.setStream(zStream);
    }

    public CBZip2InputStream(InputStream zStream, boolean skip) throws IOException {
        if (skip) {
            char c = (char)zStream.read();
            char c2 = (char)zStream.read();
        }
        this.setStream(zStream);
    }

    public void setStream(InputStream zStream) {
        this.last = 0;
        this.origPtr = 0;
        this.blockSize100k = 0;
        this.blockRandomised = false;
        this.bsBuff = 0;
        this.bsLive = 0;
        this.mCrc = new CRC();
        this.nInUse = 0;
        this.bsStream = null;
        this.streamEnd = false;
        this.currentChar = -1;
        this.currentState = 1;
        this.storedCombinedCRC = 0;
        this.storedBlockCRC = 0;
        this.computedCombinedCRC = 0;
        this.computedBlockCRC = 0;
        this.ch2 = 0;
        this.chPrev = 0;
        this.count = 0;
        this.i2 = 0;
        this.tPos = 0;
        this.i = 0;
        this.rNToGo = 0;
        this.rTPos = 0;
        this.j2 = 0;
        this.z = '\u0000';
        this.bsSetStream(zStream);
        this.initialize();
        this.initBlock();
        this.setupBlock();
    }

    public int read() {
        if (this.streamEnd) {
            return -1;
        }
        int retChar = this.currentChar;
        switch (this.currentState) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.setupRandPartB();
                break;
            }
            case 4: {
                this.setupRandPartC();
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.setupNoRandPartB();
                break;
            }
            case 7: {
                this.setupNoRandPartC();
                break;
            }
        }
        return retChar;
    }

    private void initialize() {
        char magic3 = this.bsGetUChar();
        char magic4 = this.bsGetUChar();
        if (magic3 != 'h' || magic4 < '1' || magic4 > '9') {
            this.bsFinishedWithStream();
            this.streamEnd = true;
            return;
        }
        this.setDecompressStructureSizes(magic4 - 48);
        this.computedCombinedCRC = 0;
    }

    private void initBlock() {
        char magic1 = this.bsGetUChar();
        char magic2 = this.bsGetUChar();
        char magic3 = this.bsGetUChar();
        char magic4 = this.bsGetUChar();
        char magic5 = this.bsGetUChar();
        char magic6 = this.bsGetUChar();
        if (magic1 == '\u0017' && magic2 == 'r' && magic3 == 'E' && magic4 == '8' && magic5 == 'P' && magic6 == '\u0090') {
            this.complete();
            return;
        }
        if (magic1 != '1' || magic2 != 'A' || magic3 != 'Y' || magic4 != '&' || magic5 != 'S' || magic6 != 'Y') {
            this.badBlockHeader();
            this.streamEnd = true;
            return;
        }
        this.storedBlockCRC = this.bsGetInt32();
        this.blockRandomised = this.bsR(1) == 1;
        this.getAndMoveToFrontDecode();
        this.mCrc.initialiseCRC();
        this.currentState = 1;
    }

    private void endBlock() {
        this.computedBlockCRC = this.mCrc.getFinalCRC();
        if (this.storedBlockCRC != this.computedBlockCRC) {
            this.cadvise("CRC error: storedBlockCRC != computedBlockCRC");
        }
        this.computedCombinedCRC = this.computedCombinedCRC << 1 | this.computedCombinedCRC >>> 31;
        this.computedCombinedCRC ^= this.computedBlockCRC;
    }

    private void complete() {
        this.storedCombinedCRC = this.bsGetInt32();
        if (this.storedCombinedCRC != this.computedCombinedCRC) {
            this.cadvise("CRC error: storedCombinedCRC != computedCombinedCRC");
        }
        this.bsFinishedWithStream();
        this.streamEnd = true;
    }

    private void blockOverrun() {
        this.cadvise("Block Overrun");
    }

    private void badBlockHeader() {
        this.cadvise("Bad Block Header");
    }

    private void crcError() {
        this.cadvise();
    }

    private void bsFinishedWithStream() {
        try {
            if (this.bsStream != null && this.bsStream != System.in) {
                this.bsStream.close();
                this.bsStream = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void bsSetStream(InputStream f) {
        this.bsStream = f;
        this.bsLive = 0;
        this.bsBuff = 0;
    }

    private int bsR(int n) {
        while (this.bsLive < n) {
            char thech = '\u0000';
            try {
                thech = (char)this.bsStream.read();
            }
            catch (IOException e) {
                this.compressedStreamEOF();
            }
            if (thech == '\uffffffff') {
                this.compressedStreamEOF();
            }
            char zzi = thech;
            this.bsBuff = this.bsBuff << 8 | zzi & 0xFF;
            this.bsLive += 8;
        }
        int v = this.bsBuff >> this.bsLive - n & (1 << n) - 1;
        this.bsLive -= n;
        return v;
    }

    private char bsGetUChar() {
        return (char)this.bsR(8);
    }

    private int bsGetint() {
        int u = 0;
        u = u << 8 | this.bsR(8);
        u = u << 8 | this.bsR(8);
        u = u << 8 | this.bsR(8);
        u = u << 8 | this.bsR(8);
        return u;
    }

    private int bsGetIntVS(int numBits) {
        return this.bsR(numBits);
    }

    private int bsGetInt32() {
        return this.bsGetint();
    }

    private void hbCreateDecodeTables(int[] limit, int[] base, int[] perm, char[] length, int minLen, int maxLen, int alphaSize) {
        int i;
        int pp = 0;
        for (i = minLen; i <= maxLen; ++i) {
            for (int j = 0; j < alphaSize; ++j) {
                if (length[j] != i) continue;
                perm[pp] = j;
                ++pp;
            }
        }
        for (i = 0; i < 23; ++i) {
            base[i] = 0;
        }
        for (i = 0; i < alphaSize; ++i) {
            int n = length[i] + '\u0001';
            base[n] = base[n] + 1;
        }
        for (i = 1; i < 23; ++i) {
            int n = i;
            base[n] = base[n] + base[i - 1];
        }
        for (i = 0; i < 23; ++i) {
            limit[i] = 0;
        }
        int vec = 0;
        for (i = minLen; i <= maxLen; ++i) {
            limit[i] = (vec += base[i + 1] - base[i]) - 1;
            vec <<= 1;
        }
        for (i = minLen + 1; i <= maxLen; ++i) {
            base[i] = (limit[i - 1] + 1 << 1) - base[i];
        }
    }

    private void recvDecodingTables() {
        int t;
        int v;
        int j;
        int i;
        char[][] len = new char[6][258];
        boolean[] inUse16 = new boolean[16];
        for (i = 0; i < 16; ++i) {
            inUse16[i] = this.bsR(1) == 1;
        }
        for (i = 0; i < 256; ++i) {
            this.inUse[i] = false;
        }
        for (i = 0; i < 16; ++i) {
            if (!inUse16[i]) continue;
            for (j = 0; j < 16; ++j) {
                if (this.bsR(1) != 1) continue;
                this.inUse[i * 16 + j] = true;
            }
        }
        this.makeMaps();
        int alphaSize = this.nInUse + 2;
        int nGroups = this.bsR(3);
        int nSelectors = this.bsR(15);
        for (i = 0; i < nSelectors; ++i) {
            j = 0;
            while (this.bsR(1) == 1) {
                ++j;
            }
            this.selectorMtf[i] = (char)j;
        }
        char[] pos = new char[6];
        for (v = 0; v < nGroups; v = (int)((char)(v + 1))) {
            pos[v] = v;
        }
        for (i = 0; i < nSelectors; ++i) {
            char tmp = pos[v];
            for (v = this.selectorMtf[i]; v > 0; v = (int)((char)(v - 1))) {
                pos[v] = pos[v - 1];
            }
            pos[0] = tmp;
            this.selector[i] = tmp;
        }
        for (t = 0; t < nGroups; ++t) {
            int curr = this.bsR(5);
            for (i = 0; i < alphaSize; ++i) {
                while (this.bsR(1) == 1) {
                    if (this.bsR(1) == 0) {
                        ++curr;
                        continue;
                    }
                    --curr;
                }
                len[t][i] = (char)curr;
            }
        }
        for (t = 0; t < nGroups; ++t) {
            int minLen = 32;
            char maxLen = '\u0000';
            for (i = 0; i < alphaSize; ++i) {
                if (len[t][i] > maxLen) {
                    maxLen = len[t][i];
                }
                if (len[t][i] >= minLen) continue;
                minLen = len[t][i];
            }
            this.hbCreateDecodeTables(this.limit[t], this.base[t], this.perm[t], len[t], minLen, maxLen, alphaSize);
            this.minLens[t] = minLen;
        }
    }

    private void getAndMoveToFrontDecode() {
        int i;
        char[] yy = new char[256];
        int limitLast = 100000 * this.blockSize100k;
        this.origPtr = this.bsGetIntVS(24);
        this.recvDecodingTables();
        int EOB = this.nInUse + 1;
        int groupNo = -1;
        int groupPos = 0;
        for (i = 0; i <= 255; ++i) {
            this.unzftab[i] = 0;
        }
        for (i = 0; i <= 255; ++i) {
            yy[i] = (char)i;
        }
        this.last = -1;
        if (groupPos == 0) {
            ++groupNo;
            groupPos = 50;
        }
        --groupPos;
        char zt = this.selector[groupNo];
        int zn = this.minLens[zt];
        int zvec = this.bsR(zn);
        while (zvec > this.limit[zt][zn]) {
            ++zn;
            while (this.bsLive < 1) {
                char thech = '\u0000';
                try {
                    thech = (char)this.bsStream.read();
                }
                catch (IOException e) {
                    this.compressedStreamEOF();
                }
                if (thech == '\uffffffff') {
                    this.compressedStreamEOF();
                }
                char zzi = thech;
                this.bsBuff = this.bsBuff << 8 | zzi & 0xFF;
                this.bsLive += 8;
            }
            int zj = this.bsBuff >> this.bsLive - 1 & 1;
            --this.bsLive;
            zvec = zvec << 1 | zj;
        }
        int nextSym = this.perm[zt][zvec - this.base[zt][zn]];
        while (nextSym != EOB) {
            int j;
            if (nextSym == 0 || nextSym == 1) {
                char ch;
                int zn2;
                int zvec2;
                char zt2;
                int s = -1;
                int N = 1;
                do {
                    if (nextSym == 0) {
                        s += 1 * N;
                    } else if (nextSym == 1) {
                        s += 2 * N;
                    }
                    N *= 2;
                    if (groupPos == 0) {
                        ++groupNo;
                        groupPos = 50;
                    }
                    --groupPos;
                    zt2 = this.selector[groupNo];
                    zn2 = this.minLens[zt2];
                    zvec2 = this.bsR(zn2);
                    while (zvec2 > this.limit[zt2][zn2]) {
                        ++zn2;
                        while (this.bsLive < 1) {
                            char thech = '\u0000';
                            try {
                                thech = (char)this.bsStream.read();
                            }
                            catch (IOException e) {
                                this.compressedStreamEOF();
                            }
                            if (thech == '\uffffffff') {
                                this.compressedStreamEOF();
                            }
                            char zzi = thech;
                            this.bsBuff = this.bsBuff << 8 | zzi & 0xFF;
                            this.bsLive += 8;
                        }
                        int zj = this.bsBuff >> this.bsLive - 1 & 1;
                        --this.bsLive;
                        zvec2 = zvec2 << 1 | zj;
                    }
                } while ((nextSym = this.perm[zt2][zvec2 - this.base[zt2][zn2]]) == 0 || nextSym == 1);
                char c = ch = this.seqToUnseq[yy[0]];
                this.unzftab[c] = this.unzftab[c] + ++s;
                while (s > 0) {
                    ++this.last;
                    this.ll8[this.last] = ch;
                    --s;
                }
                if (this.last < limitLast) continue;
                this.blockOverrun();
                continue;
            }
            ++this.last;
            if (this.last >= limitLast) {
                this.blockOverrun();
            }
            char tmp = yy[nextSym - 1];
            char c = this.seqToUnseq[tmp];
            this.unzftab[c] = this.unzftab[c] + 1;
            this.ll8[this.last] = this.seqToUnseq[tmp];
            for (j = nextSym - 1; j > 3; j -= 4) {
                yy[j] = yy[j - 1];
                yy[j - 1] = yy[j - 2];
                yy[j - 2] = yy[j - 3];
                yy[j - 3] = yy[j - 4];
            }
            while (j > 0) {
                yy[j] = yy[j - 1];
                --j;
            }
            yy[0] = tmp;
            if (groupPos == 0) {
                ++groupNo;
                groupPos = 50;
            }
            --groupPos;
            char zt3 = this.selector[groupNo];
            int zn3 = this.minLens[zt3];
            int zvec3 = this.bsR(zn3);
            while (zvec3 > this.limit[zt3][zn3]) {
                ++zn3;
                while (this.bsLive < 1) {
                    char thech = '\u0000';
                    try {
                        thech = (char)this.bsStream.read();
                    }
                    catch (IOException e) {
                        this.compressedStreamEOF();
                    }
                    char zzi = thech;
                    this.bsBuff = this.bsBuff << 8 | zzi & 0xFF;
                    this.bsLive += 8;
                }
                int zj = this.bsBuff >> this.bsLive - 1 & 1;
                --this.bsLive;
                zvec3 = zvec3 << 1 | zj;
            }
            nextSym = this.perm[zt3][zvec3 - this.base[zt3][zn3]];
        }
    }

    private void setupBlock() {
        int[] cftab = new int[257];
        cftab[0] = 0;
        this.i = 1;
        while (this.i <= 256) {
            cftab[this.i] = this.unzftab[this.i - 1];
            ++this.i;
        }
        this.i = 1;
        while (this.i <= 256) {
            int n = this.i;
            cftab[n] = cftab[n] + cftab[this.i - 1];
            ++this.i;
        }
        this.i = 0;
        while (this.i <= this.last) {
            char ch = this.ll8[this.i];
            this.tt[cftab[ch]] = this.i++;
            char c = ch;
            cftab[c] = cftab[c] + 1;
        }
        cftab = null;
        this.tPos = this.tt[this.origPtr];
        this.count = 0;
        this.i2 = 0;
        this.ch2 = 256;
        if (this.blockRandomised) {
            this.rNToGo = 0;
            this.rTPos = 0;
            this.setupRandPartA();
        } else {
            this.setupNoRandPartA();
        }
    }

    private void setupRandPartA() {
        if (this.i2 <= this.last) {
            this.chPrev = this.ch2;
            this.ch2 = this.ll8[this.tPos];
            this.tPos = this.tt[this.tPos];
            if (this.rNToGo == 0) {
                this.rNToGo = rNums[this.rTPos];
                ++this.rTPos;
                if (this.rTPos == 512) {
                    this.rTPos = 0;
                }
            }
            --this.rNToGo;
            this.ch2 ^= this.rNToGo == 1 ? 1 : 0;
            ++this.i2;
            this.currentChar = this.ch2;
            this.currentState = 3;
            this.mCrc.updateCRC(this.ch2);
        } else {
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private void setupNoRandPartA() {
        if (this.i2 <= this.last) {
            this.chPrev = this.ch2;
            this.ch2 = this.ll8[this.tPos];
            this.tPos = this.tt[this.tPos];
            ++this.i2;
            this.currentChar = this.ch2;
            this.currentState = 6;
            this.mCrc.updateCRC(this.ch2);
        } else {
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private void setupRandPartB() {
        if (this.ch2 != this.chPrev) {
            this.currentState = 2;
            this.count = 1;
            this.setupRandPartA();
        } else {
            ++this.count;
            if (this.count >= 4) {
                this.z = this.ll8[this.tPos];
                this.tPos = this.tt[this.tPos];
                if (this.rNToGo == 0) {
                    this.rNToGo = rNums[this.rTPos];
                    ++this.rTPos;
                    if (this.rTPos == 512) {
                        this.rTPos = 0;
                    }
                }
                --this.rNToGo;
                this.z = (char)(this.z ^ (this.rNToGo == 1 ? (char)'\u0001' : '\u0000'));
                this.j2 = 0;
                this.currentState = 4;
                this.setupRandPartC();
            } else {
                this.currentState = 2;
                this.setupRandPartA();
            }
        }
    }

    private void setupRandPartC() {
        if (this.j2 < this.z) {
            this.currentChar = this.ch2;
            this.mCrc.updateCRC(this.ch2);
            ++this.j2;
        } else {
            this.currentState = 2;
            ++this.i2;
            this.count = 0;
            this.setupRandPartA();
        }
    }

    private void setupNoRandPartB() {
        if (this.ch2 != this.chPrev) {
            this.currentState = 5;
            this.count = 1;
            this.setupNoRandPartA();
        } else {
            ++this.count;
            if (this.count >= 4) {
                this.z = this.ll8[this.tPos];
                this.tPos = this.tt[this.tPos];
                this.currentState = 7;
                this.j2 = 0;
                this.setupNoRandPartC();
            } else {
                this.currentState = 5;
                this.setupNoRandPartA();
            }
        }
    }

    private void setupNoRandPartC() {
        if (this.j2 < this.z) {
            this.currentChar = this.ch2;
            this.mCrc.updateCRC(this.ch2);
            ++this.j2;
        } else {
            this.currentState = 5;
            ++this.i2;
            this.count = 0;
            this.setupNoRandPartA();
        }
    }

    private void setDecompressStructureSizes(int newSize100k) {
        if (0 > newSize100k || newSize100k > 9 || 0 > this.blockSize100k || this.blockSize100k > 9) {
            // empty if block
        }
        this.blockSize100k = newSize100k;
        if (newSize100k == 0) {
            return;
        }
        int n = 100000 * newSize100k;
        if (this.ll8 != null && this.ll8.length != n) {
            this.ll8 = null;
        }
        if (this.tt != null && this.tt.length != n) {
            this.tt = null;
        }
        if (this.ll8 == null) {
            this.ll8 = new char[n];
        }
        if (this.tt == null) {
            this.tt = new int[n];
        }
    }

    private void cadvise() {
        System.out.println("CRC Error");
    }

    private void cadvise(String msg) {
        throw new BZip2ReadException(msg);
    }

    private void compressedStreamEOF() {
        this.cadvise("Compressed Stream EOF");
    }

    private void makeMaps() {
        this.nInUse = 0;
        for (int i = 0; i < 256; ++i) {
            if (!this.inUse[i]) continue;
            this.seqToUnseq[this.nInUse] = (char)i;
            this.unseqToSeq[i] = (char)this.nInUse;
            ++this.nInUse;
        }
    }
}

