/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDFieldFactory;

public class PDFMergerUtility {
    private List sources;
    private String destinationFileName;
    Map clonedVersion = new HashMap();
    private int nextFieldNum = 1;

    public PDFMergerUtility() {
        this.sources = new ArrayList();
    }

    public String getDestinationFileName() {
        return this.destinationFileName;
    }

    public void setDestinationFileName(String destination) {
        this.destinationFileName = destination;
    }

    public void addSource(String source) {
        this.sources.add(new File(source));
    }

    public void addSource(File source) {
        this.sources.add(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeDocuments() throws IOException, COSVisitorException {
        PDDocument destination = null;
        if (this.sources != null && this.sources.size() > 0) {
            try {
                Iterator sit = this.sources.iterator();
                File sourceFile = (File)sit.next();
                destination = PDDocument.load(sourceFile);
                while (sit.hasNext()) {
                    sourceFile = (File)sit.next();
                    PDDocument source = PDDocument.load(sourceFile);
                    try {
                        this.appendDocument(destination, source);
                    }
                    finally {
                        if (source == null) continue;
                        source.close();
                    }
                }
                destination.save(this.destinationFileName);
            }
            finally {
                if (destination != null) {
                    destination.close();
                }
            }
        }
    }

    public void appendDocument(PDDocument destination, PDDocument source) throws IOException {
        if (destination.isEncrypted()) {
            throw new IOException("Error: destination PDF is encrypted, can't append encrypted PDF documents.");
        }
        if (source.isEncrypted()) {
            throw new IOException("Error: source PDF is encrypted, can't append encrypted PDF documents.");
        }
        PDDocumentInformation destInfo = destination.getDocumentInformation();
        PDDocumentInformation srcInfo = source.getDocumentInformation();
        destInfo.getDictionary().mergeInto(srcInfo.getDictionary());
        PDDocumentCatalog destCatalog = destination.getDocumentCatalog();
        PDDocumentCatalog srcCatalog = source.getDocumentCatalog();
        if (destCatalog.getOpenAction() == null) {
            destCatalog.setOpenAction(srcCatalog.getOpenAction());
        }
        PDAcroForm destAcroForm = destCatalog.getAcroForm();
        PDAcroForm srcAcroForm = srcCatalog.getAcroForm();
        if (destAcroForm == null) {
            this.cloneForNewDocument(destination, srcAcroForm);
            destCatalog.setAcroForm(srcAcroForm);
        } else if (srcAcroForm != null) {
            this.mergeAcroForm(destination, destAcroForm, srcAcroForm);
        }
        COSArray destThreads = (COSArray)destCatalog.getCOSDictionary().getDictionaryObject(COSName.getPDFName("Threads"));
        COSArray srcThreads = (COSArray)this.cloneForNewDocument(destination, destCatalog.getCOSDictionary().getDictionaryObject(COSName.getPDFName("Threads")));
        if (destThreads == null) {
            destCatalog.getCOSDictionary().setItem(COSName.getPDFName("Threads"), (COSBase)srcThreads);
        } else {
            destThreads.addAll(srcThreads);
        }
        COSName names = COSName.getPDFName("Names");
        PDDocumentNameDictionary destNames = destCatalog.getNames();
        PDDocumentNameDictionary srcNames = srcCatalog.getNames();
        if (srcNames != null) {
            if (destNames == null) {
                destCatalog.getCOSDictionary().setItem(names, this.cloneForNewDocument(destination, srcNames));
            } else {
                this.cloneMerge(destination, srcNames, destNames);
            }
        }
        PDDocumentOutline destOutline = destCatalog.getDocumentOutline();
        PDDocumentOutline srcOutline = srcCatalog.getDocumentOutline();
        if (srcOutline != null) {
            if (destOutline == null) {
                PDDocumentOutline cloned = new PDDocumentOutline((COSDictionary)this.cloneForNewDocument(destination, srcOutline));
                destCatalog.setDocumentOutline(cloned);
            } else {
                PDOutlineItem first = srcOutline.getFirstChild();
                PDOutlineItem clonedFirst = new PDOutlineItem((COSDictionary)this.cloneForNewDocument(destination, first));
                destOutline.appendChild(clonedFirst);
            }
        }
        String destPageMode = destCatalog.getPageMode();
        String srcPageMode = srcCatalog.getPageMode();
        if (destPageMode == null) {
            destCatalog.setPageMode(srcPageMode);
        }
        COSName pageLabels = COSName.getPDFName("PageLabels");
        COSDictionary destLabels = (COSDictionary)destCatalog.getCOSDictionary().getDictionaryObject(pageLabels);
        COSDictionary srcLabels = (COSDictionary)srcCatalog.getCOSDictionary().getDictionaryObject(pageLabels);
        if (srcLabels != null) {
            int destPageCount = destination.getNumberOfPages();
            COSArray destNums = null;
            if (destLabels == null) {
                destLabels = new COSDictionary();
                destNums = new COSArray();
                destLabels.setItem(COSName.getPDFName("Nums"), (COSBase)destNums);
                destCatalog.getCOSDictionary().setItem(pageLabels, (COSBase)destLabels);
            } else {
                destNums = (COSArray)destLabels.getDictionaryObject(COSName.getPDFName("Nums"));
            }
            COSArray srcNums = (COSArray)srcLabels.getDictionaryObject(COSName.getPDFName("Nums"));
            if (srcNums != null) {
                for (int i = 0; i < srcNums.size(); i += 2) {
                    COSNumber labelIndex = (COSNumber)srcNums.getObject(i);
                    long labelIndexValue = labelIndex.intValue();
                    destNums.add(COSInteger.get(labelIndexValue + (long)destPageCount));
                    destNums.add(this.cloneForNewDocument(destination, srcNums.getObject(i + 1)));
                }
            }
        }
        COSName metadata = COSName.getPDFName("Metadata");
        COSStream destMetadata = (COSStream)destCatalog.getCOSDictionary().getDictionaryObject(metadata);
        COSStream srcMetadata = (COSStream)srcCatalog.getCOSDictionary().getDictionaryObject(metadata);
        if (destMetadata == null && srcMetadata != null) {
            PDStream newStream = new PDStream(destination, srcMetadata.getUnfilteredStream(), false);
            newStream.getStream().mergeInto(srcMetadata);
            newStream.addCompression();
            destCatalog.getCOSDictionary().setItem(metadata, (COSObjectable)newStream);
        }
        List pages = source.getDocumentCatalog().getAllPages();
        for (PDPage page : pages) {
            PDPage newPage = new PDPage((COSDictionary)this.cloneForNewDocument(destination, page.getCOSDictionary()));
            newPage.setCropBox(page.findCropBox());
            newPage.setMediaBox(page.findMediaBox());
            newPage.setRotation(page.findRotation());
            destination.addPage(newPage);
        }
    }

    private COSBase cloneForNewDocument(PDDocument destination, Object base) throws IOException {
        if (base == null) {
            return null;
        }
        COSBase retval = (COSBase)this.clonedVersion.get(base);
        if (retval == null) {
            if (base instanceof List) {
                COSArray array = new COSArray();
                List list = (List)base;
                for (int i = 0; i < list.size(); ++i) {
                    array.add(this.cloneForNewDocument(destination, list.get(i)));
                }
                retval = array;
            } else if (base instanceof COSObjectable && !(base instanceof COSBase)) {
                retval = this.cloneForNewDocument(destination, ((COSObjectable)base).getCOSObject());
                this.clonedVersion.put(base, retval);
            } else if (base instanceof COSObject) {
                COSObject object = (COSObject)base;
                retval = this.cloneForNewDocument(destination, object.getObject());
                this.clonedVersion.put(base, retval);
            } else if (base instanceof COSArray) {
                COSArray newArray = new COSArray();
                COSArray array = (COSArray)base;
                for (int i = 0; i < array.size(); ++i) {
                    newArray.add(this.cloneForNewDocument(destination, array.get(i)));
                }
                retval = newArray;
                this.clonedVersion.put(base, retval);
            } else if (base instanceof COSStream) {
                COSStream originalStream = (COSStream)base;
                PDStream stream = new PDStream(destination, originalStream.getFilteredStream(), true);
                this.clonedVersion.put(base, stream.getStream());
                for (Map.Entry<COSName, COSBase> entry : originalStream.entrySet()) {
                    stream.getStream().setItem(entry.getKey(), this.cloneForNewDocument(destination, entry.getValue()));
                }
                retval = stream.getStream();
            } else if (base instanceof COSDictionary) {
                COSDictionary dic = (COSDictionary)base;
                retval = new COSDictionary();
                this.clonedVersion.put(base, retval);
                for (Map.Entry<COSName, COSBase> entry : dic.entrySet()) {
                    ((COSDictionary)retval).setItem(entry.getKey(), this.cloneForNewDocument(destination, entry.getValue()));
                }
            } else {
                retval = (COSBase)base;
            }
        }
        this.clonedVersion.put(base, retval);
        return retval;
    }

    private void cloneMerge(PDDocument destination, COSObjectable base, COSObjectable target) throws IOException {
        if (base == null) {
            return;
        }
        COSBase retval = (COSBase)this.clonedVersion.get(base);
        if (retval != null) {
            return;
        }
        if (base instanceof List) {
            COSArray array = new COSArray();
            List list = (List)((Object)base);
            for (int i = 0; i < list.size(); ++i) {
                array.add(this.cloneForNewDocument(destination, list.get(i)));
            }
            ((List)((Object)target)).add(array);
        } else if (base instanceof COSObjectable && !(base instanceof COSBase)) {
            this.cloneMerge(destination, base.getCOSObject(), target.getCOSObject());
            this.clonedVersion.put(base, retval);
        } else if (base instanceof COSObject) {
            this.cloneMerge(destination, ((COSObject)base).getObject(), ((COSObject)target).getObject());
            this.clonedVersion.put(base, retval);
        } else if (base instanceof COSArray) {
            COSArray array = (COSArray)base;
            for (int i = 0; i < array.size(); ++i) {
                ((COSArray)target).add(this.cloneForNewDocument(destination, array.get(i)));
            }
            this.clonedVersion.put(base, retval);
        } else if (base instanceof COSStream) {
            COSStream originalStream = (COSStream)base;
            PDStream stream = new PDStream(destination, originalStream.getFilteredStream(), true);
            this.clonedVersion.put(base, stream.getStream());
            for (Map.Entry<COSName, COSBase> entry : originalStream.entrySet()) {
                stream.getStream().setItem(entry.getKey(), this.cloneForNewDocument(destination, entry.getValue()));
            }
            retval = stream.getStream();
            target = retval;
        } else if (base instanceof COSDictionary) {
            COSDictionary dic = (COSDictionary)base;
            this.clonedVersion.put(base, retval);
            for (Map.Entry<COSName, COSBase> entry : dic.entrySet()) {
                COSName key = entry.getKey();
                COSBase value = entry.getValue();
                if (((COSDictionary)target).getItem(key) != null) {
                    this.cloneMerge(destination, value, ((COSDictionary)target).getItem(key));
                    continue;
                }
                ((COSDictionary)target).setItem(key, this.cloneForNewDocument(destination, value));
            }
        } else {
            retval = (COSBase)base;
        }
        this.clonedVersion.put(base, retval);
    }

    private void mergeAcroForm(PDDocument destination, PDAcroForm destAcroForm, PDAcroForm srcAcroForm) throws IOException {
        List destFields = destAcroForm.getFields();
        List srcFields = srcAcroForm.getFields();
        if (srcFields != null) {
            if (destFields == null) {
                destFields = new COSArrayList();
                destAcroForm.setFields(destFields);
            }
            for (PDField srcField : srcFields) {
                PDField destField = PDFieldFactory.createField(destAcroForm, (COSDictionary)this.cloneForNewDocument(destination, srcField.getDictionary()));
                if (destAcroForm.getField(destField.getFullyQualifiedName()) != null) {
                    destField.setPartialName("dummyFieldName" + this.nextFieldNum++);
                }
                destFields.add(destField);
            }
        }
    }
}

