# Do not edit!!! This test suite generated by t/Policy/NamingConventions/capitalization.PL.

use strict;
use warnings;
use Perl::Lint::Policy::NamingConventions::Capitalization;
use t::Policy::Util qw/fetch_violations/;
use Test::Base::Less;

my $class_name = 'NamingConventions::Capitalization';

filters {
    params => [qw/eval/],
};

for my $block (blocks) {
    my $violations = fetch_violations($class_name, $block->input, $block->params);
    is scalar @$violations, $block->failures, $block->dscr;
}

done_testing;

__DATA__

===
--- dscr: Basic Passes
--- failures: 0
--- params:
--- input
my  $foo;
our $bar;
my($foo, $bar) = ("BLEH", "BLEH");
my @foo;
my %bar;
sub foo {}

my  $foo123;
my  $foo123bar;
sub foo123 {}
sub foo123bar {}

package This::SomeThing;
package This;
package This::Thing;
package Acme::12345;
package YYZ;

===
--- dscr: Basic Failures
--- failures: 14
--- params:
--- input
my  $Foo;
our $Bar;
my  @Foo;
my  %Bar;
sub Foo {}

my  $foo_Bar;
sub foo_Bar {}

my  $FooBar;
sub FooBar {}

my  $foo123Bar;
sub foo123Bar {}

package pragma;
package Foo::baz;
package baz::FooBar;

===
--- dscr: Special case: main
--- failures: 0
--- params:
--- input
package main;

===
--- dscr: Combined passes and fails
--- failures: 2
--- params:
--- input
my($foo, $Bar);
our($Bar, $foo);

===
--- dscr: Variables from other packages should pass
--- failures: 0
--- params:
--- input
local $Other::Package::Foo;
$Other::Package::Foo;

===
--- dscr: Only cares about declarations
--- failures: 0
--- params:
--- input
Foo();
$Foo = 42;

===
--- dscr: Constants must be all caps, passes
--- failures: 0
--- params:
--- input
Readonly::Scalar my $CONSTANT = 23;
const my $CONSTANT = 23;
use constant FOO => 42;
use constant { BAR => 3, BAZ => 7 };
use constant 1.16 FOO => 42;
use constant 1.16 { BAR => 3, BAZ => 7 };

===
--- dscr: Constants must be all caps, failures
--- failures: 3
--- params:
--- input
Readonly::Scalar my $Foo = 23;
Readonly::Scalar my $foo = 23;
const my $fooBAR = 23;

===
--- dscr: PPI misparses part of ternary as a label (RT #41170)
--- failures: 0
--- params:
--- input
my $foo = $condition ? $objection->method : $alternative;
my $foo = $condition ? undef : 1;

===
--- dscr: Package named "all_lower_case" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':single_case'}}
--- input
package all_lower_case;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':single_case', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "guaranteed_to_pass::all_lower_case" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':single_case'}}
--- input
package guaranteed_to_pass::all_lower_case;

===
--- dscr: Subroutine named "all_lower_case" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':single_case'}}
--- input
sub all_lower_case {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':single_case', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::all_lower_case" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':single_case'}}
--- input
sub Foo::Bar::all_lower_case;

===
--- dscr: Local lexical variable in subroutine named "all_lower_case" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':single_case'}}
--- input
sub some_subroutine {
    my $all_lower_case;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':single_case', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "all_lower_case" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':single_case'}}
--- input
CHECK {
    my $all_lower_case;
}

===
--- dscr: "our" variable named "all_lower_case" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
our $all_lower_case;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "all_lower_case" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
local $all_lower_case;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "all_lower_case" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':single_case'}}
--- input
foreach my $all_lower_case (@_) {
    say $all_lower_case;
}

===
--- dscr: State variable as foreach loop variable named "all_lower_case" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':single_case'}}
--- input
foreach state $all_lower_case (@_) {
    say $all_lower_case;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "all_lower_case" vs the ":single_case" capitalization scheme.
# --- failures: 0
# --- params: {capitalization => {local_lexical_variables => ':single_case'}}
# --- input
# foreach $all_lower_case (@_) {
#     say $all_lower_case;
# }

===
--- dscr: Global variable as foreach loop variable named "all_lower_case" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
foreach our $all_lower_case (@_) {
    say $all_lower_case;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "all_lower_case" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':single_case'}}
--- input
for (my $all_lower_case = -7; $all_lower_case <= 17; $all_lower_case += 3) {
    say $all_lower_case;
}

===
--- dscr: State variable as C-style for loop variable named "all_lower_case" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':single_case'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $all_lower_case = -7; $all_lower_case <= 17; $all_lower_case += 3) {
    say $all_lower_case;
}

===
--- dscr: Global variable as C-style for loop variable named "all_lower_case" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $all_lower_case = -7; $all_lower_case <= 17; $all_lower_case += 3) {
    say $all_lower_case;
}

===
--- dscr: Localized variable as C-style for loop variable named "all_lower_case" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $all_lower_case = -7; $all_lower_case <= 17; $all_lower_case += 3) {
    say $all_lower_case;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "all_lower_case" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':single_case'}}
--- input
sub some_subroutine {
    while (my $all_lower_case = <>) {
        say $all_lower_case;
    }
}

===
--- dscr: Label named "all_lower_case" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':single_case'}}
--- input
all_lower_case:
while ( foo() ) {
    next all_lower_case;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':single_case', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "ALL_UPPER_CASE" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':single_case'}}
--- input
package ALL_UPPER_CASE;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':single_case', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "guaranteed_to_pass::ALL_UPPER_CASE" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':single_case'}}
--- input
package guaranteed_to_pass::ALL_UPPER_CASE;

===
--- dscr: Subroutine named "ALL_UPPER_CASE" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':single_case'}}
--- input
sub ALL_UPPER_CASE {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':single_case', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::ALL_UPPER_CASE" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':single_case'}}
--- input
sub Foo::Bar::ALL_UPPER_CASE;

===
--- dscr: Local lexical variable in subroutine named "ALL_UPPER_CASE" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':single_case'}}
--- input
sub some_subroutine {
    my $ALL_UPPER_CASE;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':single_case', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "ALL_UPPER_CASE" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':single_case'}}
--- input
CHECK {
    my $ALL_UPPER_CASE;
}

===
--- dscr: "our" variable named "ALL_UPPER_CASE" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
our $ALL_UPPER_CASE;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "ALL_UPPER_CASE" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
local $ALL_UPPER_CASE;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "ALL_UPPER_CASE" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':single_case'}}
--- input
foreach my $ALL_UPPER_CASE (@_) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: State variable as foreach loop variable named "ALL_UPPER_CASE" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':single_case'}}
--- input
foreach state $ALL_UPPER_CASE (@_) {
    say $ALL_UPPER_CASE;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "ALL_UPPER_CASE" vs the ":single_case" capitalization scheme.
# --- failures: 0
# --- params: {capitalization => {local_lexical_variables => ':single_case'}}
# --- input
# foreach $ALL_UPPER_CASE (@_) {
#     say $ALL_UPPER_CASE;
# }

===
--- dscr: Global variable as foreach loop variable named "ALL_UPPER_CASE" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
foreach our $ALL_UPPER_CASE (@_) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "ALL_UPPER_CASE" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':single_case'}}
--- input
for (my $ALL_UPPER_CASE = -7; $ALL_UPPER_CASE <= 17; $ALL_UPPER_CASE += 3) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: State variable as C-style for loop variable named "ALL_UPPER_CASE" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':single_case'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $ALL_UPPER_CASE = -7; $ALL_UPPER_CASE <= 17; $ALL_UPPER_CASE += 3) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: Global variable as C-style for loop variable named "ALL_UPPER_CASE" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $ALL_UPPER_CASE = -7; $ALL_UPPER_CASE <= 17; $ALL_UPPER_CASE += 3) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: Localized variable as C-style for loop variable named "ALL_UPPER_CASE" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $ALL_UPPER_CASE = -7; $ALL_UPPER_CASE <= 17; $ALL_UPPER_CASE += 3) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "ALL_UPPER_CASE" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':single_case'}}
--- input
sub some_subroutine {
    while (my $ALL_UPPER_CASE = <>) {
        say $ALL_UPPER_CASE;
    }
}

===
--- dscr: Label named "ALL_UPPER_CASE" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':single_case'}}
--- input
ALL_UPPER_CASE:
while ( foo() ) {
    next ALL_UPPER_CASE;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':single_case', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "mixedCase" vs the ":single_case" capitalization scheme.
--- failures: 1
--- params: {capitalization => {packages => ':single_case'}}
--- input
package mixedCase;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':single_case', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "guaranteed_to_pass::mixedCase" vs the ":single_case" capitalization scheme.
--- failures: 1
--- params: {capitalization => {packages => ':single_case'}}
--- input
package guaranteed_to_pass::mixedCase;

===
--- dscr: Subroutine named "mixedCase" vs the ":single_case" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':single_case'}}
--- input
sub mixedCase {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':single_case', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::mixedCase" vs the ":single_case" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':single_case'}}
--- input
sub Foo::Bar::mixedCase;

===
--- dscr: Local lexical variable in subroutine named "mixedCase" vs the ":single_case" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':single_case'}}
--- input
sub some_subroutine {
    my $mixedCase;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':single_case', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "mixedCase" vs the ":single_case" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':single_case'}}
--- input
CHECK {
    my $mixedCase;
}

===
--- dscr: "our" variable named "mixedCase" vs the ":single_case" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
our $mixedCase;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "mixedCase" vs the ":single_case" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
local $mixedCase;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "mixedCase" vs the ":single_case" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':single_case'}}
--- input
foreach my $mixedCase (@_) {
    say $mixedCase;
}

===
--- dscr: State variable as foreach loop variable named "mixedCase" vs the ":single_case" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':single_case'}}
--- input
foreach state $mixedCase (@_) {
    say $mixedCase;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "mixedCase" vs the ":single_case" capitalization scheme.
# --- failures: 1
# --- params: {capitalization => {local_lexical_variables => ':single_case'}}
# --- input
# foreach $mixedCase (@_) {
#     say $mixedCase;
# }

===
--- dscr: Global variable as foreach loop variable named "mixedCase" vs the ":single_case" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
foreach our $mixedCase (@_) {
    say $mixedCase;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "mixedCase" vs the ":single_case" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':single_case'}}
--- input
for (my $mixedCase = -7; $mixedCase <= 17; $mixedCase += 3) {
    say $mixedCase;
}

===
--- dscr: State variable as C-style for loop variable named "mixedCase" vs the ":single_case" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':single_case'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $mixedCase = -7; $mixedCase <= 17; $mixedCase += 3) {
    say $mixedCase;
}

===
--- dscr: Global variable as C-style for loop variable named "mixedCase" vs the ":single_case" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $mixedCase = -7; $mixedCase <= 17; $mixedCase += 3) {
    say $mixedCase;
}

===
--- dscr: Localized variable as C-style for loop variable named "mixedCase" vs the ":single_case" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $mixedCase = -7; $mixedCase <= 17; $mixedCase += 3) {
    say $mixedCase;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "mixedCase" vs the ":single_case" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':single_case'}}
--- input
sub some_subroutine {
    while (my $mixedCase = <>) {
        say $mixedCase;
    }
}

===
--- dscr: Label named "mixedCase" vs the ":single_case" capitalization scheme.
--- failures: 1
--- params: {capitalization => {labels => ':single_case'}}
--- input
mixedCase:
while ( foo() ) {
    next mixedCase;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':single_case', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "a11_lower_case_with_digits" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':single_case'}}
--- input
package a11_lower_case_with_digits;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':single_case', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "guaranteed_to_pass::a11_lower_case_with_digits" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':single_case'}}
--- input
package guaranteed_to_pass::a11_lower_case_with_digits;

===
--- dscr: Subroutine named "a11_lower_case_with_digits" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':single_case'}}
--- input
sub a11_lower_case_with_digits {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':single_case', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::a11_lower_case_with_digits" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':single_case'}}
--- input
sub Foo::Bar::a11_lower_case_with_digits;

===
--- dscr: Local lexical variable in subroutine named "a11_lower_case_with_digits" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':single_case'}}
--- input
sub some_subroutine {
    my $a11_lower_case_with_digits;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':single_case', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "a11_lower_case_with_digits" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':single_case'}}
--- input
CHECK {
    my $a11_lower_case_with_digits;
}

===
--- dscr: "our" variable named "a11_lower_case_with_digits" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
our $a11_lower_case_with_digits;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "a11_lower_case_with_digits" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
local $a11_lower_case_with_digits;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "a11_lower_case_with_digits" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':single_case'}}
--- input
foreach my $a11_lower_case_with_digits (@_) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: State variable as foreach loop variable named "a11_lower_case_with_digits" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':single_case'}}
--- input
foreach state $a11_lower_case_with_digits (@_) {
    say $a11_lower_case_with_digits;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "a11_lower_case_with_digits" vs the ":single_case" capitalization scheme.
# --- failures: 0
# --- params: {capitalization => {local_lexical_variables => ':single_case'}}
# --- input
# foreach $a11_lower_case_with_digits (@_) {
#     say $a11_lower_case_with_digits;
# }

===
--- dscr: Global variable as foreach loop variable named "a11_lower_case_with_digits" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
foreach our $a11_lower_case_with_digits (@_) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "a11_lower_case_with_digits" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':single_case'}}
--- input
for (my $a11_lower_case_with_digits = -7; $a11_lower_case_with_digits <= 17; $a11_lower_case_with_digits += 3) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: State variable as C-style for loop variable named "a11_lower_case_with_digits" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':single_case'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $a11_lower_case_with_digits = -7; $a11_lower_case_with_digits <= 17; $a11_lower_case_with_digits += 3) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: Global variable as C-style for loop variable named "a11_lower_case_with_digits" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $a11_lower_case_with_digits = -7; $a11_lower_case_with_digits <= 17; $a11_lower_case_with_digits += 3) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: Localized variable as C-style for loop variable named "a11_lower_case_with_digits" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $a11_lower_case_with_digits = -7; $a11_lower_case_with_digits <= 17; $a11_lower_case_with_digits += 3) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "a11_lower_case_with_digits" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':single_case'}}
--- input
sub some_subroutine {
    while (my $a11_lower_case_with_digits = <>) {
        say $a11_lower_case_with_digits;
    }
}

===
--- dscr: Label named "a11_lower_case_with_digits" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':single_case'}}
--- input
a11_lower_case_with_digits:
while ( foo() ) {
    next a11_lower_case_with_digits;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':single_case', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "A11_UPPER_CASE_WITH_DIGITS" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':single_case'}}
--- input
package A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':single_case', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "guaranteed_to_pass::A11_UPPER_CASE_WITH_DIGITS" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':single_case'}}
--- input
package guaranteed_to_pass::A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Subroutine named "A11_UPPER_CASE_WITH_DIGITS" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':single_case'}}
--- input
sub A11_UPPER_CASE_WITH_DIGITS {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':single_case', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::A11_UPPER_CASE_WITH_DIGITS" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':single_case'}}
--- input
sub Foo::Bar::A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Local lexical variable in subroutine named "A11_UPPER_CASE_WITH_DIGITS" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':single_case'}}
--- input
sub some_subroutine {
    my $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':single_case', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "A11_UPPER_CASE_WITH_DIGITS" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':single_case'}}
--- input
CHECK {
    my $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: "our" variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
our $A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
local $A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':single_case'}}
--- input
foreach my $A11_UPPER_CASE_WITH_DIGITS (@_) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: State variable as foreach loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':single_case'}}
--- input
foreach state $A11_UPPER_CASE_WITH_DIGITS (@_) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":single_case" capitalization scheme.
# --- failures: 0
# --- params: {capitalization => {local_lexical_variables => ':single_case'}}
# --- input
# foreach $A11_UPPER_CASE_WITH_DIGITS (@_) {
#     say $A11_UPPER_CASE_WITH_DIGITS;
# }

===
--- dscr: Global variable as foreach loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
foreach our $A11_UPPER_CASE_WITH_DIGITS (@_) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':single_case'}}
--- input
for (my $A11_UPPER_CASE_WITH_DIGITS = -7; $A11_UPPER_CASE_WITH_DIGITS <= 17; $A11_UPPER_CASE_WITH_DIGITS += 3) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: State variable as C-style for loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':single_case'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $A11_UPPER_CASE_WITH_DIGITS = -7; $A11_UPPER_CASE_WITH_DIGITS <= 17; $A11_UPPER_CASE_WITH_DIGITS += 3) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Global variable as C-style for loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $A11_UPPER_CASE_WITH_DIGITS = -7; $A11_UPPER_CASE_WITH_DIGITS <= 17; $A11_UPPER_CASE_WITH_DIGITS += 3) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Localized variable as C-style for loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $A11_UPPER_CASE_WITH_DIGITS = -7; $A11_UPPER_CASE_WITH_DIGITS <= 17; $A11_UPPER_CASE_WITH_DIGITS += 3) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':single_case'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "A11_UPPER_CASE_WITH_DIGITS" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':single_case'}}
--- input
sub some_subroutine {
    while (my $A11_UPPER_CASE_WITH_DIGITS = <>) {
        say $A11_UPPER_CASE_WITH_DIGITS;
    }
}

===
--- dscr: Label named "A11_UPPER_CASE_WITH_DIGITS" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':single_case'}}
--- input
A11_UPPER_CASE_WITH_DIGITS:
while ( foo() ) {
    next A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":single_case" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':single_case', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "all_lower_case" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':all_lower'}}
--- input
package all_lower_case;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':all_lower', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "guaranteed_to_pass::all_lower_case" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':all_lower'}}
--- input
package guaranteed_to_pass::all_lower_case;

===
--- dscr: Subroutine named "all_lower_case" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower'}}
--- input
sub all_lower_case {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::all_lower_case" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower'}}
--- input
sub Foo::Bar::all_lower_case;

===
--- dscr: Local lexical variable in subroutine named "all_lower_case" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_lower'}}
--- input
sub some_subroutine {
    my $all_lower_case;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_lower', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "all_lower_case" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':all_lower'}}
--- input
CHECK {
    my $all_lower_case;
}

===
--- dscr: "our" variable named "all_lower_case" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
our $all_lower_case;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "all_lower_case" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
local $all_lower_case;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "all_lower_case" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':all_lower'}}
--- input
foreach my $all_lower_case (@_) {
    say $all_lower_case;
}

===
--- dscr: State variable as foreach loop variable named "all_lower_case" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':all_lower'}}
--- input
foreach state $all_lower_case (@_) {
    say $all_lower_case;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "all_lower_case" vs the ":all_lower" capitalization scheme.
# --- failures: 0
# --- params: {capitalization => {local_lexical_variables => ':all_lower'}}
# --- input
# foreach $all_lower_case (@_) {
#     say $all_lower_case;
# }

===
--- dscr: Global variable as foreach loop variable named "all_lower_case" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
foreach our $all_lower_case (@_) {
    say $all_lower_case;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "all_lower_case" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':all_lower'}}
--- input
for (my $all_lower_case = -7; $all_lower_case <= 17; $all_lower_case += 3) {
    say $all_lower_case;
}

===
--- dscr: State variable as C-style for loop variable named "all_lower_case" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':all_lower'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $all_lower_case = -7; $all_lower_case <= 17; $all_lower_case += 3) {
    say $all_lower_case;
}

===
--- dscr: Global variable as C-style for loop variable named "all_lower_case" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $all_lower_case = -7; $all_lower_case <= 17; $all_lower_case += 3) {
    say $all_lower_case;
}

===
--- dscr: Localized variable as C-style for loop variable named "all_lower_case" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $all_lower_case = -7; $all_lower_case <= 17; $all_lower_case += 3) {
    say $all_lower_case;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "all_lower_case" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_lower'}}
--- input
sub some_subroutine {
    while (my $all_lower_case = <>) {
        say $all_lower_case;
    }
}

===
--- dscr: Label named "all_lower_case" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':all_lower'}}
--- input
all_lower_case:
while ( foo() ) {
    next all_lower_case;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':all_lower', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "ALL_UPPER_CASE" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {packages => ':all_lower'}}
--- input
package ALL_UPPER_CASE;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':all_lower', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "guaranteed_to_pass::ALL_UPPER_CASE" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {packages => ':all_lower'}}
--- input
package guaranteed_to_pass::ALL_UPPER_CASE;

===
--- dscr: Subroutine named "ALL_UPPER_CASE" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower'}}
--- input
sub ALL_UPPER_CASE {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::ALL_UPPER_CASE" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower'}}
--- input
sub Foo::Bar::ALL_UPPER_CASE;

===
--- dscr: Local lexical variable in subroutine named "ALL_UPPER_CASE" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_lower'}}
--- input
sub some_subroutine {
    my $ALL_UPPER_CASE;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_lower', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "ALL_UPPER_CASE" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_lower'}}
--- input
CHECK {
    my $ALL_UPPER_CASE;
}

===
--- dscr: "our" variable named "ALL_UPPER_CASE" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
our $ALL_UPPER_CASE;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "ALL_UPPER_CASE" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
local $ALL_UPPER_CASE;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "ALL_UPPER_CASE" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_lower'}}
--- input
foreach my $ALL_UPPER_CASE (@_) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: State variable as foreach loop variable named "ALL_UPPER_CASE" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_lower'}}
--- input
foreach state $ALL_UPPER_CASE (@_) {
    say $ALL_UPPER_CASE;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "ALL_UPPER_CASE" vs the ":all_lower" capitalization scheme.
# --- failures: 1
# --- params: {capitalization => {local_lexical_variables => ':all_lower'}}
# --- input
# foreach $ALL_UPPER_CASE (@_) {
#     say $ALL_UPPER_CASE;
# }

===
--- dscr: Global variable as foreach loop variable named "ALL_UPPER_CASE" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
foreach our $ALL_UPPER_CASE (@_) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "ALL_UPPER_CASE" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_lower'}}
--- input
for (my $ALL_UPPER_CASE = -7; $ALL_UPPER_CASE <= 17; $ALL_UPPER_CASE += 3) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: State variable as C-style for loop variable named "ALL_UPPER_CASE" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_lower'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $ALL_UPPER_CASE = -7; $ALL_UPPER_CASE <= 17; $ALL_UPPER_CASE += 3) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: Global variable as C-style for loop variable named "ALL_UPPER_CASE" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $ALL_UPPER_CASE = -7; $ALL_UPPER_CASE <= 17; $ALL_UPPER_CASE += 3) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: Localized variable as C-style for loop variable named "ALL_UPPER_CASE" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $ALL_UPPER_CASE = -7; $ALL_UPPER_CASE <= 17; $ALL_UPPER_CASE += 3) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "ALL_UPPER_CASE" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_lower'}}
--- input
sub some_subroutine {
    while (my $ALL_UPPER_CASE = <>) {
        say $ALL_UPPER_CASE;
    }
}

===
--- dscr: Label named "ALL_UPPER_CASE" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {labels => ':all_lower'}}
--- input
ALL_UPPER_CASE:
while ( foo() ) {
    next ALL_UPPER_CASE;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':all_lower', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "mixedCase" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {packages => ':all_lower'}}
--- input
package mixedCase;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':all_lower', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "guaranteed_to_pass::mixedCase" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {packages => ':all_lower'}}
--- input
package guaranteed_to_pass::mixedCase;

===
--- dscr: Subroutine named "mixedCase" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower'}}
--- input
sub mixedCase {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::mixedCase" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower'}}
--- input
sub Foo::Bar::mixedCase;

===
--- dscr: Local lexical variable in subroutine named "mixedCase" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_lower'}}
--- input
sub some_subroutine {
    my $mixedCase;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_lower', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "mixedCase" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_lower'}}
--- input
CHECK {
    my $mixedCase;
}

===
--- dscr: "our" variable named "mixedCase" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
our $mixedCase;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "mixedCase" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
local $mixedCase;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "mixedCase" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_lower'}}
--- input
foreach my $mixedCase (@_) {
    say $mixedCase;
}

===
--- dscr: State variable as foreach loop variable named "mixedCase" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_lower'}}
--- input
foreach state $mixedCase (@_) {
    say $mixedCase;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "mixedCase" vs the ":all_lower" capitalization scheme.
# --- failures: 1
# --- params: {capitalization => {local_lexical_variables => ':all_lower'}}
# --- input
# foreach $mixedCase (@_) {
#     say $mixedCase;
# }

===
--- dscr: Global variable as foreach loop variable named "mixedCase" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
foreach our $mixedCase (@_) {
    say $mixedCase;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "mixedCase" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_lower'}}
--- input
for (my $mixedCase = -7; $mixedCase <= 17; $mixedCase += 3) {
    say $mixedCase;
}

===
--- dscr: State variable as C-style for loop variable named "mixedCase" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_lower'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $mixedCase = -7; $mixedCase <= 17; $mixedCase += 3) {
    say $mixedCase;
}

===
--- dscr: Global variable as C-style for loop variable named "mixedCase" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $mixedCase = -7; $mixedCase <= 17; $mixedCase += 3) {
    say $mixedCase;
}

===
--- dscr: Localized variable as C-style for loop variable named "mixedCase" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $mixedCase = -7; $mixedCase <= 17; $mixedCase += 3) {
    say $mixedCase;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "mixedCase" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_lower'}}
--- input
sub some_subroutine {
    while (my $mixedCase = <>) {
        say $mixedCase;
    }
}

===
--- dscr: Label named "mixedCase" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {labels => ':all_lower'}}
--- input
mixedCase:
while ( foo() ) {
    next mixedCase;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':all_lower', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "a11_lower_case_with_digits" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':all_lower'}}
--- input
package a11_lower_case_with_digits;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':all_lower', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "guaranteed_to_pass::a11_lower_case_with_digits" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':all_lower'}}
--- input
package guaranteed_to_pass::a11_lower_case_with_digits;

===
--- dscr: Subroutine named "a11_lower_case_with_digits" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower'}}
--- input
sub a11_lower_case_with_digits {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::a11_lower_case_with_digits" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower'}}
--- input
sub Foo::Bar::a11_lower_case_with_digits;

===
--- dscr: Local lexical variable in subroutine named "a11_lower_case_with_digits" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_lower'}}
--- input
sub some_subroutine {
    my $a11_lower_case_with_digits;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_lower', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "a11_lower_case_with_digits" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':all_lower'}}
--- input
CHECK {
    my $a11_lower_case_with_digits;
}

===
--- dscr: "our" variable named "a11_lower_case_with_digits" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
our $a11_lower_case_with_digits;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "a11_lower_case_with_digits" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
local $a11_lower_case_with_digits;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "a11_lower_case_with_digits" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':all_lower'}}
--- input
foreach my $a11_lower_case_with_digits (@_) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: State variable as foreach loop variable named "a11_lower_case_with_digits" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':all_lower'}}
--- input
foreach state $a11_lower_case_with_digits (@_) {
    say $a11_lower_case_with_digits;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "a11_lower_case_with_digits" vs the ":all_lower" capitalization scheme.
# --- failures: 0
# --- params: {capitalization => {local_lexical_variables => ':all_lower'}}
# --- input
# foreach $a11_lower_case_with_digits (@_) {
#     say $a11_lower_case_with_digits;
# }

===
--- dscr: Global variable as foreach loop variable named "a11_lower_case_with_digits" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
foreach our $a11_lower_case_with_digits (@_) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "a11_lower_case_with_digits" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':all_lower'}}
--- input
for (my $a11_lower_case_with_digits = -7; $a11_lower_case_with_digits <= 17; $a11_lower_case_with_digits += 3) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: State variable as C-style for loop variable named "a11_lower_case_with_digits" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':all_lower'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $a11_lower_case_with_digits = -7; $a11_lower_case_with_digits <= 17; $a11_lower_case_with_digits += 3) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: Global variable as C-style for loop variable named "a11_lower_case_with_digits" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $a11_lower_case_with_digits = -7; $a11_lower_case_with_digits <= 17; $a11_lower_case_with_digits += 3) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: Localized variable as C-style for loop variable named "a11_lower_case_with_digits" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $a11_lower_case_with_digits = -7; $a11_lower_case_with_digits <= 17; $a11_lower_case_with_digits += 3) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "a11_lower_case_with_digits" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_lower'}}
--- input
sub some_subroutine {
    while (my $a11_lower_case_with_digits = <>) {
        say $a11_lower_case_with_digits;
    }
}

===
--- dscr: Label named "a11_lower_case_with_digits" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':all_lower'}}
--- input
a11_lower_case_with_digits:
while ( foo() ) {
    next a11_lower_case_with_digits;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':all_lower', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {packages => ':all_lower'}}
--- input
package A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':all_lower', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "guaranteed_to_pass::A11_UPPER_CASE_WITH_DIGITS" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {packages => ':all_lower'}}
--- input
package guaranteed_to_pass::A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Subroutine named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower'}}
--- input
sub A11_UPPER_CASE_WITH_DIGITS {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::A11_UPPER_CASE_WITH_DIGITS" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower'}}
--- input
sub Foo::Bar::A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Local lexical variable in subroutine named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_lower'}}
--- input
sub some_subroutine {
    my $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_lower', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_lower'}}
--- input
CHECK {
    my $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: "our" variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
our $A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
local $A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_lower'}}
--- input
foreach my $A11_UPPER_CASE_WITH_DIGITS (@_) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: State variable as foreach loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_lower'}}
--- input
foreach state $A11_UPPER_CASE_WITH_DIGITS (@_) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_lower" capitalization scheme.
# --- failures: 1
# --- params: {capitalization => {local_lexical_variables => ':all_lower'}}
# --- input
# foreach $A11_UPPER_CASE_WITH_DIGITS (@_) {
#     say $A11_UPPER_CASE_WITH_DIGITS;
# }

===
--- dscr: Global variable as foreach loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
foreach our $A11_UPPER_CASE_WITH_DIGITS (@_) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_lower'}}
--- input
for (my $A11_UPPER_CASE_WITH_DIGITS = -7; $A11_UPPER_CASE_WITH_DIGITS <= 17; $A11_UPPER_CASE_WITH_DIGITS += 3) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: State variable as C-style for loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_lower'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $A11_UPPER_CASE_WITH_DIGITS = -7; $A11_UPPER_CASE_WITH_DIGITS <= 17; $A11_UPPER_CASE_WITH_DIGITS += 3) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Global variable as C-style for loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $A11_UPPER_CASE_WITH_DIGITS = -7; $A11_UPPER_CASE_WITH_DIGITS <= 17; $A11_UPPER_CASE_WITH_DIGITS += 3) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Localized variable as C-style for loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $A11_UPPER_CASE_WITH_DIGITS = -7; $A11_UPPER_CASE_WITH_DIGITS <= 17; $A11_UPPER_CASE_WITH_DIGITS += 3) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_lower'}}
--- input
sub some_subroutine {
    while (my $A11_UPPER_CASE_WITH_DIGITS = <>) {
        say $A11_UPPER_CASE_WITH_DIGITS;
    }
}

===
--- dscr: Label named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {labels => ':all_lower'}}
--- input
A11_UPPER_CASE_WITH_DIGITS:
while ( foo() ) {
    next A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":all_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':all_lower', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "all_lower_case" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {packages => ':all_upper'}}
--- input
package all_lower_case;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':all_upper', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "GUARANTEED_TO_PASS::all_lower_case" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {packages => ':all_upper'}}
--- input
package GUARANTEED_TO_PASS::all_lower_case;

===
--- dscr: Subroutine named "all_lower_case" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_upper'}}
--- input
sub all_lower_case {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_upper', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::all_lower_case" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_upper'}}
--- input
sub Foo::Bar::all_lower_case;

===
--- dscr: Local lexical variable in subroutine named "all_lower_case" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_upper'}}
--- input
sub some_subroutine {
    my $all_lower_case;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_upper', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "all_lower_case" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_upper'}}
--- input
CHECK {
    my $all_lower_case;
}

===
--- dscr: "our" variable named "all_lower_case" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
our $all_lower_case;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "all_lower_case" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
local $all_lower_case;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "all_lower_case" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_upper'}}
--- input
foreach my $all_lower_case (@_) {
    say $all_lower_case;
}

===
--- dscr: State variable as foreach loop variable named "all_lower_case" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_upper'}}
--- input
foreach state $all_lower_case (@_) {
    say $all_lower_case;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "all_lower_case" vs the ":all_upper" capitalization scheme.
# --- failures: 1
# --- params: {capitalization => {local_lexical_variables => ':all_upper'}}
# --- input
# foreach $all_lower_case (@_) {
#     say $all_lower_case;
# }

===
--- dscr: Global variable as foreach loop variable named "all_lower_case" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
foreach our $all_lower_case (@_) {
    say $all_lower_case;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "all_lower_case" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_upper'}}
--- input
for (my $all_lower_case = -7; $all_lower_case <= 17; $all_lower_case += 3) {
    say $all_lower_case;
}

===
--- dscr: State variable as C-style for loop variable named "all_lower_case" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_upper'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $all_lower_case = -7; $all_lower_case <= 17; $all_lower_case += 3) {
    say $all_lower_case;
}

===
--- dscr: Global variable as C-style for loop variable named "all_lower_case" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $all_lower_case = -7; $all_lower_case <= 17; $all_lower_case += 3) {
    say $all_lower_case;
}

===
--- dscr: Localized variable as C-style for loop variable named "all_lower_case" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $all_lower_case = -7; $all_lower_case <= 17; $all_lower_case += 3) {
    say $all_lower_case;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "all_lower_case" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_upper'}}
--- input
sub some_subroutine {
    while (my $all_lower_case = <>) {
        say $all_lower_case;
    }
}

===
--- dscr: Label named "all_lower_case" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {labels => ':all_upper'}}
--- input
all_lower_case:
while ( foo() ) {
    next all_lower_case;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':all_upper', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "ALL_UPPER_CASE" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':all_upper'}}
--- input
package ALL_UPPER_CASE;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':all_upper', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "GUARANTEED_TO_PASS::ALL_UPPER_CASE" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':all_upper'}}
--- input
package GUARANTEED_TO_PASS::ALL_UPPER_CASE;

===
--- dscr: Subroutine named "ALL_UPPER_CASE" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_upper'}}
--- input
sub ALL_UPPER_CASE {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_upper', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::ALL_UPPER_CASE" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_upper'}}
--- input
sub Foo::Bar::ALL_UPPER_CASE;

===
--- dscr: Local lexical variable in subroutine named "ALL_UPPER_CASE" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_upper'}}
--- input
sub some_subroutine {
    my $ALL_UPPER_CASE;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_upper', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "ALL_UPPER_CASE" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':all_upper'}}
--- input
CHECK {
    my $ALL_UPPER_CASE;
}

===
--- dscr: "our" variable named "ALL_UPPER_CASE" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
our $ALL_UPPER_CASE;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "ALL_UPPER_CASE" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
local $ALL_UPPER_CASE;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "ALL_UPPER_CASE" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':all_upper'}}
--- input
foreach my $ALL_UPPER_CASE (@_) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: State variable as foreach loop variable named "ALL_UPPER_CASE" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':all_upper'}}
--- input
foreach state $ALL_UPPER_CASE (@_) {
    say $ALL_UPPER_CASE;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "ALL_UPPER_CASE" vs the ":all_upper" capitalization scheme.
# --- failures: 0
# --- params: {capitalization => {local_lexical_variables => ':all_upper'}}
# --- input
# foreach $ALL_UPPER_CASE (@_) {
#     say $ALL_UPPER_CASE;
# }

===
--- dscr: Global variable as foreach loop variable named "ALL_UPPER_CASE" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
foreach our $ALL_UPPER_CASE (@_) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "ALL_UPPER_CASE" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':all_upper'}}
--- input
for (my $ALL_UPPER_CASE = -7; $ALL_UPPER_CASE <= 17; $ALL_UPPER_CASE += 3) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: State variable as C-style for loop variable named "ALL_UPPER_CASE" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':all_upper'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $ALL_UPPER_CASE = -7; $ALL_UPPER_CASE <= 17; $ALL_UPPER_CASE += 3) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: Global variable as C-style for loop variable named "ALL_UPPER_CASE" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $ALL_UPPER_CASE = -7; $ALL_UPPER_CASE <= 17; $ALL_UPPER_CASE += 3) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: Localized variable as C-style for loop variable named "ALL_UPPER_CASE" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $ALL_UPPER_CASE = -7; $ALL_UPPER_CASE <= 17; $ALL_UPPER_CASE += 3) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "ALL_UPPER_CASE" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_upper'}}
--- input
sub some_subroutine {
    while (my $ALL_UPPER_CASE = <>) {
        say $ALL_UPPER_CASE;
    }
}

===
--- dscr: Label named "ALL_UPPER_CASE" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':all_upper'}}
--- input
ALL_UPPER_CASE:
while ( foo() ) {
    next ALL_UPPER_CASE;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':all_upper', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "mixedCase" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {packages => ':all_upper'}}
--- input
package mixedCase;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':all_upper', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "GUARANTEED_TO_PASS::mixedCase" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {packages => ':all_upper'}}
--- input
package GUARANTEED_TO_PASS::mixedCase;

===
--- dscr: Subroutine named "mixedCase" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_upper'}}
--- input
sub mixedCase {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_upper', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::mixedCase" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_upper'}}
--- input
sub Foo::Bar::mixedCase;

===
--- dscr: Local lexical variable in subroutine named "mixedCase" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_upper'}}
--- input
sub some_subroutine {
    my $mixedCase;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_upper', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "mixedCase" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_upper'}}
--- input
CHECK {
    my $mixedCase;
}

===
--- dscr: "our" variable named "mixedCase" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
our $mixedCase;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "mixedCase" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
local $mixedCase;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "mixedCase" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_upper'}}
--- input
foreach my $mixedCase (@_) {
    say $mixedCase;
}

===
--- dscr: State variable as foreach loop variable named "mixedCase" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_upper'}}
--- input
foreach state $mixedCase (@_) {
    say $mixedCase;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "mixedCase" vs the ":all_upper" capitalization scheme.
# --- failures: 1
# --- params: {capitalization => {local_lexical_variables => ':all_upper'}}
# --- input
# foreach $mixedCase (@_) {
#     say $mixedCase;
# }

===
--- dscr: Global variable as foreach loop variable named "mixedCase" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
foreach our $mixedCase (@_) {
    say $mixedCase;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "mixedCase" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_upper'}}
--- input
for (my $mixedCase = -7; $mixedCase <= 17; $mixedCase += 3) {
    say $mixedCase;
}

===
--- dscr: State variable as C-style for loop variable named "mixedCase" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_upper'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $mixedCase = -7; $mixedCase <= 17; $mixedCase += 3) {
    say $mixedCase;
}

===
--- dscr: Global variable as C-style for loop variable named "mixedCase" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $mixedCase = -7; $mixedCase <= 17; $mixedCase += 3) {
    say $mixedCase;
}

===
--- dscr: Localized variable as C-style for loop variable named "mixedCase" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $mixedCase = -7; $mixedCase <= 17; $mixedCase += 3) {
    say $mixedCase;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "mixedCase" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_upper'}}
--- input
sub some_subroutine {
    while (my $mixedCase = <>) {
        say $mixedCase;
    }
}

===
--- dscr: Label named "mixedCase" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {labels => ':all_upper'}}
--- input
mixedCase:
while ( foo() ) {
    next mixedCase;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':all_upper', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "a11_lower_case_with_digits" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {packages => ':all_upper'}}
--- input
package a11_lower_case_with_digits;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':all_upper', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "GUARANTEED_TO_PASS::a11_lower_case_with_digits" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {packages => ':all_upper'}}
--- input
package GUARANTEED_TO_PASS::a11_lower_case_with_digits;

===
--- dscr: Subroutine named "a11_lower_case_with_digits" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_upper'}}
--- input
sub a11_lower_case_with_digits {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_upper', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::a11_lower_case_with_digits" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_upper'}}
--- input
sub Foo::Bar::a11_lower_case_with_digits;

===
--- dscr: Local lexical variable in subroutine named "a11_lower_case_with_digits" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_upper'}}
--- input
sub some_subroutine {
    my $a11_lower_case_with_digits;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_upper', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "a11_lower_case_with_digits" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_upper'}}
--- input
CHECK {
    my $a11_lower_case_with_digits;
}

===
--- dscr: "our" variable named "a11_lower_case_with_digits" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
our $a11_lower_case_with_digits;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "a11_lower_case_with_digits" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
local $a11_lower_case_with_digits;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "a11_lower_case_with_digits" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_upper'}}
--- input
foreach my $a11_lower_case_with_digits (@_) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: State variable as foreach loop variable named "a11_lower_case_with_digits" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_upper'}}
--- input
foreach state $a11_lower_case_with_digits (@_) {
    say $a11_lower_case_with_digits;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "a11_lower_case_with_digits" vs the ":all_upper" capitalization scheme.
# --- failures: 1
# --- params: {capitalization => {local_lexical_variables => ':all_upper'}}
# --- input
# foreach $a11_lower_case_with_digits (@_) {
#     say $a11_lower_case_with_digits;
# }

===
--- dscr: Global variable as foreach loop variable named "a11_lower_case_with_digits" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
foreach our $a11_lower_case_with_digits (@_) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "a11_lower_case_with_digits" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_upper'}}
--- input
for (my $a11_lower_case_with_digits = -7; $a11_lower_case_with_digits <= 17; $a11_lower_case_with_digits += 3) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: State variable as C-style for loop variable named "a11_lower_case_with_digits" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':all_upper'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $a11_lower_case_with_digits = -7; $a11_lower_case_with_digits <= 17; $a11_lower_case_with_digits += 3) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: Global variable as C-style for loop variable named "a11_lower_case_with_digits" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $a11_lower_case_with_digits = -7; $a11_lower_case_with_digits <= 17; $a11_lower_case_with_digits += 3) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: Localized variable as C-style for loop variable named "a11_lower_case_with_digits" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $a11_lower_case_with_digits = -7; $a11_lower_case_with_digits <= 17; $a11_lower_case_with_digits += 3) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "a11_lower_case_with_digits" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_upper'}}
--- input
sub some_subroutine {
    while (my $a11_lower_case_with_digits = <>) {
        say $a11_lower_case_with_digits;
    }
}

===
--- dscr: Label named "a11_lower_case_with_digits" vs the ":all_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {labels => ':all_upper'}}
--- input
a11_lower_case_with_digits:
while ( foo() ) {
    next a11_lower_case_with_digits;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':all_upper', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':all_upper'}}
--- input
package A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':all_upper', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "GUARANTEED_TO_PASS::A11_UPPER_CASE_WITH_DIGITS" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':all_upper'}}
--- input
package GUARANTEED_TO_PASS::A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Subroutine named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_upper'}}
--- input
sub A11_UPPER_CASE_WITH_DIGITS {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_upper', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::A11_UPPER_CASE_WITH_DIGITS" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_upper'}}
--- input
sub Foo::Bar::A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Local lexical variable in subroutine named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_upper'}}
--- input
sub some_subroutine {
    my $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_upper', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':all_upper'}}
--- input
CHECK {
    my $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: "our" variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
our $A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
local $A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':all_upper'}}
--- input
foreach my $A11_UPPER_CASE_WITH_DIGITS (@_) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: State variable as foreach loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':all_upper'}}
--- input
foreach state $A11_UPPER_CASE_WITH_DIGITS (@_) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_upper" capitalization scheme.
# --- failures: 0
# --- params: {capitalization => {local_lexical_variables => ':all_upper'}}
# --- input
# foreach $A11_UPPER_CASE_WITH_DIGITS (@_) {
#     say $A11_UPPER_CASE_WITH_DIGITS;
# }

===
--- dscr: Global variable as foreach loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
foreach our $A11_UPPER_CASE_WITH_DIGITS (@_) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':all_upper'}}
--- input
for (my $A11_UPPER_CASE_WITH_DIGITS = -7; $A11_UPPER_CASE_WITH_DIGITS <= 17; $A11_UPPER_CASE_WITH_DIGITS += 3) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: State variable as C-style for loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':all_upper'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $A11_UPPER_CASE_WITH_DIGITS = -7; $A11_UPPER_CASE_WITH_DIGITS <= 17; $A11_UPPER_CASE_WITH_DIGITS += 3) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Global variable as C-style for loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $A11_UPPER_CASE_WITH_DIGITS = -7; $A11_UPPER_CASE_WITH_DIGITS <= 17; $A11_UPPER_CASE_WITH_DIGITS += 3) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Localized variable as C-style for loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $A11_UPPER_CASE_WITH_DIGITS = -7; $A11_UPPER_CASE_WITH_DIGITS <= 17; $A11_UPPER_CASE_WITH_DIGITS += 3) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_upper'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':all_upper'}}
--- input
sub some_subroutine {
    while (my $A11_UPPER_CASE_WITH_DIGITS = <>) {
        say $A11_UPPER_CASE_WITH_DIGITS;
    }
}

===
--- dscr: Label named "A11_UPPER_CASE_WITH_DIGITS" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':all_upper'}}
--- input
A11_UPPER_CASE_WITH_DIGITS:
while ( foo() ) {
    next A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":all_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':all_upper', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "all_lower_case" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':starts_with_lower'}}
--- input
package all_lower_case;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':starts_with_lower', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "guaranteed_to_pass::all_lower_case" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':starts_with_lower'}}
--- input
package guaranteed_to_pass::all_lower_case;

===
--- dscr: Subroutine named "all_lower_case" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':starts_with_lower'}}
--- input
sub all_lower_case {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':starts_with_lower', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::all_lower_case" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':starts_with_lower'}}
--- input
sub Foo::Bar::all_lower_case;

===
--- dscr: Local lexical variable in subroutine named "all_lower_case" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_lower'}}
--- input
sub some_subroutine {
    my $all_lower_case;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_lower', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "all_lower_case" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
--- input
CHECK {
    my $all_lower_case;
}

===
--- dscr: "our" variable named "all_lower_case" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
our $all_lower_case;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "all_lower_case" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
local $all_lower_case;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "all_lower_case" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
--- input
foreach my $all_lower_case (@_) {
    say $all_lower_case;
}

===
--- dscr: State variable as foreach loop variable named "all_lower_case" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
--- input
foreach state $all_lower_case (@_) {
    say $all_lower_case;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "all_lower_case" vs the ":starts_with_lower" capitalization scheme.
# --- failures: 0
# --- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
# --- input
# foreach $all_lower_case (@_) {
#     say $all_lower_case;
# }

===
--- dscr: Global variable as foreach loop variable named "all_lower_case" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
foreach our $all_lower_case (@_) {
    say $all_lower_case;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "all_lower_case" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
--- input
for (my $all_lower_case = -7; $all_lower_case <= 17; $all_lower_case += 3) {
    say $all_lower_case;
}

===
--- dscr: State variable as C-style for loop variable named "all_lower_case" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $all_lower_case = -7; $all_lower_case <= 17; $all_lower_case += 3) {
    say $all_lower_case;
}

===
--- dscr: Global variable as C-style for loop variable named "all_lower_case" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $all_lower_case = -7; $all_lower_case <= 17; $all_lower_case += 3) {
    say $all_lower_case;
}

===
--- dscr: Localized variable as C-style for loop variable named "all_lower_case" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $all_lower_case = -7; $all_lower_case <= 17; $all_lower_case += 3) {
    say $all_lower_case;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "all_lower_case" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_lower'}}
--- input
sub some_subroutine {
    while (my $all_lower_case = <>) {
        say $all_lower_case;
    }
}

===
--- dscr: Label named "all_lower_case" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':starts_with_lower'}}
--- input
all_lower_case:
while ( foo() ) {
    next all_lower_case;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':starts_with_lower', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "ALL_UPPER_CASE" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {packages => ':starts_with_lower'}}
--- input
package ALL_UPPER_CASE;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':starts_with_lower', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "guaranteed_to_pass::ALL_UPPER_CASE" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {packages => ':starts_with_lower'}}
--- input
package guaranteed_to_pass::ALL_UPPER_CASE;

===
--- dscr: Subroutine named "ALL_UPPER_CASE" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':starts_with_lower'}}
--- input
sub ALL_UPPER_CASE {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':starts_with_lower', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::ALL_UPPER_CASE" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':starts_with_lower'}}
--- input
sub Foo::Bar::ALL_UPPER_CASE;

===
--- dscr: Local lexical variable in subroutine named "ALL_UPPER_CASE" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_lower'}}
--- input
sub some_subroutine {
    my $ALL_UPPER_CASE;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_lower', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "ALL_UPPER_CASE" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
--- input
CHECK {
    my $ALL_UPPER_CASE;
}

===
--- dscr: "our" variable named "ALL_UPPER_CASE" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
our $ALL_UPPER_CASE;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "ALL_UPPER_CASE" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
local $ALL_UPPER_CASE;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "ALL_UPPER_CASE" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
--- input
foreach my $ALL_UPPER_CASE (@_) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: State variable as foreach loop variable named "ALL_UPPER_CASE" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
--- input
foreach state $ALL_UPPER_CASE (@_) {
    say $ALL_UPPER_CASE;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "ALL_UPPER_CASE" vs the ":starts_with_lower" capitalization scheme.
# --- failures: 1
# --- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
# --- input
# foreach $ALL_UPPER_CASE (@_) {
#     say $ALL_UPPER_CASE;
# }

===
--- dscr: Global variable as foreach loop variable named "ALL_UPPER_CASE" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
foreach our $ALL_UPPER_CASE (@_) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "ALL_UPPER_CASE" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
--- input
for (my $ALL_UPPER_CASE = -7; $ALL_UPPER_CASE <= 17; $ALL_UPPER_CASE += 3) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: State variable as C-style for loop variable named "ALL_UPPER_CASE" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $ALL_UPPER_CASE = -7; $ALL_UPPER_CASE <= 17; $ALL_UPPER_CASE += 3) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: Global variable as C-style for loop variable named "ALL_UPPER_CASE" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $ALL_UPPER_CASE = -7; $ALL_UPPER_CASE <= 17; $ALL_UPPER_CASE += 3) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: Localized variable as C-style for loop variable named "ALL_UPPER_CASE" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $ALL_UPPER_CASE = -7; $ALL_UPPER_CASE <= 17; $ALL_UPPER_CASE += 3) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "ALL_UPPER_CASE" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_lower'}}
--- input
sub some_subroutine {
    while (my $ALL_UPPER_CASE = <>) {
        say $ALL_UPPER_CASE;
    }
}

===
--- dscr: Label named "ALL_UPPER_CASE" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {labels => ':starts_with_lower'}}
--- input
ALL_UPPER_CASE:
while ( foo() ) {
    next ALL_UPPER_CASE;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':starts_with_lower', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "________all_lower_case_with_leading_underscores" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':starts_with_lower'}}
--- input
package ________all_lower_case_with_leading_underscores;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':starts_with_lower', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "guaranteed_to_pass::________all_lower_case_with_leading_underscores" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':starts_with_lower'}}
--- input
package guaranteed_to_pass::________all_lower_case_with_leading_underscores;

===
--- dscr: Subroutine named "________all_lower_case_with_leading_underscores" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':starts_with_lower'}}
--- input
sub ________all_lower_case_with_leading_underscores {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':starts_with_lower', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::________all_lower_case_with_leading_underscores" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':starts_with_lower'}}
--- input
sub Foo::Bar::________all_lower_case_with_leading_underscores;

===
--- dscr: Local lexical variable in subroutine named "________all_lower_case_with_leading_underscores" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_lower'}}
--- input
sub some_subroutine {
    my $________all_lower_case_with_leading_underscores;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_lower', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "________all_lower_case_with_leading_underscores" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
--- input
CHECK {
    my $________all_lower_case_with_leading_underscores;
}

===
--- dscr: "our" variable named "________all_lower_case_with_leading_underscores" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
our $________all_lower_case_with_leading_underscores;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "________all_lower_case_with_leading_underscores" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
local $________all_lower_case_with_leading_underscores;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "________all_lower_case_with_leading_underscores" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
--- input
foreach my $________all_lower_case_with_leading_underscores (@_) {
    say $________all_lower_case_with_leading_underscores;
}

===
--- dscr: State variable as foreach loop variable named "________all_lower_case_with_leading_underscores" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
--- input
foreach state $________all_lower_case_with_leading_underscores (@_) {
    say $________all_lower_case_with_leading_underscores;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "________all_lower_case_with_leading_underscores" vs the ":starts_with_lower" capitalization scheme.
# --- failures: 0
# --- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
# --- input
# foreach $________all_lower_case_with_leading_underscores (@_) {
#     say $________all_lower_case_with_leading_underscores;
# }

===
--- dscr: Global variable as foreach loop variable named "________all_lower_case_with_leading_underscores" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
foreach our $________all_lower_case_with_leading_underscores (@_) {
    say $________all_lower_case_with_leading_underscores;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "________all_lower_case_with_leading_underscores" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
--- input
for (my $________all_lower_case_with_leading_underscores = -7; $________all_lower_case_with_leading_underscores <= 17; $________all_lower_case_with_leading_underscores += 3) {
    say $________all_lower_case_with_leading_underscores;
}

===
--- dscr: State variable as C-style for loop variable named "________all_lower_case_with_leading_underscores" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $________all_lower_case_with_leading_underscores = -7; $________all_lower_case_with_leading_underscores <= 17; $________all_lower_case_with_leading_underscores += 3) {
    say $________all_lower_case_with_leading_underscores;
}

===
--- dscr: Global variable as C-style for loop variable named "________all_lower_case_with_leading_underscores" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $________all_lower_case_with_leading_underscores = -7; $________all_lower_case_with_leading_underscores <= 17; $________all_lower_case_with_leading_underscores += 3) {
    say $________all_lower_case_with_leading_underscores;
}

===
--- dscr: Localized variable as C-style for loop variable named "________all_lower_case_with_leading_underscores" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $________all_lower_case_with_leading_underscores = -7; $________all_lower_case_with_leading_underscores <= 17; $________all_lower_case_with_leading_underscores += 3) {
    say $________all_lower_case_with_leading_underscores;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "________all_lower_case_with_leading_underscores" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_lower'}}
--- input
sub some_subroutine {
    while (my $________all_lower_case_with_leading_underscores = <>) {
        say $________all_lower_case_with_leading_underscores;
    }
}

===
--- dscr: Label named "________all_lower_case_with_leading_underscores" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':starts_with_lower'}}
--- input
________all_lower_case_with_leading_underscores:
while ( foo() ) {
    next ________all_lower_case_with_leading_underscores;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':starts_with_lower', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "a11_lower_case_with_digits" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':starts_with_lower'}}
--- input
package a11_lower_case_with_digits;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':starts_with_lower', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "guaranteed_to_pass::a11_lower_case_with_digits" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':starts_with_lower'}}
--- input
package guaranteed_to_pass::a11_lower_case_with_digits;

===
--- dscr: Subroutine named "a11_lower_case_with_digits" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':starts_with_lower'}}
--- input
sub a11_lower_case_with_digits {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':starts_with_lower', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::a11_lower_case_with_digits" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':starts_with_lower'}}
--- input
sub Foo::Bar::a11_lower_case_with_digits;

===
--- dscr: Local lexical variable in subroutine named "a11_lower_case_with_digits" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_lower'}}
--- input
sub some_subroutine {
    my $a11_lower_case_with_digits;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_lower', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "a11_lower_case_with_digits" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
--- input
CHECK {
    my $a11_lower_case_with_digits;
}

===
--- dscr: "our" variable named "a11_lower_case_with_digits" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
our $a11_lower_case_with_digits;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "a11_lower_case_with_digits" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
local $a11_lower_case_with_digits;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "a11_lower_case_with_digits" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
--- input
foreach my $a11_lower_case_with_digits (@_) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: State variable as foreach loop variable named "a11_lower_case_with_digits" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
--- input
foreach state $a11_lower_case_with_digits (@_) {
    say $a11_lower_case_with_digits;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "a11_lower_case_with_digits" vs the ":starts_with_lower" capitalization scheme.
# --- failures: 0
# --- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
# --- input
# foreach $a11_lower_case_with_digits (@_) {
#     say $a11_lower_case_with_digits;
# }

===
--- dscr: Global variable as foreach loop variable named "a11_lower_case_with_digits" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
foreach our $a11_lower_case_with_digits (@_) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "a11_lower_case_with_digits" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
--- input
for (my $a11_lower_case_with_digits = -7; $a11_lower_case_with_digits <= 17; $a11_lower_case_with_digits += 3) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: State variable as C-style for loop variable named "a11_lower_case_with_digits" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $a11_lower_case_with_digits = -7; $a11_lower_case_with_digits <= 17; $a11_lower_case_with_digits += 3) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: Global variable as C-style for loop variable named "a11_lower_case_with_digits" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $a11_lower_case_with_digits = -7; $a11_lower_case_with_digits <= 17; $a11_lower_case_with_digits += 3) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: Localized variable as C-style for loop variable named "a11_lower_case_with_digits" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $a11_lower_case_with_digits = -7; $a11_lower_case_with_digits <= 17; $a11_lower_case_with_digits += 3) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "a11_lower_case_with_digits" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_lower'}}
--- input
sub some_subroutine {
    while (my $a11_lower_case_with_digits = <>) {
        say $a11_lower_case_with_digits;
    }
}

===
--- dscr: Label named "a11_lower_case_with_digits" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':starts_with_lower'}}
--- input
a11_lower_case_with_digits:
while ( foo() ) {
    next a11_lower_case_with_digits;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':starts_with_lower', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {packages => ':starts_with_lower'}}
--- input
package A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':starts_with_lower', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "guaranteed_to_pass::A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {packages => ':starts_with_lower'}}
--- input
package guaranteed_to_pass::A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Subroutine named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':starts_with_lower'}}
--- input
sub A11_UPPER_CASE_WITH_DIGITS {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':starts_with_lower', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':starts_with_lower'}}
--- input
sub Foo::Bar::A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Local lexical variable in subroutine named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_lower'}}
--- input
sub some_subroutine {
    my $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_lower', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
--- input
CHECK {
    my $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: "our" variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
our $A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
local $A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
--- input
foreach my $A11_UPPER_CASE_WITH_DIGITS (@_) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: State variable as foreach loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
--- input
foreach state $A11_UPPER_CASE_WITH_DIGITS (@_) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_lower" capitalization scheme.
# --- failures: 1
# --- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
# --- input
# foreach $A11_UPPER_CASE_WITH_DIGITS (@_) {
#     say $A11_UPPER_CASE_WITH_DIGITS;
# }

===
--- dscr: Global variable as foreach loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
foreach our $A11_UPPER_CASE_WITH_DIGITS (@_) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
--- input
for (my $A11_UPPER_CASE_WITH_DIGITS = -7; $A11_UPPER_CASE_WITH_DIGITS <= 17; $A11_UPPER_CASE_WITH_DIGITS += 3) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: State variable as C-style for loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':starts_with_lower'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $A11_UPPER_CASE_WITH_DIGITS = -7; $A11_UPPER_CASE_WITH_DIGITS <= 17; $A11_UPPER_CASE_WITH_DIGITS += 3) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Global variable as C-style for loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $A11_UPPER_CASE_WITH_DIGITS = -7; $A11_UPPER_CASE_WITH_DIGITS <= 17; $A11_UPPER_CASE_WITH_DIGITS += 3) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Localized variable as C-style for loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $A11_UPPER_CASE_WITH_DIGITS = -7; $A11_UPPER_CASE_WITH_DIGITS <= 17; $A11_UPPER_CASE_WITH_DIGITS += 3) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_lower'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_lower'}}
--- input
sub some_subroutine {
    while (my $A11_UPPER_CASE_WITH_DIGITS = <>) {
        say $A11_UPPER_CASE_WITH_DIGITS;
    }
}

===
--- dscr: Label named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_lower" capitalization scheme.
--- failures: 1
--- params: {capitalization => {labels => ':starts_with_lower'}}
--- input
A11_UPPER_CASE_WITH_DIGITS:
while ( foo() ) {
    next A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":starts_with_lower" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':starts_with_lower', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "all_lower_case" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {packages => ':starts_with_upper'}}
--- input
package all_lower_case;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':starts_with_upper', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "GUARANTEED_TO_PASS::all_lower_case" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {packages => ':starts_with_upper'}}
--- input
package GUARANTEED_TO_PASS::all_lower_case;

===
--- dscr: Subroutine named "all_lower_case" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':starts_with_upper'}}
--- input
sub all_lower_case {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':starts_with_upper', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::all_lower_case" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':starts_with_upper'}}
--- input
sub Foo::Bar::all_lower_case;

===
--- dscr: Local lexical variable in subroutine named "all_lower_case" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_upper'}}
--- input
sub some_subroutine {
    my $all_lower_case;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_upper', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "all_lower_case" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
--- input
CHECK {
    my $all_lower_case;
}

===
--- dscr: "our" variable named "all_lower_case" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
our $all_lower_case;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "all_lower_case" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
local $all_lower_case;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "all_lower_case" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
--- input
foreach my $all_lower_case (@_) {
    say $all_lower_case;
}

===
--- dscr: State variable as foreach loop variable named "all_lower_case" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
--- input
foreach state $all_lower_case (@_) {
    say $all_lower_case;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "all_lower_case" vs the ":starts_with_upper" capitalization scheme.
# --- failures: 1
# --- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
# --- input
# foreach $all_lower_case (@_) {
#     say $all_lower_case;
# }

===
--- dscr: Global variable as foreach loop variable named "all_lower_case" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
foreach our $all_lower_case (@_) {
    say $all_lower_case;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "all_lower_case" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
--- input
for (my $all_lower_case = -7; $all_lower_case <= 17; $all_lower_case += 3) {
    say $all_lower_case;
}

===
--- dscr: State variable as C-style for loop variable named "all_lower_case" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $all_lower_case = -7; $all_lower_case <= 17; $all_lower_case += 3) {
    say $all_lower_case;
}

===
--- dscr: Global variable as C-style for loop variable named "all_lower_case" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $all_lower_case = -7; $all_lower_case <= 17; $all_lower_case += 3) {
    say $all_lower_case;
}

===
--- dscr: Localized variable as C-style for loop variable named "all_lower_case" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $all_lower_case = -7; $all_lower_case <= 17; $all_lower_case += 3) {
    say $all_lower_case;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "all_lower_case" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_upper'}}
--- input
sub some_subroutine {
    while (my $all_lower_case = <>) {
        say $all_lower_case;
    }
}

===
--- dscr: Label named "all_lower_case" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {labels => ':starts_with_upper'}}
--- input
all_lower_case:
while ( foo() ) {
    next all_lower_case;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':starts_with_upper', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "ALL_UPPER_CASE" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':starts_with_upper'}}
--- input
package ALL_UPPER_CASE;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':starts_with_upper', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "GUARANTEED_TO_PASS::ALL_UPPER_CASE" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':starts_with_upper'}}
--- input
package GUARANTEED_TO_PASS::ALL_UPPER_CASE;

===
--- dscr: Subroutine named "ALL_UPPER_CASE" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':starts_with_upper'}}
--- input
sub ALL_UPPER_CASE {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':starts_with_upper', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::ALL_UPPER_CASE" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':starts_with_upper'}}
--- input
sub Foo::Bar::ALL_UPPER_CASE;

===
--- dscr: Local lexical variable in subroutine named "ALL_UPPER_CASE" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_upper'}}
--- input
sub some_subroutine {
    my $ALL_UPPER_CASE;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_upper', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "ALL_UPPER_CASE" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
--- input
CHECK {
    my $ALL_UPPER_CASE;
}

===
--- dscr: "our" variable named "ALL_UPPER_CASE" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
our $ALL_UPPER_CASE;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "ALL_UPPER_CASE" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
local $ALL_UPPER_CASE;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "ALL_UPPER_CASE" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
--- input
foreach my $ALL_UPPER_CASE (@_) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: State variable as foreach loop variable named "ALL_UPPER_CASE" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
--- input
foreach state $ALL_UPPER_CASE (@_) {
    say $ALL_UPPER_CASE;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "ALL_UPPER_CASE" vs the ":starts_with_upper" capitalization scheme.
# --- failures: 0
# --- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
# --- input
# foreach $ALL_UPPER_CASE (@_) {
#     say $ALL_UPPER_CASE;
# }

===
--- dscr: Global variable as foreach loop variable named "ALL_UPPER_CASE" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
foreach our $ALL_UPPER_CASE (@_) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "ALL_UPPER_CASE" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
--- input
for (my $ALL_UPPER_CASE = -7; $ALL_UPPER_CASE <= 17; $ALL_UPPER_CASE += 3) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: State variable as C-style for loop variable named "ALL_UPPER_CASE" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $ALL_UPPER_CASE = -7; $ALL_UPPER_CASE <= 17; $ALL_UPPER_CASE += 3) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: Global variable as C-style for loop variable named "ALL_UPPER_CASE" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $ALL_UPPER_CASE = -7; $ALL_UPPER_CASE <= 17; $ALL_UPPER_CASE += 3) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: Localized variable as C-style for loop variable named "ALL_UPPER_CASE" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $ALL_UPPER_CASE = -7; $ALL_UPPER_CASE <= 17; $ALL_UPPER_CASE += 3) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "ALL_UPPER_CASE" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_upper'}}
--- input
sub some_subroutine {
    while (my $ALL_UPPER_CASE = <>) {
        say $ALL_UPPER_CASE;
    }
}

===
--- dscr: Label named "ALL_UPPER_CASE" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':starts_with_upper'}}
--- input
ALL_UPPER_CASE:
while ( foo() ) {
    next ALL_UPPER_CASE;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':starts_with_upper', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':starts_with_upper'}}
--- input
package ________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':starts_with_upper', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "GUARANTEED_TO_PASS::________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':starts_with_upper'}}
--- input
package GUARANTEED_TO_PASS::________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;

===
--- dscr: Subroutine named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':starts_with_upper'}}
--- input
sub ________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':starts_with_upper', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':starts_with_upper'}}
--- input
sub Foo::Bar::________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;

===
--- dscr: Local lexical variable in subroutine named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_upper'}}
--- input
sub some_subroutine {
    my $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_upper', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
--- input
CHECK {
    my $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;
}

===
--- dscr: "our" variable named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
our $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
local $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
--- input
foreach my $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES (@_) {
    say $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;
}

===
--- dscr: State variable as foreach loop variable named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
--- input
foreach state $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES (@_) {
    say $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":starts_with_upper" capitalization scheme.
# --- failures: 0
# --- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
# --- input
# foreach $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES (@_) {
#     say $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;
# }

===
--- dscr: Global variable as foreach loop variable named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
foreach our $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES (@_) {
    say $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
--- input
for (my $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES = -7; $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES <= 17; $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES += 3) {
    say $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;
}

===
--- dscr: State variable as C-style for loop variable named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES = -7; $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES <= 17; $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES += 3) {
    say $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;
}

===
--- dscr: Global variable as C-style for loop variable named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES = -7; $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES <= 17; $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES += 3) {
    say $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;
}

===
--- dscr: Localized variable as C-style for loop variable named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES = -7; $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES <= 17; $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES += 3) {
    say $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_upper'}}
--- input
sub some_subroutine {
    while (my $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES = <>) {
        say $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;
    }
}

===
--- dscr: Label named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':starts_with_upper'}}
--- input
________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES:
while ( foo() ) {
    next ________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':starts_with_upper', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "a11_lower_case_with_digits" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {packages => ':starts_with_upper'}}
--- input
package a11_lower_case_with_digits;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':starts_with_upper', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "GUARANTEED_TO_PASS::a11_lower_case_with_digits" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {packages => ':starts_with_upper'}}
--- input
package GUARANTEED_TO_PASS::a11_lower_case_with_digits;

===
--- dscr: Subroutine named "a11_lower_case_with_digits" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':starts_with_upper'}}
--- input
sub a11_lower_case_with_digits {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':starts_with_upper', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::a11_lower_case_with_digits" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':starts_with_upper'}}
--- input
sub Foo::Bar::a11_lower_case_with_digits;

===
--- dscr: Local lexical variable in subroutine named "a11_lower_case_with_digits" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_upper'}}
--- input
sub some_subroutine {
    my $a11_lower_case_with_digits;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_upper', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "a11_lower_case_with_digits" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
--- input
CHECK {
    my $a11_lower_case_with_digits;
}

===
--- dscr: "our" variable named "a11_lower_case_with_digits" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
our $a11_lower_case_with_digits;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "a11_lower_case_with_digits" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
local $a11_lower_case_with_digits;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "a11_lower_case_with_digits" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
--- input
foreach my $a11_lower_case_with_digits (@_) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: State variable as foreach loop variable named "a11_lower_case_with_digits" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
--- input
foreach state $a11_lower_case_with_digits (@_) {
    say $a11_lower_case_with_digits;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "a11_lower_case_with_digits" vs the ":starts_with_upper" capitalization scheme.
# --- failures: 1
# --- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
# --- input
# foreach $a11_lower_case_with_digits (@_) {
#     say $a11_lower_case_with_digits;
# }

===
--- dscr: Global variable as foreach loop variable named "a11_lower_case_with_digits" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
foreach our $a11_lower_case_with_digits (@_) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "a11_lower_case_with_digits" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
--- input
for (my $a11_lower_case_with_digits = -7; $a11_lower_case_with_digits <= 17; $a11_lower_case_with_digits += 3) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: State variable as C-style for loop variable named "a11_lower_case_with_digits" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $a11_lower_case_with_digits = -7; $a11_lower_case_with_digits <= 17; $a11_lower_case_with_digits += 3) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: Global variable as C-style for loop variable named "a11_lower_case_with_digits" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $a11_lower_case_with_digits = -7; $a11_lower_case_with_digits <= 17; $a11_lower_case_with_digits += 3) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: Localized variable as C-style for loop variable named "a11_lower_case_with_digits" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $a11_lower_case_with_digits = -7; $a11_lower_case_with_digits <= 17; $a11_lower_case_with_digits += 3) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "a11_lower_case_with_digits" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_upper'}}
--- input
sub some_subroutine {
    while (my $a11_lower_case_with_digits = <>) {
        say $a11_lower_case_with_digits;
    }
}

===
--- dscr: Label named "a11_lower_case_with_digits" vs the ":starts_with_upper" capitalization scheme.
--- failures: 1
--- params: {capitalization => {labels => ':starts_with_upper'}}
--- input
a11_lower_case_with_digits:
while ( foo() ) {
    next a11_lower_case_with_digits;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':starts_with_upper', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':starts_with_upper'}}
--- input
package A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':starts_with_upper', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "GUARANTEED_TO_PASS::A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':starts_with_upper'}}
--- input
package GUARANTEED_TO_PASS::A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Subroutine named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':starts_with_upper'}}
--- input
sub A11_UPPER_CASE_WITH_DIGITS {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':starts_with_upper', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':starts_with_upper'}}
--- input
sub Foo::Bar::A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Local lexical variable in subroutine named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_upper'}}
--- input
sub some_subroutine {
    my $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_upper', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
--- input
CHECK {
    my $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: "our" variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
our $A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
local $A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
--- input
foreach my $A11_UPPER_CASE_WITH_DIGITS (@_) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: State variable as foreach loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
--- input
foreach state $A11_UPPER_CASE_WITH_DIGITS (@_) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_upper" capitalization scheme.
# --- failures: 0
# --- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
# --- input
# foreach $A11_UPPER_CASE_WITH_DIGITS (@_) {
#     say $A11_UPPER_CASE_WITH_DIGITS;
# }

===
--- dscr: Global variable as foreach loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
foreach our $A11_UPPER_CASE_WITH_DIGITS (@_) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
--- input
for (my $A11_UPPER_CASE_WITH_DIGITS = -7; $A11_UPPER_CASE_WITH_DIGITS <= 17; $A11_UPPER_CASE_WITH_DIGITS += 3) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: State variable as C-style for loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':starts_with_upper'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $A11_UPPER_CASE_WITH_DIGITS = -7; $A11_UPPER_CASE_WITH_DIGITS <= 17; $A11_UPPER_CASE_WITH_DIGITS += 3) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Global variable as C-style for loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $A11_UPPER_CASE_WITH_DIGITS = -7; $A11_UPPER_CASE_WITH_DIGITS <= 17; $A11_UPPER_CASE_WITH_DIGITS += 3) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Localized variable as C-style for loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $A11_UPPER_CASE_WITH_DIGITS = -7; $A11_UPPER_CASE_WITH_DIGITS <= 17; $A11_UPPER_CASE_WITH_DIGITS += 3) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':starts_with_upper'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':starts_with_upper'}}
--- input
sub some_subroutine {
    while (my $A11_UPPER_CASE_WITH_DIGITS = <>) {
        say $A11_UPPER_CASE_WITH_DIGITS;
    }
}

===
--- dscr: Label named "A11_UPPER_CASE_WITH_DIGITS" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':starts_with_upper'}}
--- input
A11_UPPER_CASE_WITH_DIGITS:
while ( foo() ) {
    next A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":starts_with_upper" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':starts_with_upper', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "all_lower_case" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':no_restriction'}}
--- input
package all_lower_case;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':no_restriction', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "guaranteed_to_pass::all_lower_case" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':no_restriction'}}
--- input
package guaranteed_to_pass::all_lower_case;

===
--- dscr: Subroutine named "all_lower_case" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':no_restriction'}}
--- input
sub all_lower_case {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':no_restriction', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::all_lower_case" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':no_restriction'}}
--- input
sub Foo::Bar::all_lower_case;

===
--- dscr: Local lexical variable in subroutine named "all_lower_case" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':no_restriction'}}
--- input
sub some_subroutine {
    my $all_lower_case;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':no_restriction', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "all_lower_case" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
CHECK {
    my $all_lower_case;
}

===
--- dscr: "our" variable named "all_lower_case" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
our $all_lower_case;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "all_lower_case" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
local $all_lower_case;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "all_lower_case" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
foreach my $all_lower_case (@_) {
    say $all_lower_case;
}

===
--- dscr: State variable as foreach loop variable named "all_lower_case" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
foreach state $all_lower_case (@_) {
    say $all_lower_case;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "all_lower_case" vs the ":no_restriction" capitalization scheme.
# --- failures: 0
# --- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
# --- input
# foreach $all_lower_case (@_) {
#     say $all_lower_case;
# }

===
--- dscr: Global variable as foreach loop variable named "all_lower_case" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
foreach our $all_lower_case (@_) {
    say $all_lower_case;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "all_lower_case" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
for (my $all_lower_case = -7; $all_lower_case <= 17; $all_lower_case += 3) {
    say $all_lower_case;
}

===
--- dscr: State variable as C-style for loop variable named "all_lower_case" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $all_lower_case = -7; $all_lower_case <= 17; $all_lower_case += 3) {
    say $all_lower_case;
}

===
--- dscr: Global variable as C-style for loop variable named "all_lower_case" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $all_lower_case = -7; $all_lower_case <= 17; $all_lower_case += 3) {
    say $all_lower_case;
}

===
--- dscr: Localized variable as C-style for loop variable named "all_lower_case" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $all_lower_case = -7; $all_lower_case <= 17; $all_lower_case += 3) {
    say $all_lower_case;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "all_lower_case" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':no_restriction'}}
--- input
sub some_subroutine {
    while (my $all_lower_case = <>) {
        say $all_lower_case;
    }
}

===
--- dscr: Label named "all_lower_case" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':no_restriction'}}
--- input
all_lower_case:
while ( foo() ) {
    next all_lower_case;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':no_restriction', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "ALL_UPPER_CASE" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':no_restriction'}}
--- input
package ALL_UPPER_CASE;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':no_restriction', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "guaranteed_to_pass::ALL_UPPER_CASE" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':no_restriction'}}
--- input
package guaranteed_to_pass::ALL_UPPER_CASE;

===
--- dscr: Subroutine named "ALL_UPPER_CASE" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':no_restriction'}}
--- input
sub ALL_UPPER_CASE {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':no_restriction', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::ALL_UPPER_CASE" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':no_restriction'}}
--- input
sub Foo::Bar::ALL_UPPER_CASE;

===
--- dscr: Local lexical variable in subroutine named "ALL_UPPER_CASE" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':no_restriction'}}
--- input
sub some_subroutine {
    my $ALL_UPPER_CASE;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':no_restriction', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "ALL_UPPER_CASE" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
CHECK {
    my $ALL_UPPER_CASE;
}

===
--- dscr: "our" variable named "ALL_UPPER_CASE" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
our $ALL_UPPER_CASE;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "ALL_UPPER_CASE" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
local $ALL_UPPER_CASE;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "ALL_UPPER_CASE" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
foreach my $ALL_UPPER_CASE (@_) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: State variable as foreach loop variable named "ALL_UPPER_CASE" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
foreach state $ALL_UPPER_CASE (@_) {
    say $ALL_UPPER_CASE;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "ALL_UPPER_CASE" vs the ":no_restriction" capitalization scheme.
# --- failures: 0
# --- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
# --- input
# foreach $ALL_UPPER_CASE (@_) {
#     say $ALL_UPPER_CASE;
# }

===
--- dscr: Global variable as foreach loop variable named "ALL_UPPER_CASE" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
foreach our $ALL_UPPER_CASE (@_) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "ALL_UPPER_CASE" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
for (my $ALL_UPPER_CASE = -7; $ALL_UPPER_CASE <= 17; $ALL_UPPER_CASE += 3) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: State variable as C-style for loop variable named "ALL_UPPER_CASE" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $ALL_UPPER_CASE = -7; $ALL_UPPER_CASE <= 17; $ALL_UPPER_CASE += 3) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: Global variable as C-style for loop variable named "ALL_UPPER_CASE" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $ALL_UPPER_CASE = -7; $ALL_UPPER_CASE <= 17; $ALL_UPPER_CASE += 3) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: Localized variable as C-style for loop variable named "ALL_UPPER_CASE" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $ALL_UPPER_CASE = -7; $ALL_UPPER_CASE <= 17; $ALL_UPPER_CASE += 3) {
    say $ALL_UPPER_CASE;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "ALL_UPPER_CASE" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':no_restriction'}}
--- input
sub some_subroutine {
    while (my $ALL_UPPER_CASE = <>) {
        say $ALL_UPPER_CASE;
    }
}

===
--- dscr: Label named "ALL_UPPER_CASE" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':no_restriction'}}
--- input
ALL_UPPER_CASE:
while ( foo() ) {
    next ALL_UPPER_CASE;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':no_restriction', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "mixedCase" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':no_restriction'}}
--- input
package mixedCase;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':no_restriction', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "guaranteed_to_pass::mixedCase" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':no_restriction'}}
--- input
package guaranteed_to_pass::mixedCase;

===
--- dscr: Subroutine named "mixedCase" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':no_restriction'}}
--- input
sub mixedCase {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':no_restriction', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::mixedCase" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':no_restriction'}}
--- input
sub Foo::Bar::mixedCase;

===
--- dscr: Local lexical variable in subroutine named "mixedCase" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':no_restriction'}}
--- input
sub some_subroutine {
    my $mixedCase;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':no_restriction', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "mixedCase" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
CHECK {
    my $mixedCase;
}

===
--- dscr: "our" variable named "mixedCase" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
our $mixedCase;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "mixedCase" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
local $mixedCase;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "mixedCase" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
foreach my $mixedCase (@_) {
    say $mixedCase;
}

===
--- dscr: State variable as foreach loop variable named "mixedCase" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
foreach state $mixedCase (@_) {
    say $mixedCase;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "mixedCase" vs the ":no_restriction" capitalization scheme.
# --- failures: 0
# --- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
# --- input
# foreach $mixedCase (@_) {
#     say $mixedCase;
# }

===
--- dscr: Global variable as foreach loop variable named "mixedCase" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
foreach our $mixedCase (@_) {
    say $mixedCase;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "mixedCase" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
for (my $mixedCase = -7; $mixedCase <= 17; $mixedCase += 3) {
    say $mixedCase;
}

===
--- dscr: State variable as C-style for loop variable named "mixedCase" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $mixedCase = -7; $mixedCase <= 17; $mixedCase += 3) {
    say $mixedCase;
}

===
--- dscr: Global variable as C-style for loop variable named "mixedCase" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $mixedCase = -7; $mixedCase <= 17; $mixedCase += 3) {
    say $mixedCase;
}

===
--- dscr: Localized variable as C-style for loop variable named "mixedCase" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $mixedCase = -7; $mixedCase <= 17; $mixedCase += 3) {
    say $mixedCase;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "mixedCase" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':no_restriction'}}
--- input
sub some_subroutine {
    while (my $mixedCase = <>) {
        say $mixedCase;
    }
}

===
--- dscr: Label named "mixedCase" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':no_restriction'}}
--- input
mixedCase:
while ( foo() ) {
    next mixedCase;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':no_restriction', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':no_restriction'}}
--- input
package ________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':no_restriction', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "guaranteed_to_pass::________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':no_restriction'}}
--- input
package guaranteed_to_pass::________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;

===
--- dscr: Subroutine named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':no_restriction'}}
--- input
sub ________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':no_restriction', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':no_restriction'}}
--- input
sub Foo::Bar::________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;

===
--- dscr: Local lexical variable in subroutine named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':no_restriction'}}
--- input
sub some_subroutine {
    my $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':no_restriction', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
CHECK {
    my $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;
}

===
--- dscr: "our" variable named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
our $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
local $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
foreach my $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES (@_) {
    say $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;
}

===
--- dscr: State variable as foreach loop variable named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
foreach state $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES (@_) {
    say $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":no_restriction" capitalization scheme.
# --- failures: 0
# --- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
# --- input
# foreach $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES (@_) {
#     say $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;
# }

===
--- dscr: Global variable as foreach loop variable named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
foreach our $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES (@_) {
    say $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
for (my $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES = -7; $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES <= 17; $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES += 3) {
    say $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;
}

===
--- dscr: State variable as C-style for loop variable named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES = -7; $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES <= 17; $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES += 3) {
    say $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;
}

===
--- dscr: Global variable as C-style for loop variable named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES = -7; $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES <= 17; $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES += 3) {
    say $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;
}

===
--- dscr: Localized variable as C-style for loop variable named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES = -7; $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES <= 17; $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES += 3) {
    say $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':no_restriction'}}
--- input
sub some_subroutine {
    while (my $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES = <>) {
        say $________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;
    }
}

===
--- dscr: Label named "________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':no_restriction'}}
--- input
________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES:
while ( foo() ) {
    next ________ALL_UPPER_CASE_WITH_LEADING_UNDERSCORES;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':no_restriction', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "a11_lower_case_with_digits" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':no_restriction'}}
--- input
package a11_lower_case_with_digits;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':no_restriction', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "guaranteed_to_pass::a11_lower_case_with_digits" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':no_restriction'}}
--- input
package guaranteed_to_pass::a11_lower_case_with_digits;

===
--- dscr: Subroutine named "a11_lower_case_with_digits" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':no_restriction'}}
--- input
sub a11_lower_case_with_digits {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':no_restriction', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::a11_lower_case_with_digits" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':no_restriction'}}
--- input
sub Foo::Bar::a11_lower_case_with_digits;

===
--- dscr: Local lexical variable in subroutine named "a11_lower_case_with_digits" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':no_restriction'}}
--- input
sub some_subroutine {
    my $a11_lower_case_with_digits;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':no_restriction', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "a11_lower_case_with_digits" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
CHECK {
    my $a11_lower_case_with_digits;
}

===
--- dscr: "our" variable named "a11_lower_case_with_digits" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
our $a11_lower_case_with_digits;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "a11_lower_case_with_digits" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
local $a11_lower_case_with_digits;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "a11_lower_case_with_digits" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
foreach my $a11_lower_case_with_digits (@_) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: State variable as foreach loop variable named "a11_lower_case_with_digits" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
foreach state $a11_lower_case_with_digits (@_) {
    say $a11_lower_case_with_digits;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "a11_lower_case_with_digits" vs the ":no_restriction" capitalization scheme.
# --- failures: 0
# --- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
# --- input
# foreach $a11_lower_case_with_digits (@_) {
#     say $a11_lower_case_with_digits;
# }

===
--- dscr: Global variable as foreach loop variable named "a11_lower_case_with_digits" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
foreach our $a11_lower_case_with_digits (@_) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "a11_lower_case_with_digits" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
for (my $a11_lower_case_with_digits = -7; $a11_lower_case_with_digits <= 17; $a11_lower_case_with_digits += 3) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: State variable as C-style for loop variable named "a11_lower_case_with_digits" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $a11_lower_case_with_digits = -7; $a11_lower_case_with_digits <= 17; $a11_lower_case_with_digits += 3) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: Global variable as C-style for loop variable named "a11_lower_case_with_digits" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $a11_lower_case_with_digits = -7; $a11_lower_case_with_digits <= 17; $a11_lower_case_with_digits += 3) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: Localized variable as C-style for loop variable named "a11_lower_case_with_digits" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $a11_lower_case_with_digits = -7; $a11_lower_case_with_digits <= 17; $a11_lower_case_with_digits += 3) {
    say $a11_lower_case_with_digits;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "a11_lower_case_with_digits" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':no_restriction'}}
--- input
sub some_subroutine {
    while (my $a11_lower_case_with_digits = <>) {
        say $a11_lower_case_with_digits;
    }
}

===
--- dscr: Label named "a11_lower_case_with_digits" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':no_restriction'}}
--- input
a11_lower_case_with_digits:
while ( foo() ) {
    next a11_lower_case_with_digits;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':no_restriction', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "A11_UPPER_CASE_WITH_DIGITS" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':no_restriction'}}
--- input
package A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':no_restriction', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "guaranteed_to_pass::A11_UPPER_CASE_WITH_DIGITS" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => ':no_restriction'}}
--- input
package guaranteed_to_pass::A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Subroutine named "A11_UPPER_CASE_WITH_DIGITS" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':no_restriction'}}
--- input
sub A11_UPPER_CASE_WITH_DIGITS {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':no_restriction', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::A11_UPPER_CASE_WITH_DIGITS" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':no_restriction'}}
--- input
sub Foo::Bar::A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Local lexical variable in subroutine named "A11_UPPER_CASE_WITH_DIGITS" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':no_restriction'}}
--- input
sub some_subroutine {
    my $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':no_restriction', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "A11_UPPER_CASE_WITH_DIGITS" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
CHECK {
    my $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: "our" variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
our $A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
local $A11_UPPER_CASE_WITH_DIGITS;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
foreach my $A11_UPPER_CASE_WITH_DIGITS (@_) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: State variable as foreach loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
foreach state $A11_UPPER_CASE_WITH_DIGITS (@_) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":no_restriction" capitalization scheme.
# --- failures: 0
# --- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
# --- input
# foreach $A11_UPPER_CASE_WITH_DIGITS (@_) {
#     say $A11_UPPER_CASE_WITH_DIGITS;
# }

===
--- dscr: Global variable as foreach loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
foreach our $A11_UPPER_CASE_WITH_DIGITS (@_) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
for (my $A11_UPPER_CASE_WITH_DIGITS = -7; $A11_UPPER_CASE_WITH_DIGITS <= 17; $A11_UPPER_CASE_WITH_DIGITS += 3) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: State variable as C-style for loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => ':no_restriction'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $A11_UPPER_CASE_WITH_DIGITS = -7; $A11_UPPER_CASE_WITH_DIGITS <= 17; $A11_UPPER_CASE_WITH_DIGITS += 3) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Global variable as C-style for loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $A11_UPPER_CASE_WITH_DIGITS = -7; $A11_UPPER_CASE_WITH_DIGITS <= 17; $A11_UPPER_CASE_WITH_DIGITS += 3) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Localized variable as C-style for loop variable named "A11_UPPER_CASE_WITH_DIGITS" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $A11_UPPER_CASE_WITH_DIGITS = -7; $A11_UPPER_CASE_WITH_DIGITS <= 17; $A11_UPPER_CASE_WITH_DIGITS += 3) {
    say $A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => ':no_restriction'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "A11_UPPER_CASE_WITH_DIGITS" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => ':no_restriction'}}
--- input
sub some_subroutine {
    while (my $A11_UPPER_CASE_WITH_DIGITS = <>) {
        say $A11_UPPER_CASE_WITH_DIGITS;
    }
}

===
--- dscr: Label named "A11_UPPER_CASE_WITH_DIGITS" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':no_restriction'}}
--- input
A11_UPPER_CASE_WITH_DIGITS:
while ( foo() ) {
    next A11_UPPER_CASE_WITH_DIGITS;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the ":no_restriction" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => ':no_restriction', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "foobar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => 'foo.*bar'}}
--- input
package foobar;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => 'foo.*bar', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "foo_guaranteed_to_pass_bar::foobar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => 'foo.*bar'}}
--- input
package foo_guaranteed_to_pass_bar::foobar;

===
--- dscr: Subroutine named "foobar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => 'foo.*bar'}}
--- input
sub foobar {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => 'foo.*bar', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::foobar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => 'foo.*bar'}}
--- input
sub Foo::Bar::foobar;

===
--- dscr: Local lexical variable in subroutine named "foobar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => 'foo.*bar'}}
--- input
sub some_subroutine {
    my $foobar;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => 'foo.*bar', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "foobar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => 'foo.*bar'}}
--- input
CHECK {
    my $foobar;
}

===
--- dscr: "our" variable named "foobar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => 'foo.*bar'}}
--- input
our $foobar;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => 'foo.*bar', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "foobar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => 'foo.*bar'}}
--- input
local $foobar;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => 'foo.*bar', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "foobar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => 'foo.*bar'}}
--- input
foreach my $foobar (@_) {
    say $foobar;
}

===
--- dscr: State variable as foreach loop variable named "foobar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => 'foo.*bar'}}
--- input
foreach state $foobar (@_) {
    say $foobar;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "foobar" vs the "foo.*bar" capitalization scheme.
# --- failures: 0
# --- params: {capitalization => {local_lexical_variables => 'foo.*bar'}}
# --- input
# foreach $foobar (@_) {
#     say $foobar;
# }

===
--- dscr: Global variable as foreach loop variable named "foobar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => 'foo.*bar'}}
--- input
foreach our $foobar (@_) {
    say $foobar;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "foobar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => 'foo.*bar'}}
--- input
for (my $foobar = -7; $foobar <= 17; $foobar += 3) {
    say $foobar;
}

===
--- dscr: State variable as C-style for loop variable named "foobar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => 'foo.*bar'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $foobar = -7; $foobar <= 17; $foobar += 3) {
    say $foobar;
}

===
--- dscr: Global variable as C-style for loop variable named "foobar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => 'foo.*bar'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $foobar = -7; $foobar <= 17; $foobar += 3) {
    say $foobar;
}

===
--- dscr: Localized variable as C-style for loop variable named "foobar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => 'foo.*bar'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $foobar = -7; $foobar <= 17; $foobar += 3) {
    say $foobar;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => 'foo.*bar'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => 'foo.*bar'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "foobar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => 'foo.*bar'}}
--- input
sub some_subroutine {
    while (my $foobar = <>) {
        say $foobar;
    }
}

===
--- dscr: Label named "foobar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => 'foo.*bar'}}
--- input
foobar:
while ( foo() ) {
    next foobar;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => 'foo.*bar', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "fooXYZZYbar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => 'foo.*bar'}}
--- input
package fooXYZZYbar;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => 'foo.*bar', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "foo_guaranteed_to_pass_bar::fooXYZZYbar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => 'foo.*bar'}}
--- input
package foo_guaranteed_to_pass_bar::fooXYZZYbar;

===
--- dscr: Subroutine named "fooXYZZYbar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => 'foo.*bar'}}
--- input
sub fooXYZZYbar {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => 'foo.*bar', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::fooXYZZYbar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => 'foo.*bar'}}
--- input
sub Foo::Bar::fooXYZZYbar;

===
--- dscr: Local lexical variable in subroutine named "fooXYZZYbar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => 'foo.*bar'}}
--- input
sub some_subroutine {
    my $fooXYZZYbar;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => 'foo.*bar', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "fooXYZZYbar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => 'foo.*bar'}}
--- input
CHECK {
    my $fooXYZZYbar;
}

===
--- dscr: "our" variable named "fooXYZZYbar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => 'foo.*bar'}}
--- input
our $fooXYZZYbar;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => 'foo.*bar', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "fooXYZZYbar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => 'foo.*bar'}}
--- input
local $fooXYZZYbar;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => 'foo.*bar', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "fooXYZZYbar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => 'foo.*bar'}}
--- input
foreach my $fooXYZZYbar (@_) {
    say $fooXYZZYbar;
}

===
--- dscr: State variable as foreach loop variable named "fooXYZZYbar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => 'foo.*bar'}}
--- input
foreach state $fooXYZZYbar (@_) {
    say $fooXYZZYbar;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "fooXYZZYbar" vs the "foo.*bar" capitalization scheme.
# --- failures: 0
# --- params: {capitalization => {local_lexical_variables => 'foo.*bar'}}
# --- input
# foreach $fooXYZZYbar (@_) {
#     say $fooXYZZYbar;
# }

===
--- dscr: Global variable as foreach loop variable named "fooXYZZYbar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => 'foo.*bar'}}
--- input
foreach our $fooXYZZYbar (@_) {
    say $fooXYZZYbar;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "fooXYZZYbar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => 'foo.*bar'}}
--- input
for (my $fooXYZZYbar = -7; $fooXYZZYbar <= 17; $fooXYZZYbar += 3) {
    say $fooXYZZYbar;
}

===
--- dscr: State variable as C-style for loop variable named "fooXYZZYbar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {local_lexical_variables => 'foo.*bar'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $fooXYZZYbar = -7; $fooXYZZYbar <= 17; $fooXYZZYbar += 3) {
    say $fooXYZZYbar;
}

===
--- dscr: Global variable as C-style for loop variable named "fooXYZZYbar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => 'foo.*bar'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $fooXYZZYbar = -7; $fooXYZZYbar <= 17; $fooXYZZYbar += 3) {
    say $fooXYZZYbar;
}

===
--- dscr: Localized variable as C-style for loop variable named "fooXYZZYbar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => 'foo.*bar'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $fooXYZZYbar = -7; $fooXYZZYbar <= 17; $fooXYZZYbar += 3) {
    say $fooXYZZYbar;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => 'foo.*bar'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => 'foo.*bar'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "fooXYZZYbar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => 'foo.*bar'}}
--- input
sub some_subroutine {
    while (my $fooXYZZYbar = <>) {
        say $fooXYZZYbar;
    }
}

===
--- dscr: Label named "fooXYZZYbar" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => 'foo.*bar'}}
--- input
fooXYZZYbar:
while ( foo() ) {
    next fooXYZZYbar;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => 'foo.*bar', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
===
--- dscr: Package named "xyzzy" vs the "foo.*bar" capitalization scheme.
--- failures: 1
--- params: {capitalization => {packages => 'foo.*bar'}}
--- input
package xyzzy;

===
--- dscr: Exempted package named "bLaHlAhLaH" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {packages => 'foo.*bar', package_exemptions => 'bLa.*LaH'}}
--- input
package bLaHlAhLaH;

===
--- dscr: Package named "foo_guaranteed_to_pass_bar::xyzzy" vs the "foo.*bar" capitalization scheme.
--- failures: 1
--- params: {capitalization => {packages => 'foo.*bar'}}
--- input
package foo_guaranteed_to_pass_bar::xyzzy;

===
--- dscr: Subroutine named "xyzzy" vs the "foo.*bar" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => 'foo.*bar'}}
--- input
sub xyzzy {
    # Blah blah blah
}

===
--- dscr: Exempted subroutine named "bLaHlAhLaH" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => 'foo.*bar', subroutine_exemptions => 'bLa.*LaH'}}
--- input
sub bLaHlAhLaH {
    # Blah blah blah
}

===
--- dscr: Subroutine named "Foo::Bar::xyzzy" vs the "foo.*bar" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => 'foo.*bar'}}
--- input
sub Foo::Bar::xyzzy;

===
--- dscr: Local lexical variable in subroutine named "xyzzy" vs the "foo.*bar" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => 'foo.*bar'}}
--- input
sub some_subroutine {
    my $xyzzy;
}

===
--- dscr: Exempted local lexical variable in subroutine named "bLaHlAhLaH" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => 'foo.*bar', local_lexical_variable_exemptions => 'bLa.*LaH'}}
--- input
sub some_subroutine {
    my $bLaHlAhLaH;
}

===
--- dscr: Local lexical variable in subroutine named "xyzzy" vs the "foo.*bar" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => 'foo.*bar'}}
--- input
CHECK {
    my $xyzzy;
}

===
--- dscr: "our" variable named "xyzzy" vs the "foo.*bar" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => 'foo.*bar'}}
--- input
our $xyzzy;

===
--- dscr: Exempted "our" variable named "bLaHlAhLaH" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => 'foo.*bar', global_variable_exemptions => 'bLa.*LaH'}}
--- input
our $bLaHlAhLaH;

===
--- dscr: "local" variable named "xyzzy" vs the "foo.*bar" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => 'foo.*bar'}}
--- input
local $xyzzy;

===
--- dscr: Exempted "local" variable named "bLaHlAhLaH" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => 'foo.*bar', global_variable_exemptions => 'bLa.*LaH'}}
--- input
local $bLaHlAhLaH;

===
--- dscr: Local lexical variable as foreach loop variable named "xyzzy" vs the "foo.*bar" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => 'foo.*bar'}}
--- input
foreach my $xyzzy (@_) {
    say $xyzzy;
}

===
--- dscr: State variable as foreach loop variable named "xyzzy" vs the "foo.*bar" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => 'foo.*bar'}}
--- input
foreach state $xyzzy (@_) {
    say $xyzzy;
}

# NOTE need it?
# ===
# --- dscr: Implied local lexical variable as foreach loop variable named "xyzzy" vs the "foo.*bar" capitalization scheme.
# --- failures: 1
# --- params: {capitalization => {local_lexical_variables => 'foo.*bar'}}
# --- input
# foreach $xyzzy (@_) {
#     say $xyzzy;
# }

===
--- dscr: Global variable as foreach loop variable named "xyzzy" vs the "foo.*bar" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => 'foo.*bar'}}
--- input
foreach our $xyzzy (@_) {
    say $xyzzy;
}

===
--- dscr: Localized builtin variable
--- failures: 0
--- params:
--- input
local $@;

===
--- dscr: Localized $\
--- failures: 0
--- params:
--- input
# $\ was missing from the built in global exceptions
local $\;

===
--- dscr: Local lexical variable as C-style for loop variable named "xyzzy" vs the "foo.*bar" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => 'foo.*bar'}}
--- input
for (my $xyzzy = -7; $xyzzy <= 17; $xyzzy += 3) {
    say $xyzzy;
}

===
--- dscr: State variable as C-style for loop variable named "xyzzy" vs the "foo.*bar" capitalization scheme.
--- failures: 1
--- params: {capitalization => {local_lexical_variables => 'foo.*bar'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (state $xyzzy = -7; $xyzzy <= 17; $xyzzy += 3) {
    say $xyzzy;
}

===
--- dscr: Global variable as C-style for loop variable named "xyzzy" vs the "foo.*bar" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => 'foo.*bar'}}
--- input
# Declare the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (our $xyzzy = -7; $xyzzy <= 17; $xyzzy += 3) {
    say $xyzzy;
}

===
--- dscr: Localized variable as C-style for loop variable named "xyzzy" vs the "foo.*bar" capitalization scheme.
--- failures: 1
--- params: {capitalization => {global_variables => 'foo.*bar'}}
--- input
# Localize the same variable twice in order to catch the case where the
# variable is the second one in the loop definition.
for (local $xyzzy = -7; $xyzzy <= 17; $xyzzy += 3) {
    say $xyzzy;
}

===
--- dscr: Localized builtin variable as C-style for loop variable vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => 'foo.*bar'}}
--- input
for (local $EVAL_ERROR = -23; $EVAL_ERROR <= 17; $EVAL_ERROR += 3) {
    say $EVAL_ERROR;
}

===
--- dscr: Localized variable in another package as C-style for loop variable vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {global_variables => 'foo.*bar'}}
--- input
for (local $Foo::Baz = -23; $Foo::Baz <= 17; $Foo::Baz += 3) {
    say $Foo::Baz
}

===
--- dscr: Local lexical variable, in I/O assignment in while loop, named "xyzzy" vs the "foo.*bar" capitalization scheme.
--- failures: 1
--- params: {capitalization => {subroutines => ':all_lower', local_lexical_variables => 'foo.*bar'}}
--- input
sub some_subroutine {
    while (my $xyzzy = <>) {
        say $xyzzy;
    }
}

===
--- dscr: Label named "xyzzy" vs the "foo.*bar" capitalization scheme.
--- failures: 1
--- params: {capitalization => {labels => 'foo.*bar'}}
--- input
xyzzy:
while ( foo() ) {
    next xyzzy;
}

===
--- dscr: Exempted label named "bLaHlAhLaH" vs the "foo.*bar" capitalization scheme.
--- failures: 0
--- params: {capitalization => {labels => 'foo.*bar', label_exemptions => 'bLa.*LaH'}}
--- input
bLaHlAhLaH:
while ( foo() ) {
    next bLaHlAhLaH;
}
# NOTE need it?
# ===
# --- dscr: Variable in continue block gets handled as a local lexical and not a scoped lexical.
# --- failures: 1
# --- params: {capitalization => {local_lexical_variables => ':all_upper', scoped_lexical_variables => ':all_lower'}}
# --- input
# while (blah) {
#     blah;
# }
# continue {
#     my $this_should_be_local_and_not_scoped;
# }

===
--- dscr: Builtin variables and variables in other packages are exempt.
--- failures: 0
--- params: {capitalization => {global_variables => ':all_lower'}}
--- input
local $EVAL_ERROR
local @ARGV;
local %INC;
local $Foo::Bar;

===
--- dscr: Test customization example in the Capitalization POD passing.
--- failures: 0
--- params: {capitalization => {global_variables => 'G_(?:(?!_)\w)+', global_variable_exemptions => '.*THINGY.*'}}
--- input
our $G_FooBar;
our $THINGY;
our @otherTHINGY;

===
--- dscr: Test customization example in the Capitalization POD failing.
--- failures: 4
--- params: {capitalization => {global_variables => 'G_(?:(?!_)\w)+', global_variable_exemptions => '.*THINGY.*'}}
--- input
our $FooBar;
our $G_;
our $G_foo_bar;
our @THING;

