/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project2;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.project2.Day;
import net.sourceforge.plantuml.project2.Task;
import net.sourceforge.plantuml.project2.TaskAttribute;
import net.sourceforge.plantuml.project2.TaskContainer;
import net.sourceforge.plantuml.project2.TimeElement;
import net.sourceforge.plantuml.project2.TimeLine;
import net.sourceforge.plantuml.project2.Value;
import net.sourceforge.plantuml.project2.ValueInt;
import net.sourceforge.plantuml.project2.ValueTime;

public class Knowledge {
    private final TaskContainer taskContainer;
    private final TimeLine timeline;
    private final Map<String, Value> variables = new HashMap<String, Value>();

    public Knowledge(TaskContainer taskContainer, TimeLine timeLine) {
        this.taskContainer = taskContainer;
        this.timeline = timeLine;
    }

    public Value evaluate(String string) {
        int n = (string = string.trim()).indexOf(36);
        if (n != -1) {
            return this.evaluate(string.substring(0, n), string.substring(n + 1));
        }
        if (string.matches("\\d+")) {
            return new ValueInt(Integer.parseInt(string));
        }
        if (Day.isValidDesc(string)) {
            Day day = new Day(string);
            return new ValueTime(day);
        }
        if (string.startsWith("^")) {
            string = string.substring(1);
        }
        if (this.variables.containsKey(string)) {
            return this.variables.get(string);
        }
        n = string.indexOf("+");
        if (n != -1) {
            return this.plus(string.substring(0, n), string.substring(n + 1));
        }
        throw new UnsupportedOperationException(string);
    }

    private Value plus(String string, String string2) {
        Value value = this.evaluate(string);
        Value value2 = this.evaluate(string2);
        if (value instanceof ValueInt && value2 instanceof ValueInt) {
            return new ValueInt(((ValueInt)value).getValue() + ((ValueInt)value2).getValue());
        }
        if (value instanceof ValueTime && value2 instanceof ValueInt) {
            int n;
            int n2 = ((ValueInt)value2).getValue();
            TimeElement timeElement = ((ValueTime)value).getValue();
            if (n2 > 0) {
                for (n = 0; n < n2; ++n) {
                    timeElement = this.timeline.next(timeElement);
                }
            }
            if (n2 < 0) {
                for (n = 0; n < -n2; ++n) {
                    timeElement = this.timeline.previous(timeElement);
                }
            }
            return new ValueTime(timeElement);
        }
        throw new UnsupportedOperationException();
    }

    private Value evaluate(String string, String string2) {
        Task task = this.taskContainer.getTask(string);
        TaskAttribute taskAttribute = TaskAttribute.fromString(string2);
        if (taskAttribute == TaskAttribute.COMPLETED) {
            return new ValueTime(task.getCompleted());
        }
        throw new UnsupportedOperationException();
    }

    public void set(String string, Value value) {
        this.variables.put(string, value);
    }
}

