# Generated by default/object.tt
package Paws::CodeDeploy::CloudFormationTarget;
  use Moose;
  has DeploymentId => (is => 'ro', isa => 'Str', request_name => 'deploymentId', traits => ['NameInRequest']);
  has LastUpdatedAt => (is => 'ro', isa => 'Str', request_name => 'lastUpdatedAt', traits => ['NameInRequest']);
  has LifecycleEvents => (is => 'ro', isa => 'ArrayRef[Paws::CodeDeploy::LifecycleEvent]', request_name => 'lifecycleEvents', traits => ['NameInRequest']);
  has ResourceType => (is => 'ro', isa => 'Str', request_name => 'resourceType', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest']);
  has TargetId => (is => 'ro', isa => 'Str', request_name => 'targetId', traits => ['NameInRequest']);
  has TargetVersionWeight => (is => 'ro', isa => 'Num', request_name => 'targetVersionWeight', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeDeploy::CloudFormationTarget

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeDeploy::CloudFormationTarget object:

  $service_obj->Method(Att1 => { DeploymentId => $value, ..., TargetVersionWeight => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeDeploy::CloudFormationTarget object:

  $result = $service_obj->Method(...);
  $result->Att1->DeploymentId

=head1 DESCRIPTION

Information about the target to be updated by an AWS CloudFormation
blue/green deployment. This target type is used for all deployments
initiated by a CloudFormation stack update.

=head1 ATTRIBUTES


=head2 DeploymentId => Str

The unique ID of an AWS CloudFormation blue/green deployment.


=head2 LastUpdatedAt => Str

The date and time when the target application was updated by an AWS
CloudFormation blue/green deployment.


=head2 LifecycleEvents => ArrayRef[L<Paws::CodeDeploy::LifecycleEvent>]

The lifecycle events of the AWS CloudFormation blue/green deployment to
this target application.


=head2 ResourceType => Str

The resource type for the AWS CloudFormation blue/green deployment.


=head2 Status => Str

The status of an AWS CloudFormation blue/green deployment's target
application.


=head2 TargetId => Str

The unique ID of a deployment target that has a type of
C<CloudFormationTarget>.


=head2 TargetVersionWeight => Num

The percentage of production traffic that the target version of an AWS
CloudFormation blue/green deployment receives.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeDeploy>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

