/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;

public class InputStreamReader
extends Reader {
    private ByteToCharConverter btc;
    private InputStream in;
    private static final int defaultByteBufferSize = 8192;
    private byte[] bb;
    private int nBytes;
    private int nextByte;

    public InputStreamReader(InputStream inputStream) {
        this(inputStream, ByteToCharConverter.getDefault());
    }

    public InputStreamReader(InputStream inputStream, String string) throws UnsupportedEncodingException {
        this(inputStream, ByteToCharConverter.getConverter(string));
    }

    private InputStreamReader(InputStream inputStream, ByteToCharConverter byteToCharConverter) {
        super(inputStream);
        this.in = inputStream;
        this.btc = byteToCharConverter;
        this.bb = new byte[8192];
    }

    public String getEncoding() {
        Object object = this.lock;
        synchronized (object) {
            if (this.btc != null) {
                String string = this.btc.getCharacterEncoding();
                Object var3_4 = null;
                return string;
            }
            String string = null;
            Object var3_5 = null;
            return string;
        }
    }

    private void malfunction() {
        throw new InternalError("Converter malfunction (" + this.btc.getCharacterEncoding() + ") -- please submit a bug report via " + System.getProperty("java.vendor.url.bug"));
    }

    private int convertInto(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (this.nextByte < this.nBytes) {
            try {
                n3 = this.btc.convert(this.bb, this.nextByte, this.nBytes, cArray, n, n2);
                this.nextByte = this.nBytes;
                if (this.btc.nextByteIndex() != this.nextByte) {
                    this.malfunction();
                }
            }
            catch (ConversionBufferFullException conversionBufferFullException) {
                this.nextByte = this.btc.nextByteIndex();
                n3 = this.btc.nextCharIndex() - n;
            }
        }
        return n3;
    }

    private int flushInto(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        try {
            n3 = this.btc.flush(cArray, n, n2);
        }
        catch (ConversionBufferFullException conversionBufferFullException) {
            n3 = this.btc.nextCharIndex() - n;
        }
        return n3;
    }

    private int fill(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (this.nextByte < this.nBytes) {
            n3 = this.convertInto(cArray, n, n2);
        }
        while (n + n3 < n2) {
            if (this.nBytes != -1) {
                if (n3 > 0 && !this.inReady()) break;
                this.nBytes = this.in.read(this.bb);
            }
            if (this.nBytes == -1) {
                if ((n3 += this.flushInto(cArray, n + n3, n2)) != 0) break;
                return -1;
            }
            this.nextByte = 0;
            n3 += this.convertInto(cArray, n + n3, n2);
        }
        return n3;
    }

    private boolean inReady() {
        try {
            return this.in.available() > 0;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    public int read() throws IOException {
        char[] cArray = new char[1];
        if (this.read(cArray, 0, 1) == -1) {
            return -1;
        }
        return cArray[0];
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                throw new IOException("Stream closed");
            }
            int n3 = this.fill(cArray, n, n + n2);
            Object var6_6 = null;
            return n3;
        }
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                throw new IOException("Stream closed");
            }
            boolean bl = this.nextByte < this.nBytes || this.inReady();
            Object var3_3 = null;
            return bl;
        }
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                Object var2_2 = null;
                return;
            }
            this.in.close();
            this.in = null;
            this.bb = null;
            this.btc = null;
            return;
        }
    }
}

