/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import sun.rmi.server.RMIClassLoader;
import sun.rmi.server.RemoteProxy;
import sun.rmi.transport.Utils;

public class MarshalOutputStream
extends ObjectOutputStream {
    private static String codebase;

    public MarshalOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
        this.enableReplaceObject(true);
    }

    protected Object replaceObject(Object object) throws IOException {
        if (object instanceof Remote) {
            object = RemoteProxy.getProxy((Remote)object);
        }
        return object;
    }

    protected void annotateClass(Class clazz) throws IOException {
        String string = null;
        String string2 = clazz.getName();
        if (!string2.startsWith("java.")) {
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader != null) {
                if (classLoader instanceof RMIClassLoader) {
                    RMIClassLoader rMIClassLoader = (RMIClassLoader)classLoader;
                    string = rMIClassLoader.getCodeBase().toExternalForm();
                } else {
                    Object object;
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null && (object = securityManager.getSecurityContext()) != null && object instanceof URL) {
                        string = ((URL)object).toExternalForm();
                    }
                }
            }
            if (string == null) {
                string = codebase;
            }
        }
        this.writeObject(string);
    }

    static {
        block2: {
            codebase = Utils.getProperty("java.rmi.server.codebase");
            if (codebase == null) break block2;
            try {
                new URL(codebase);
            }
            catch (MalformedURLException malformedURLException) {
                codebase = null;
            }
        }
    }
}

