using System;
using System.Collections.Generic;
using System.Text;
using CoreSync;
using System.Collections;
using System.Xml.Serialization;

namespace SmartSync
{
    public enum ComparisonResult
    {
        PPC_CHANGED,
        PC_CHANGED,
        NO_CHANGE,
        BOTH_CHANGED,
        UNKNOWN
    }

    public class ComparisonItem
    {
        [XmlAttribute("customID")]
        public String pvt_sCustomID;
        [XmlAttribute("hash")]
        public String pvt_sKnownHash;

        public ComparisonItem()
        {
            pvt_sCustomID = "";
            pvt_sKnownHash = "";
        }

        public ComparisonItem(String sCustomID, String sKnownHash)
        {
            pvt_sCustomID = sCustomID;
            pvt_sKnownHash = sKnownHash;
        }

        [XmlIgnore()]
        public String CustomID
        {
            get
            {
                return pvt_sCustomID;
            }
        }

        [XmlIgnore()]
        public String Hash
        {
            get
            {
                return pvt_sKnownHash;
            }
            set
            {
                pvt_sKnownHash = value;
            }
        }

        public ComparisonResult compare(Contact ppc, Contact pc)
        {
            String known = pvt_sKnownHash;
            String ppc_hash = CoreSync.Utils.GetMD5(ppc);
            String pc_hash = CoreSync.Utils.GetMD5(pc);
            if (known == ppc_hash && known == pc_hash)
                return ComparisonResult.NO_CHANGE;
            if (known == ppc_hash && known != pc_hash)
                return ComparisonResult.PC_CHANGED;
            if (known != ppc_hash && known == pc_hash)
                return ComparisonResult.PPC_CHANGED;
            if (known != ppc_hash && known != pc_hash)
                return ComparisonResult.BOTH_CHANGED;
            return ComparisonResult.UNKNOWN;
        }
    }

    [XmlRoot("ComparisonTable")]
    public class ComparisonHelper
    {
        [XmlArray("Items")]
        [XmlArrayItem("item", typeof(ComparisonItem))]
        public ArrayList hashes = new ArrayList();

        public ComparisonHelper()
        {
        }

        [XmlIgnore()]
        public ArrayList Items
        {
            get
            {
                return this.hashes;
            }
            set
            {
                this.hashes = value;
            }
        }

        public void Add(ComparisonItem obj)
        {
            hashes.Add(obj);
        }

        private ComparisonItem GetComparer(String customID)
        {
            for (int i = 0; i < hashes.Count; i++)
            {
                ComparisonItem retval = (ComparisonItem)hashes[i];
                if (retval.CustomID == customID)
                    return retval;
            }
            return null;
        }

        private String getCTName()
        {
            String retval = AppSettings.getAppDir();
            retval += "\\HashesDB.xml";
            return retval;
        }

        public bool LoadComparisonTable()
        {
            try
            {
                System.IO.StreamReader input = new System.IO.StreamReader(getCTName());
                XmlSerializer ser = new XmlSerializer(typeof(ComparisonHelper));
                ComparisonHelper retval = (ComparisonHelper)ser.Deserialize(input);
                if (retval != null)
                {
                    for (int i = 0; i < retval.Items.Count; i++)
                    {
                        this.Add((ComparisonItem)retval.Items[i]);
                    }
                }
                input.Close();
                return true;
            }
            catch (Exception ex)
            {
                return false;
            }
        }

        public bool SaveComparisonTable()
        {
            try
            {
                StringBuilder sb = new StringBuilder();
                System.IO.StringWriter output = new System.IO.StringWriter(sb);
                XmlSerializer ser = new XmlSerializer(typeof(ComparisonHelper));
                ser.Serialize(output, this);
                String xmlData = sb.ToString();
                System.IO.StreamWriter writer = new System.IO.StreamWriter(getCTName());
                writer.Write(xmlData);
                writer.Flush();
                writer.Close();
                return true;
            }
            catch (Exception ex)
            {
                return false;
            }
        }

        public ComparisonResult CompareContacts(Contact PPC, Contact PC)
        {
            if (PPC.customID != PC.customID)
                return ComparisonResult.UNKNOWN;
            ComparisonItem comparer = GetComparer(PPC.customID);
            if (comparer != null)
                return comparer.compare(PPC, PC);
            else
                return ComparisonResult.UNKNOWN;
        }

        public bool isCustomIDKnown(String customID)
        {
            for (int i = 0; i < hashes.Count; i++)
            {
                ComparisonItem item = (ComparisonItem)hashes[i];
                if (item.CustomID == customID)
                    return true;
            }
            return false;
        }

        public void populate(Contacts oSource)
        {
            for (int i = 0; i < oSource.getCount(); i++)
            {
                Contact ct = oSource.get(i);
                if(isCustomIDKnown(ct.customID)==false)
                    Add(new ComparisonItem(ct.customID, CoreSync.Utils.GetMD5(ct)));
            }
        }
    }
}
