/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.dom;

import org.mozilla.dom.NodeFactory;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMHTMLFrameElement;
import org.mozilla.interfaces.nsIDOMHTMLIFrameElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;

public class SharedUtils {
    public static boolean isFrameNode(nsIDOMNode moz) {
        if (moz == null) {
            return false;
        }
        String name = moz.getNodeName();
        return name.equalsIgnoreCase("frame") || name.equalsIgnoreCase("iframe");
    }

    public static boolean isHTMLNode(nsIDOMNode moz) {
        if (moz == null) {
            return false;
        }
        String name = moz.getNodeName();
        return name.equalsIgnoreCase("html");
    }

    public static Element frameNodeToDocumentRoot(nsIDOMNode moz) {
        String name = moz.getNodeName();
        if (name.equalsIgnoreCase("frame")) {
            nsIDOMHTMLFrameElement nsfn = (nsIDOMHTMLFrameElement)moz.queryInterface("{a6cf90b9-15b3-11d2-932e-00805f8add32}");
            nsIDOMDocument nsdoc = nsfn.getContentDocument();
            if (nsdoc == null) {
                return null;
            }
            nsIDOMElement nsroot = nsdoc.getDocumentElement();
            return (Element)NodeFactory.getNodeInstance((nsIDOMNode)nsroot);
        }
        if (name.equalsIgnoreCase("iframe")) {
            nsIDOMHTMLIFrameElement nsfn = (nsIDOMHTMLIFrameElement)moz.queryInterface("{a6cf90ba-15b3-11d2-932e-00805f8add32}");
            nsIDOMDocument nsdoc = nsfn.getContentDocument();
            if (nsdoc == null) {
                return null;
            }
            nsIDOMElement nsroot = nsdoc.getDocumentElement();
            return (Element)NodeFactory.getNodeInstance((nsIDOMNode)nsroot);
        }
        return null;
    }
}

