

/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozdom4java
 *
 * The Initial Developer of the Original Code is
 * Peter Szinek, Lixto Software GmbH, http://www.lixto.com.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Peter Szinek (peter@rubyrailways.com)
 *  Michal Ceresna (michal.ceresna@gmail.com)
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


package org.mozilla.dom;

//Java imports
import java.util.*;

//org.w3c imports
import org.w3c.dom.*;
import org.w3c.dom.html2.*;
import org.w3c.dom.html.*;
import org.w3c.dom.events.*;
import org.w3c.dom.traversal.*;
import org.w3c.dom.ranges.*;
import org.w3c.dom.views.*;

//mozdom4java imports
import org.mozilla.dom.*;
import org.mozilla.dom.views.*;

//XPCOM import
import org.mozilla.xpcom.*;


public class DocumentImpl extends NodeImpl implements org.w3c.dom.Document
{
    protected DocumentImpl(nsIDOMDocument mozInst)
    {
        super( mozInst );
    }

    public static DocumentImpl getDOMInstance(nsIDOMDocument mozInst)
    {
        DocumentImpl node = (DocumentImpl) instances.get(mozInst);
        return node == null ? new DocumentImpl(mozInst) : node;
    }
    
    public nsIDOMDocument getInstance()
    {
        //This was already queryinterfaced, so safe to cast
        return (nsIDOMDocument) moz;
    }
    
    public Attr createAttribute(String name)
    {
        nsIDOMAttr result = getInstance().createAttribute(name);
        return (Attr) NodeFactory.getNodeInstance(result);
    }
    
    public Node adoptNode(Node source)
    {
        nsIDOMNode mozSource = ((NodeImpl) source).getInstance();

        nsIDOM3Document DOM3MozObject = (nsIDOM3Document) getInstance().queryInterface(nsIDOM3Document.NS_IDOM3DOCUMENT_IID);
        nsIDOMNode result = DOM3MozObject.adoptNode(mozSource);
        return (Node) NodeFactory.getNodeInstance(result);

    }
    
    public Element createElement(String tagName)
    {
        nsIDOMElement result = getInstance().createElement(tagName);
        return (Element) NodeFactory.getNodeInstance(result);
    }
    
    public ProcessingInstruction createProcessingInstruction(String target, String data)
    {
        nsIDOMProcessingInstruction result = getInstance().createProcessingInstruction(target, data);
        return (ProcessingInstruction) NodeFactory.getNodeInstance(result);
    }
    
    public DOMConfiguration getDomConfig()
    {

        nsIDOM3Document DOM3MozObject = (nsIDOM3Document) getInstance().queryInterface(nsIDOM3Document.NS_IDOM3DOCUMENT_IID);
        nsIDOMDOMConfiguration result = DOM3MozObject.getDomConfig();
        return new DOMConfigurationImpl(result );

    }
    
    public Comment createComment(String data)
    {
        nsIDOMComment result = getInstance().createComment(data);
        return (Comment) NodeFactory.getNodeInstance(result);
    }
    
    public DocumentType getDoctype()
    {
        nsIDOMDocumentType result = getInstance().getDoctype();
        return (DocumentType) NodeFactory.getNodeInstance(result);
    }
    
    public void normalizeDocument()
    {

        nsIDOM3Document DOM3MozObject = (nsIDOM3Document) getInstance().queryInterface(nsIDOM3Document.NS_IDOM3DOCUMENT_IID);
        DOM3MozObject.normalizeDocument();

    }
    
    public String getInputEncoding()
    {

        nsIDOM3Document DOM3MozObject = (nsIDOM3Document) getInstance().queryInterface(nsIDOM3Document.NS_IDOM3DOCUMENT_IID);
        String result = DOM3MozObject.getInputEncoding();
            return result;

    }
    
    public boolean getXmlStandalone()
    {

        nsIDOM3Document DOM3MozObject = (nsIDOM3Document) getInstance().queryInterface(nsIDOM3Document.NS_IDOM3DOCUMENT_IID);
        boolean result = DOM3MozObject.getXmlStandalone();
            return result;

    }
    
    public void setXmlVersion(String xmlVersion)
    {

        nsIDOM3Document DOM3MozObject = (nsIDOM3Document) getInstance().queryInterface(nsIDOM3Document.NS_IDOM3DOCUMENT_IID);
        DOM3MozObject.setXmlVersion(xmlVersion);

    }
    
    public Node importNode(Node importedNode, boolean deep)
    {
        nsIDOMNode mozImportednode = ((NodeImpl) importedNode).getInstance();
        nsIDOMNode result = getInstance().importNode(mozImportednode, deep);
        return (Node) NodeFactory.getNodeInstance(result);
    }
    
    public void setDocumentURI(String documentURI)
    {

        nsIDOM3Document DOM3MozObject = (nsIDOM3Document) getInstance().queryInterface(nsIDOM3Document.NS_IDOM3DOCUMENT_IID);
        DOM3MozObject.setDocumentURI(documentURI);

    }
    
    public CDATASection createCDATASection(String data)
    {
        nsIDOMCDATASection result = getInstance().createCDATASection(data);
        return (CDATASection) NodeFactory.getNodeInstance(result);
    }
    
    public String getXmlVersion()
    {

        nsIDOM3Document DOM3MozObject = (nsIDOM3Document) getInstance().queryInterface(nsIDOM3Document.NS_IDOM3DOCUMENT_IID);
        String result = DOM3MozObject.getXmlVersion();
            return result;

    }
    
    public NodeList getElementsByTagName(String tagname)
    {
        nsIDOMNodeList result = getInstance().getElementsByTagName(tagname);
        return new NodeListImpl(result);
    }
    
    public Element createElementNS(String namespaceURI, String qualifiedName)
    {
        nsIDOMElement result = getInstance().createElementNS(namespaceURI, qualifiedName);
        return (Element) NodeFactory.getNodeInstance(result);
    }
    
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName)
    {
        nsIDOMNodeList result = getInstance().getElementsByTagNameNS(namespaceURI, localName);
        return new NodeListImpl(result);
    }
    
    public Node renameNode(Node n, String namespaceURI, String qualifiedName)
    {
        nsIDOMNode mozN = ((NodeImpl) n).getInstance();

        nsIDOM3Document DOM3MozObject = (nsIDOM3Document) getInstance().queryInterface(nsIDOM3Document.NS_IDOM3DOCUMENT_IID);
        nsIDOMNode result = DOM3MozObject.renameNode(mozN, namespaceURI, qualifiedName);
        return (Node) NodeFactory.getNodeInstance(result);

    }
    
    public EntityReference createEntityReference(String name)
    {
        nsIDOMEntityReference result = getInstance().createEntityReference(name);
        return (EntityReference) NodeFactory.getNodeInstance(result);
    }
    
    public void setStrictErrorChecking(boolean strictErrorChecking)
    {

        nsIDOM3Document DOM3MozObject = (nsIDOM3Document) getInstance().queryInterface(nsIDOM3Document.NS_IDOM3DOCUMENT_IID);
        DOM3MozObject.setStrictErrorChecking(strictErrorChecking);

    }
    
    public DocumentFragment createDocumentFragment()
    {
        nsIDOMDocumentFragment result = getInstance().createDocumentFragment();
        return (DocumentFragment) NodeFactory.getNodeInstance(result);
    }
    
    public DOMImplementation getImplementation()
    {
        nsIDOMDOMImplementation result = getInstance().getImplementation();
        return new DOMImplementationImpl(result);
    }
    
    public boolean getStrictErrorChecking()
    {

        nsIDOM3Document DOM3MozObject = (nsIDOM3Document) getInstance().queryInterface(nsIDOM3Document.NS_IDOM3DOCUMENT_IID);
        boolean result = DOM3MozObject.getStrictErrorChecking();
            return result;

    }
    
    public void setXmlStandalone(boolean xmlStandalone)
    {

        nsIDOM3Document DOM3MozObject = (nsIDOM3Document) getInstance().queryInterface(nsIDOM3Document.NS_IDOM3DOCUMENT_IID);
        DOM3MozObject.setXmlStandalone(xmlStandalone);

    }
    
    public String getXmlEncoding()
    {

        nsIDOM3Document DOM3MozObject = (nsIDOM3Document) getInstance().queryInterface(nsIDOM3Document.NS_IDOM3DOCUMENT_IID);
        String result = DOM3MozObject.getXmlEncoding();
            return result;

    }
    
    public Element getDocumentElement()
    {
        nsIDOMElement result = getInstance().getDocumentElement();
        return (Element) NodeFactory.getNodeInstance(result);
    }
    
    public Element getElementById(String elementId)
    {
        nsIDOMElement result = getInstance().getElementById(elementId);
        return (Element) NodeFactory.getNodeInstance(result);
    }
    
    public String getDocumentURI()
    {

        nsIDOM3Document DOM3MozObject = (nsIDOM3Document) getInstance().queryInterface(nsIDOM3Document.NS_IDOM3DOCUMENT_IID);
        String result = DOM3MozObject.getDocumentURI();
            return result;

    }
    
    public Attr createAttributeNS(String namespaceURI, String qualifiedName)
    {
        nsIDOMAttr result = getInstance().createAttributeNS(namespaceURI, qualifiedName);
        return (Attr) NodeFactory.getNodeInstance(result);
    }
    
    public Text createTextNode(String data)
    {
        nsIDOMText result = getInstance().createTextNode(data);
        return (Text) NodeFactory.getNodeInstance(result);
    }
    
}
