/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.DefaultSecurity;
import com.sun.media.sound.IESecurity;
import com.sun.media.sound.JDK12Security;
import com.sun.media.sound.JSSecurity;
import com.sun.media.sound.NetscapeSecurity;
import com.sun.media.sound.Printer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class JSSecurityManager {
    private static JSSecurity security;
    private static SecurityManager securityManager;
    static /* synthetic */ Class class$java$lang$String;

    JSSecurityManager() {
    }

    public static JSSecurity getJSSecurity() throws SecurityException {
        return security;
    }

    public static void checkRecord() throws SecurityException {
        if (security == null) {
            return;
        }
        try {
            Object[] objectArray;
            if (Printer.debug) {
                Printer.debug("JSSecurity.checkRecord(): looking up JMF registry class, using reflection");
            }
            Class clazz = Class.forName("com.sun.media.util.Registry");
            Method method = clazz.getMethod("get", new Class[]{class$java$lang$String == null ? (class$java$lang$String = JSSecurityManager.class$("java.lang.String")) : class$java$lang$String});
            Object object = method.invoke(clazz, objectArray = new Object[]{"secure.allowCaptureFromApplets"});
            if (object == null || !(object instanceof Boolean) || !((Boolean)object).booleanValue()) {
                if (Printer.debug) {
                    Printer.debug("    record permission denied by Registry");
                }
                throw new SecurityException("record permission denied");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (Printer.debug) {
                Printer.debug("caught ClassNotFoundException");
            }
            throw new SecurityException("record permission denied");
        }
        catch (InvocationTargetException invocationTargetException) {
            if (Printer.debug) {
                Printer.debug("caught InvocationTargetException");
            }
            throw new SecurityException("record permission denied");
        }
        catch (IllegalAccessException illegalAccessException) {
            if (Printer.debug) {
                Printer.debug("caught IllegalAccessException");
            }
            throw new SecurityException("record permission denied");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (Printer.debug) {
                Printer.debug("caught NoSuchMethodException");
            }
            throw new SecurityException("record permission denied");
        }
    }

    public static boolean isLinkPermissionEnabled() {
        if (security == null) {
            return true;
        }
        return security.isLinkPermissionEnabled();
    }

    public static void loadLibrary(String string) throws UnsatisfiedLinkError {
        try {
            JSSecurity jSSecurity = JSSecurityManager.getJSSecurity();
            if (jSSecurity != null) {
                jSSecurity.loadLibrary(string);
            } else {
                System.loadLibrary(string);
            }
        }
        catch (Throwable throwable) {
            throw new UnsatisfiedLinkError("JSSecurityManager: " + throwable);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        boolean bl;
        boolean bl2;
        boolean bl3;
        block30: {
            security = null;
            securityManager = System.getSecurityManager();
            bl3 = false;
            bl2 = false;
            bl = false;
            try {
                String string;
                String string2 = System.getProperty("java.version");
                if (Printer.debug) {
                    Printer.debug("javaVersion " + string2);
                }
                if (!string2.equals("")) {
                    if (string2.startsWith("1.1")) {
                        if (Printer.debug) {
                            Printer.debug("JDK 1.1.x");
                        }
                        bl2 = true;
                    } else {
                        bl3 = true;
                        if (Printer.debug) {
                            Printer.debug("JDK 1.2 and up");
                        }
                    }
                }
                if ((string = System.getProperty("java.vendor", "Sun").toLowerCase()).indexOf("icrosoft") > 0) {
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                if (!Printer.debug) break block30;
                Printer.debug("Exception caught: " + throwable);
            }
        }
        if (securityManager != null) {
            if (Printer.debug) {
                Printer.debug("securityManager: " + securityManager);
            }
            if (securityManager.toString().indexOf("netscape") != -1) {
                if (Printer.debug) {
                    Printer.debug("NetscapeSecurity");
                }
                security = NetscapeSecurity.security;
            } else if (securityManager.toString().indexOf("com.ms.security") != -1 || bl) {
                if (Printer.debug) {
                    Printer.debug("IESecurity");
                }
                security = IESecurity.security;
            } else if (securityManager.toString().indexOf("sun.applet.AppletSecurity") != -1) {
                if (bl2) {
                    if (Printer.debug) {
                        Printer.debug("DefaultSecurity");
                    }
                    security = DefaultSecurity.security;
                }
                if (bl3) {
                    if (Printer.debug) {
                        Printer.debug("JDK12Security for applets");
                    }
                    security = JDK12Security.security;
                }
            } else if (securityManager.toString().indexOf("java.lang.SecurityManager") != -1 || securityManager.toString().indexOf("sun.applet.AppletSecurity") != -1) {
                if (bl3) {
                    if (Printer.debug) {
                        Printer.debug("JDK12Security");
                    }
                    security = JDK12Security.security;
                }
            } else {
                if (Printer.debug) {
                    Printer.debug("unknown security manager");
                }
                security = bl3 ? JDK12Security.security : DefaultSecurity.security;
            }
        } else if (bl) {
            security = IESecurity.security;
            IESecurity.jview = true;
        }
    }
}

