/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.webclient.wrapper_native;

import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.util.Assert;
import org.mozilla.util.ParameterCheck;
import org.mozilla.webclient.BrowserControl;
import org.mozilla.webclient.BrowserControlCanvas;
import org.mozilla.webclient.DocumentLoadEvent;
import org.mozilla.webclient.UnimplementedException;
import org.mozilla.webclient.WebclientEvent;
import org.mozilla.webclient.WebclientEventListener;
import org.mozilla.webclient.WindowControl;
import org.mozilla.webclient.wrapper_native.WCEventListenerWrapper;
import org.mozilla.webclient.wrapper_native.WCMouseListenerImpl;
import org.mozilla.webclient.wrapper_native.WindowControlImpl;

public class NativeEventThread
extends Thread {
    private static Object firstThread = null;
    private Vector listenersToAdd;
    private Vector listenersToRemove;
    private int nativeWebShell = -1;
    private WindowControl windowControl;
    private BrowserControl browserControl;
    private BrowserControlCanvas browserControlCanvas;
    private Enumeration tempEnum;
    static /* synthetic */ Class class$org$mozilla$webclient$DocumentLoadListener;
    static /* synthetic */ Class class$java$awt$event$MouseListener;

    public NativeEventThread(String string, BrowserControl browserControl) {
        super(string);
        ParameterCheck.nonNull(browserControl);
        if (null == firstThread) {
            firstThread = this;
        }
        this.browserControl = browserControl;
        try {
            this.windowControl = (WindowControl)this.browserControl.queryInterface("webclient.WindowControl");
            this.nativeWebShell = this.windowControl.getNativeWebShell();
            this.browserControlCanvas = (BrowserControlCanvas)this.browserControl.queryInterface("webclient.BrowserControlCanvas");
        }
        catch (Exception exception) {
            System.out.println("NativeEventThread constructor: Exception: " + exception + " " + exception.getMessage());
        }
    }

    public void delete() {
        NativeEventThread nativeEventThread = this;
        synchronized (nativeEventThread) {
            this.browserControlCanvas = null;
            NativeEventThread nativeEventThread2 = this;
            synchronized (nativeEventThread2) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    System.out.println("NativeEventThread.delete: interrupted while waiting\n\t for NativeEventThread to notify() after destruction of initContext: " + exception + " " + exception.getMessage());
                }
            }
        }
        this.listenersToAdd = null;
        this.doRemoveListeners();
        this.listenersToRemove = null;
        this.nativeWebShell = -1;
        this.windowControl = null;
        this.browserControl = null;
        this.tempEnum = null;
    }

    public void run() {
        Assert.assert_it(-1 != this.nativeWebShell);
        Assert.assert_it(null != this.windowControl);
        this.nativeInitialize(this.nativeWebShell);
        WindowControl windowControl = this.windowControl;
        synchronized (windowControl) {
            try {
                this.windowControl.notify();
            }
            catch (Exception exception) {
                System.out.println("NativeEventThread.run: Exception: trying to send notify() to windowControl: " + exception + " " + exception.getMessage());
            }
        }
        while (true) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {
                System.out.println("NativeEventThread.run(): Exception: " + exception + " while sleeping: " + exception.getMessage());
            }
            NativeEventThread nativeEventThread = this;
            synchronized (nativeEventThread) {
                if (null == this.browserControlCanvas) {
                    ((WindowControlImpl)this.windowControl).nativeDestroyInitContext(this.nativeWebShell);
                    try {
                        this.notify();
                    }
                    catch (Exception exception) {
                        System.out.println("NativeEventThread.run: Exception: trying to send notify() to this during delete: " + exception + " " + exception.getMessage());
                    }
                    return;
                }
                if (this == firstThread) {
                    this.nativeProcessEvents(this.nativeWebShell);
                }
                if (null != this.listenersToAdd && !this.listenersToAdd.isEmpty()) {
                    this.tempEnum = this.listenersToAdd.elements();
                    while (this.tempEnum.hasMoreElements()) {
                        WCEventListenerWrapper wCEventListenerWrapper = (WCEventListenerWrapper)this.tempEnum.nextElement();
                        this.nativeAddListener(this.nativeWebShell, wCEventListenerWrapper.listener, wCEventListenerWrapper.listenerClassName);
                    }
                    this.listenersToAdd.removeAllElements();
                }
                this.doRemoveListeners();
            }
        }
    }

    private void doRemoveListeners() {
        if (null != this.listenersToRemove && !this.listenersToRemove.isEmpty()) {
            this.tempEnum = this.listenersToRemove.elements();
            while (this.tempEnum.hasMoreElements()) {
                Object e = this.tempEnum.nextElement();
                if (e instanceof String) {
                    String string = (String)e;
                    if (string.equals("all")) {
                        this.nativeRemoveAllListeners(this.nativeWebShell);
                        return;
                    }
                    throw new UnimplementedException("Webclient doesn't understand how to remove " + (String)e + ".");
                }
                WCEventListenerWrapper wCEventListenerWrapper = (WCEventListenerWrapper)e;
                this.nativeRemoveListener(this.nativeWebShell, wCEventListenerWrapper.listener, wCEventListenerWrapper.listenerClassName);
            }
            this.listenersToRemove.removeAllElements();
        }
    }

    void addListener(WCEventListenerWrapper wCEventListenerWrapper) {
        Assert.assert_it(-1 != this.nativeWebShell);
        Assert.assert_it(null != this.windowControl);
        NativeEventThread nativeEventThread = this;
        synchronized (nativeEventThread) {
            if (null == this.listenersToAdd) {
                this.listenersToAdd = new Vector();
            }
            this.listenersToAdd.addElement(wCEventListenerWrapper);
        }
    }

    void removeListener(WCEventListenerWrapper wCEventListenerWrapper) {
        Assert.assert_it(-1 != this.nativeWebShell);
        Assert.assert_it(null != this.windowControl);
        NativeEventThread nativeEventThread = this;
        synchronized (nativeEventThread) {
            if (null == this.listenersToRemove) {
                this.listenersToRemove = new Vector();
            }
            if (null == wCEventListenerWrapper) {
                String string = "all";
                this.listenersToRemove.addElement(string);
            } else {
                this.listenersToRemove.addElement(wCEventListenerWrapper);
            }
        }
    }

    void nativeEventOccurred(WebclientEventListener webclientEventListener, String string, long l, Object object) {
        ParameterCheck.nonNull(webclientEventListener);
        ParameterCheck.nonNull(string);
        Assert.assert_it(-1 != this.nativeWebShell);
        Assert.assert_it(null != this.windowControl);
        WebclientEvent webclientEvent = null;
        if ((class$org$mozilla$webclient$DocumentLoadListener == null ? (class$org$mozilla$webclient$DocumentLoadListener = NativeEventThread.class$("org.mozilla.webclient.DocumentLoadListener")) : class$org$mozilla$webclient$DocumentLoadListener).getName().equals(string)) {
            webclientEvent = new DocumentLoadEvent(this, l, object);
        } else if ((class$java$awt$event$MouseListener == null ? (class$java$awt$event$MouseListener = NativeEventThread.class$("java.awt.event.MouseListener")) : class$java$awt$event$MouseListener).getName().equals(string)) {
            Assert.assert_it(webclientEventListener instanceof WCMouseListenerImpl);
            webclientEvent = new WebclientEvent(this.browserControlCanvas, l, object);
        }
        webclientEventListener.eventDispatched(webclientEvent);
    }

    public native void nativeInitialize(int var1);

    public native void nativeProcessEvents(int var1);

    public native void nativeAddListener(int var1, WebclientEventListener var2, String var3);

    public native void nativeRemoveListener(int var1, WebclientEventListener var2, String var3);

    public native void nativeRemoveAllListeners(int var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

