/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.io;

import gnu.prolog.io.PrologStream;
import gnu.prolog.io.RandomAccessFileWriter;
import gnu.prolog.io.ReadOptions;
import gnu.prolog.io.TermWriter;
import gnu.prolog.io.WriteOptions;
import gnu.prolog.term.JavaObjectTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Writer;

public class TextOutputPrologStream
extends PrologStream {
    protected TermWriter termWriter;
    protected RandomAccessFileWriter fileWriter;

    public TextOutputPrologStream(PrologStream.OpenOptions options, Writer wr) {
        super(options);
        this.endOfStream = atAtom;
        this.termWriter = new TermWriter(wr);
    }

    public TextOutputPrologStream(PrologStream.OpenOptions options, RandomAccessFile raf) {
        super(options);
        this.endOfStream = atAtom;
        this.fileWriter = new RandomAccessFileWriter(raf);
        this.termWriter = new TermWriter(this.fileWriter);
    }

    @Override
    public int getByte(Term streamTerm, Interpreter interptreter) throws PrologException {
        this.checkExists();
        PrologException.permissionError(inputAtom, TermConstants.textStreamAtom, streamTerm);
        return 0;
    }

    @Override
    public int peekByte(Term streamTerm, Interpreter interptreter) throws PrologException {
        this.checkExists();
        PrologException.permissionError(inputAtom, TermConstants.textStreamAtom, streamTerm);
        return 0;
    }

    @Override
    public void putByte(Term streamTerm, Interpreter interptreter, int _byte) throws PrologException {
        this.checkExists();
        PrologException.permissionError(outputAtom, TermConstants.textStreamAtom, streamTerm);
    }

    @Override
    public Term getPosition(Term streamTerm, Interpreter interptreter) throws PrologException {
        this.checkExists();
        if (this.fileWriter != null) {
            try {
                return new JavaObjectTerm(this.fileWriter.getPosition());
            }
            catch (IOException ex) {
                this.debug(ex);
                PrologException.systemError(ex);
                return null;
            }
        }
        PrologException.permissionError(repositionAtom, TermConstants.textStreamAtom, streamTerm);
        return null;
    }

    @Override
    public void setPosition(Term streamTerm, Interpreter interptreter, Term position) throws PrologException {
        this.checkExists();
        if (this.fileWriter != null) {
            try {
                long pos;
                if (this.reposition == TermConstants.falseAtom) {
                    PrologException.permissionError(repositionAtom, streamAtom, this.getStreamTerm());
                }
                if (position instanceof VariableTerm) {
                    PrologException.instantiationError();
                } else if (!(position instanceof JavaObjectTerm)) {
                    PrologException.domainError(TermConstants.streamPositionAtom, position);
                }
                JavaObjectTerm jt = (JavaObjectTerm)position;
                if (!(jt.value instanceof Long)) {
                    PrologException.domainError(TermConstants.streamPositionAtom, position);
                }
                if ((pos = ((Long)jt.value).longValue()) > this.fileWriter.size()) {
                    PrologException.domainError(TermConstants.streamPositionAtom, position);
                }
                this.fileWriter.seek(pos);
            }
            catch (IOException ex) {
                this.debug(ex);
                PrologException.systemError(ex);
            }
            return;
        }
        PrologException.permissionError(repositionAtom, streamAtom, streamTerm);
    }

    @Override
    public int getCode(Term streamTerm, Interpreter interptreter) throws PrologException {
        this.checkExists();
        PrologException.permissionError(inputAtom, streamAtom, streamTerm);
        return 0;
    }

    @Override
    public int peekCode(Term streamTerm, Interpreter interptreter) throws PrologException {
        this.checkExists();
        PrologException.permissionError(inputAtom, streamAtom, streamTerm);
        return 0;
    }

    @Override
    public void putCode(Term streamTerm, Interpreter interptreter, int code) throws PrologException {
        this.termWriter.print((char)code);
    }

    @Override
    public void putCodeSequence(Term streamTerm, Interpreter interptreter, String seq) throws PrologException {
        this.termWriter.print(seq);
    }

    @Override
    public Term readTerm(Term streamTerm, Interpreter interptreter, ReadOptions options) throws PrologException {
        PrologException.permissionError(inputAtom, streamAtom, streamTerm);
        return null;
    }

    @Override
    public void writeTerm(Term streamTerm, Interpreter interptreter, WriteOptions options, Term term) throws PrologException {
        this.termWriter.print(options, term);
    }

    @Override
    public void flushOutput(Term streamTerm) throws PrologException {
        this.termWriter.flush();
    }

    @Override
    public void close(boolean force) throws PrologException {
        block2: {
            try {
                this.termWriter.close();
            }
            catch (Exception ex) {
                this.debug(ex);
                if (force) break block2;
                PrologException.systemError(ex);
            }
        }
        super.close(force);
    }
}

