/* LocaleInformation_lo.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_lo extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "LAK";

  private static final String currenciesDisplayNameValues = "\u0e81\u0eb5\u0e9a";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "LAK";

  private static final String currenciesSymbolValues = "\u20ad";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "\u0ea1.\u0e81.",
    "\u0e81.\u0e9e.",
    "\u0ea1\u0eb5.\u0e99.",
    "\u0ea1.\u0eaa..",
    "\u0e9e.\u0e9e.",
    "\u0ea1\u0eb4.\u0e96.",
    "\u0e81.\u0ea5.",
    "\u0eaa.\u0eab.",
    "\u0e81.\u0e8d.",
    "\u0e95.\u0ea5.",
    "\u0e9e.\u0e88.",
    "\u0e97.\u0ea7.",
    null,
  };

  private static final String[] months = {
    "\u0ea1\u0eb1\u0e87\u0e81\u0ead\u0e99",
    "\u0e81\u0eb8\u0ea1\u0e9e\u0eb2",
    "\u0ea1\u0eb5\u0e99\u0eb2",
    "\u0ec0\u0ea1\u0eaa\u0eb2",
    "\u0e9e\u0eb6\u0e94\u0eaa\u0eb0\u0e9e\u0eb2",
    "\u0ea1\u0eb4\u0e96\u0eb8\u0e99\u0eb2",
    "\u0e81\u0ecd\u0ea5\u0eb0\u0e81\u0ebb\u0e94",
    "\u0eaa\u0eb4\u0e87\u0eab\u0eb2",
    "\u0e81\u0eb1\u0e99\u0e8d\u0eb2",
    "\u0e95\u0eb8\u0ea5\u0eb2",
    "\u0e9e\u0eb0\u0e88\u0eb4\u0e81",
    "\u0e97\u0eb1\u0e99\u0ea7\u0eb2",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "\u0ead\u0eb2.",
    "\u0e88.",
    "\u0ead.",
    "\u0e9e.",
    "\u0e9e\u0eab.",
    "\u0eaa\u0e81.",
    "\u0eaa.",
  };

  private static final String[] weekdays = {
    null,
    "\u0ea7\u0eb1\u0e99\u0ead\u0eb2\u0e97\u0eb4\u0e94",
    "\u0ea7\u0eb1\u0e99\u0e88\u0eb1\u0e99",
    "\u0ea7\u0eb1\u0e99\u0ead\u0eb1\u0e87\u0e84\u0eb2\u0e99",
    "\u0ea7\u0eb1\u0e99\u0e9e\u0eb8\u0e94",
    "\u0ea7\u0eb1\u0e99\u0e9e\u0eb0\u0eab\u0eb1\u0e94",
    "\u0ea7\u0eb1\u0e99\u0eaa\u0eb8\u0e81",
    "\u0ea7\u0eb1\u0e99\u0ec0\u0eaa\u0ebb\u0eb2",
  };

  private static final String[] ampms = {
    "\u0e81\u0ec8\u0ead\u0e99\u0e97\u0ec8\u0ebd\u0e87",
    "\u0eab\u0ea5\u0eb1\u0e87\u0e97\u0ec8\u0ebd\u0e87",
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|GW|GT|GR|GQ|GP|SZ|SY|GN|GM|SV|GH|SR|GF|SP|GE|SO|SN|GB|SL|GA|SK|SI|SG|SE|SD|SC|SA|FR|FM|RW|RU|FJ|FI|RO|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|DK|DJ|PT|PR|DE|PL|PK|PH|PG|PF|CZ|PE|CY|CV|PA|CU|CR|CO|CN|CM|CL|CI|CH|CG|CF|OM|CA|BZ|BY|BW|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|AZ|NE|NC|AW|ZM|AU|NA|AT|AR|MZ|AO|MY|AN|MX|AM|AL|ZA|MU|MT|AI|MS|MR|MQ|AF|AE|MO|AD|MN|MM|ML|MK|YU|YT|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LB|LA|KZ|KW|KR|KP|KM|KI|KH|KG|KE|JP|JO|JM|VU|VN|VI|VG|VE|VA|IT|IS|IR|IQ|UZ|UY|IN|IL|US|IE|ID|UG|UA|HU|HT|HR|TZ|HN|TW|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "\u0e95\u0eb4\u0ea1\u0ecd\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0ead\u0ead\u0e81|\u0ec2\u0e97\u0e81\u0eb4\u0ec2\u0ea5|\u0e97\u0eb2\u0e88\u0eb4\u0e81\u0eb4\u0eaa\u0eb0\u0e96\u0eb2\u0e99|\u0e9b\u0eb0\u0ec0\u0e97\u0e94\u0ec4\u0e97|\u0ec2\u0e95\u0ec2\u0e81|\u0ead\u0eb2\u0e99\u0eb2\u0ec0\u0e82\u0e94\u0e97\u0eb2\u0e87\u0ec3\u0e95\u0ec9\u0e82\u0ead\u0e87\u0e9d\u0ea5\u0eb1\u0ec8\u0e87\u0ec0\u0eaa\u0e94|\u0e81\u0eb9\u0ea2\u0eb2\u0e99\u0eb2|\u0e8a\u0eb2\u0e94|\u0e81\u0eb4\u0ea7\u0e99\u0eb5-\u0e9a\u0eb4\u0eaa\u0ec2\u0e8a|\u0e81\u0ebb\u0ea7\u0ec0\u0e95\u0ea1\u0eb2\u0ea5\u0eb2|\u0e81\u0eb4\u0ebc\u0e81|\u0ec0\u0ead\u0e84\u0ebb\u0ea7\u0ec2\u0e97\u0ec0\u0ea5\u0e8d\u0ea5\u0eb0\u0e81\u0eb4\u0e99\u0eb5|\u0e81\u0ebb\u0ea7\u0ec0\u0e94\u0eb5\u0ea5\u0eb9\u0e9a|\u0eaa\u0eb0\u0ea7\u0eb2\u0e8a\u0eb4\u0ec1\u0ea5\u0e99|\u0e8a\u0eb4\u0ec0\u0ea5\u0e8d|\u0e81\u0eb4\u0ea7\u0e99\u0eb5|\u0ec1\u0e81\u0ea1\u0ec0\u0e9a\u0e8d|\u0ec0\u0ead\u0e8a\u0eb2\u0ea7\u0eb2\u0e94\u0ecd|\u0e81\u0eb2\u0e99\u0ec8\u0eb2|\u0e8a\u0eb9\u0ea5\u0eb4\u0e99\u0eb2\u0ea1\u0eb4|\u0ec0\u0e9f\u0eb1\u0e99\u0eaa\u0e81\u0eb4\u0ea7\u0e99\u0eb2|\u0ec0\u0e8a\u0eb5\u0ec0\u0e9a\u0e8d|\u0e88\u0ecd\u0ec0\u0e88\u0e8d|\u0ec2\u0e8a\u0ea1\u0eb2\u0ec0\u0ea5\u0e8d|\u0e8a\u0eb4\u0e99\u0eb5\u0e81\u0eb1\u0e99|\u0eaa\u0eb0\u0eab\u0eb0\u0ea5\u0eb2\u0e94\u0e8a\u0eb0\u0ead\u0eb2\u0e99\u0eb2\u0e88\u0eb1\u0e81|\u0ec0\u0e8a\u0e8d\u0ea5\u0eb2\u0eaa\u0eb4\u0ead\u0ead\u0e99|\u0e81\u0eb2\u0e9a\u0ead\u0e99|\u0eaa\u0eb0\u0ec2\u0ea5\u0ea7\u0eb2\u0ec0\u0e81\u0e8d|\u0eaa\u0eb0\u0ec2\u0ea5\u0ec0\u0ea7\u0ec0\u0e99\u0e8d|\u0eaa\u0eb4\u0e87\u0e81\u0eb0\u0ec2\u0e9b|\u0eaa\u0eb0\u0ea7\u0eb4\u0ec0\u0e94\u0eb1\u0e99|\u0e8a\u0eb9\u0e94\u0eb2\u0e99|\u0ec0\u0e8a\u0ec1\u0e8a\u0ea7|\u0e8a\u0eb2\u0ead\u0eb8\u0e94\u0eb4\u0ead\u0eb2\u0ea5\u0eb0\u0ec0\u0e9a\u0e8d|\u0e9d\u0ea5\u0eb1\u0ec8\u0e87|\u0ec4\u0ea1\u0ec2\u0e84\u0e99\u0eb4\u0ec0\u0e8a\u0e8d|\u0ea5\u0eb2\u0ea7\u0eb1\u0e99\u0e94\u0eb2|\u0ea5\u0eb1\u0e94\u0ec0\u0e8a\u0e8d|\u0e9f\u0eb4\u0e88\u0eb4|\u0e9f\u0eb4\u0e99\u0ec1\u0ea5\u0e99|\u0ea5\u0eb9\u0ec0\u0ea1\u0ec0\u0e99\u0e8d|\u0ec0\u0ead\u0e97\u0eb4\u0ec2\u0ead\u0ec0\u0e9b\u0e8d|\u0eaa\u0eb0\u0ec0\u0e9b\u0e99|\u0ead\u0eb4\u0e99\u0e8a\u0eb5|\u0e8a\u0eb2\u0eae\u0eb2\u0ea5\u0eb2\u0e95\u0eb0\u0ec0\u0ea7\u0eb1\u0e99\u0e95\u0ebb\u0e81|\u0ead\u0eb5\u0ea2\u0eb4\u0e9a|\u0ec0\u0ead\u0eaa\u0ec2\u0e95\u0ec0\u0e99\u0e8d|\u0ec0\u0ead\u0e81\u0ea7\u0eb2\u0e94\u0ecd|\u0ec1\u0ead\u0ea5\u0e88\u0eb4\u0ec0\u0ea5\u0e8d|\u0e81\u0eb2\u0e95\u0eb2|\u0eaa\u0eb2\u0e97\u0eb2\u0ea5\u0eb0\u0e99\u0eb0\u0ea5\u0eb1\u0e94\u0ec2\u0e94\u0ea1\u0eb4\u0e99\u0eb4\u0e81\u0eb1\u0e99|\u0e9b\u0eb2\u0ea5\u0eb2\u0e81\u0ea7\u0e8d|\u0ec2\u0e94\u0ec0\u0ea1\u0e99\u0eb4\u0e81\u0eb2|\u0ec0\u0e94\u0e99\u0ea1\u0eb2\u0e81|\u0e84\u0eb4\u0ec2\u0e9a\u0e95\u0eb4|\u0ec2\u0e9b\u0e95\u0eb8\u0e81\u0e81\u0eb1\u0e99|\u0ec0\u0e9b\u0eb5\u0ec2\u0e95\u0ea5\u0eb4\u0ec2\u0e81|\u0ec0\u0ea2\u0e8d\u0ea5\u0eb0\u0ea1\u0eb1\u0e99|\u0ec2\u0e9b\u0ec1\u0ea5\u0e99|\u0e9b\u0eb2\u0e81\u0eb4\u0eaa\u0e96\u0eb2\u0e99|\u0e9f\u0eb4\u0ea5\u0eb4\u0e9b\u0eb4\u0e99|\u0e9b\u0eb2\u0e9b\u0ebb\u0ea7\u0e99\u0eb4\u0ea7\u0e81\u0eb5\u0e99\u0eb5|\u0ec0\u0e9f\u0eb1\u0e99\u0ea3\u0ec2\u0e9e\u0ea5\u0eb4\u0e99\u0eb5\u0ec0\u0e8a\u0e8d|\u0eaa\u0eb2\u0e97\u0eb2\u0ea5\u0eb0\u0e99\u0eb0\u0ea5\u0eb1\u0e94\u0ec0\u0e8a\u0eb1\u0e81|\u0ec0\u0e9b\u0ea5\u0eb9|\u0ec4\u0e8a\u0e9b\u0eb1\u0ebc\u0e94|\u0ec0\u0e84\u0e9a\u0ea7\u0ead\u0e94|\u0e9b\u0eb2\u0e99\u0eb2\u0ea1\u0eb2|\u0e84\u0eb4\u0ea7\u0e9a\u0eb2|\u0e84\u0ead\u0eaa\u0e95\u0eb2\u0ea5\u0eb4\u0e81\u0eb2|\u0ec2\u0e84\u0ea5\u0eb3\u0ec0\u0e9a\u0e8d|\u0e88\u0eb5\u0e99|\u0e84\u0eb2\u0ec0\u0ea1\u0ea5\u0eb9\u0e99|\u0e8a\u0eb4\u0eaa\u0eb4|\u0e9d\u0eb1\u0ec8\u0e87\u0e97\u0eb0\u0ec0\u0ea5\u0ec4\u0ead\u0ea7\u0ecd\u0ea5\u0eb4|\u0eaa\u0eb0\u0ea7\u0eb4\u0e94\u0ec0\u0e8a\u0eb5\u0ec1\u0ea5\u0e99|\u0e84\u0ead\u0e87\u0ec2\u0e81|\u0eaa\u0eb2\u0e97\u0eb2\u0ea5\u0eb0\u0e99\u0eb0\u0ea5\u0eb1\u0e94\u0ead\u0eb1\u0e9a\u0e9f\u0ebc\u0eb4\u0e81\u0e81\u0eb2\u0e81\u0eb2\u0e87|\u0ec2\u0ead\u0ea1\u0eb2\u0e99|\u0e81\u0eb2\u0e99\u0eb2\u0e94\u0eb2|\u0ec0\u0e9a\u0ea5\u0eb4\u0e8a|\u0ec0\u0e9a\u0e99\u0ea5\u0eb2\u0eae\u0eb1\u0eaa|\u0e9a\u0ead\u0eb1\u0e94\u0eaa\u0eb0\u0ea7\u0eb2\u0e99\u0eb2|\u0e9e\u0eb9\u0e96\u0eb2\u0e99|\u0e9a\u0eb2\u0eae\u0eb2\u0ea1\u0eb2\u0eaa|\u0e9a\u0ebc\u0eb2\u0e8a\u0eb4\u0ea7|\u0e99\u0eb4\u0ea7\u0e8a\u0eb5\u0ec1\u0ea5\u0e99|\u0ec2\u0e9a\u0ea5\u0eb4\u0ec0\u0ea7\u0e8d|\u0e9a\u0eb9\u0eae\u0ec4\u0e99|\u0ec0\u0e9a\u0eb5\u0ea1\u0eb4\u0ea7\u0e94\u0eb2|\u0e99\u0eb5\u0ea2\u0eb9|\u0ec0\u0e9a\u0e99\u0eb4\u0e99|\u0e9a\u0eb9\u0ea5\u0eb1\u0e99\u0e95\u0eb4|\u0e9a\u0eb2\u0ec0\u0ea5\u0e99|\u0e9a\u0eb1\u0e87\u0e81\u0eb2\u0ec0\u0ea5\u0e8d|\u0ec0\u0e9a\u0eb5\u0e81\u0eb4\u0e99\u0eb2\u0e9f\u0eb2\u0ec2\u0e8a|\u0ec0\u0e99\u0e9b\u0eb2\u0e99|\u0ec0\u0e9a\u0ea7\u0ea2\u0ebd\u0ea1|\u0e99\u0ecd\u0ec0\u0ea7|\u0e9a\u0eb1\u0e87\u0e81\u0eb0\u0ea5\u0eb2\u0ec0\u0e97\u0e94|\u0e9a\u0eb2\u0e9a\u0eb2\u0e84\u0eb1\u0ead\u0e94|\u0e8a\u0eb4\u0ea1\u0e9a\u0eb1\u0e9a\u0ec0\u0ea7|\u0ec0\u0e99\u0ec0\u0e97\u0eb5\u0ec1\u0ea5\u0e99|\u0e9a\u0eb1\u0ead\u0e94\u0eaa\u0ec0\u0e99\u0e8d \u0ec1\u0ea5\u0eb0 \u0ec0\u0eae\u0eb5\u0e94\u0ec2\u0e81\u0ea7\u0eb4\u0ec0\u0e99\u0e8d|\u0e99\u0eb4\u0e84\u0eb2\u0ea5\u0eb2\u0e81\u0ebb\u0ea7|\u0ec4\u0e99\u0e88\u0eb5\u0ec0\u0ea5\u0e8d|\u0ead\u0eb2\u0ec0\u0e8a\u0eb5\u0ec4\u0e9a\u0e88\u0eb1\u0e99|\u0ec4\u0e99\u0ec0\u0e88\u0eb5|\u0e99\u0eb4\u0ea7\u0e84\u0eb2\u0ea5\u0eb4\u0ec2\u0e84\u0ec0\u0e99\u0e8d|\u0ead\u0eb2\u0ea5\u0eb9\u0e9a\u0eb2|\u0ec1\u0e8a\u0ea1\u0ec0\u0e9a\u0e8d|\u0ead\u0ebb\u0ead\u0e94\u0eaa\u0eb0\u0e95\u0eb2\u0ea5\u0eb5|\u0e99\u0eb2\u0ea1\u0eb4\u0ec0\u0e9a\u0e8d|\u0ead\u0ebb\u0ead\u0e94\u0eaa\u0eb0\u0ec0\u0e95\u0ebc\u0e8d|\u0ead\u0eb2\u0ec0\u0e88\u0e99\u0e95\u0eb4\u0e99\u0eb2\u0ec8|\u0ec2\u0ea1\u0ec1\u0e8a\u0ea1\u0e9a\u0eb4\u0e81|\u0ead\u0eb1\u0e99\u0ec2\u0e81\u0ea5\u0eb2|\u0ea1\u0eb2\u0ec0\u0ea5\u0ec0\u0e8a\u0e8d|\u0ec0\u0e99\u0ec0\u0e97\u0eb5\u0ec1\u0ea5\u0e99\u0ec1\u0ead\u0e99\u0ec0\u0e97\u0eb4\u0e99|\u0ec1\u0ea1\u0eb1\u0e81\u0e8a\u0eb4\u0ec2\u0e81|\u0ead\u0eb2\u0ea1\u0eb4\u0ec0\u0e99\u0e8d|\u0ec1\u0ead\u0ea5\u0ec0\u0e9a\u0ec0\u0e99\u0e8d|\u0ead\u0eb2\u0e9f\u0eb0\u0ea5\u0eb4\u0e81\u0eb2\u0ec3\u0e95\u0ec9|\u0ea1\u0ecd\u0ea3\u0eb4\u0e95\u0ebd\u0e94|\u0ea1\u0eb1\u0e99\u0e95\u0eb2|\u0ead\u0eb1\u0e99\u0e81\u0eb4\u0ea5\u0eb2|\u0ea1\u0ead\u0e99\u0ec0\u0e8a\u0eb5\u0ea5\u0eb2\u0e94|\u0ea1\u0ecd\u0ea5\u0eb4\u0e81\u0e97\u0eb2\u0ec0\u0e99\u0e8d|\u0ea1\u0eb2\u0e95\u0eb4\u0e99\u0eb4\u0e81|\u0ead\u0eb1\u0e9f\u0e81\u0eb2\u0e99\u0eb4\u0e94\u0eaa\u0eb0\u0e96\u0eb2\u0e99|\u0eaa\u0eb0\u0eab\u0eb0\u0ea5\u0eb1\u0e94\u0ead\u0eb2\u0eab\u0ea5\u0eb1\u0e9a\u0ec0\u0ead\u0ea1\u0eb4\u0ec0\u0ea5\u0e94|\u0ea1\u0eb2\u0ec0\u0e81\u0ebb\u0ec9\u0eb2|\u0ead\u0eb1\u0e99\u0e94\u0ecd\u0ea5\u0eb2|\u0ea1\u0ebb\u0e87\u0ec2\u0e81\u0ea5\u0eb5|\u0eaa\u0eb0\u0eab\u0eb0\u0e9e\u0eb2\u0e9a\u0e9e\u0eb0\u0ea1\u0ec9\u0eb2|\u0ea1\u0eb2\u0ea5\u0eb4|\u0ec1\u0ea1\u0e8a\u0eb4\u0ec2\u0e84\u0ec0\u0e99\u0e8d|\u0ea2\u0eb9\u0ec2\u0e81\u0eaa\u0eb0\u0ea5\u0eb2\u0ec0\u0ea7\u0e8d|\u0ea1\u0eb2\u0ea2\u0ead\u0e94|\u0ea1\u0eb2\u0e84\u0eb2\u0e81\u0eb1\u0eaa\u0e81\u0eb2|\u0ec2\u0ea1\u0e99\u0ec2\u0e84\u0ea7\u0eb2|\u0ec2\u0ea1\u0e99\u0eb2\u0ec2\u0e81|\u0ec2\u0ea1\u0ea5\u0eb1\u0ead\u0e81\u0ec2\u0e84|\u0ec0\u0ea2\u0ec0\u0ea1\u0e99|\u0ea5\u0eb4\u0ec0\u0e9a\u0e8d|\u0ea5\u0ebc\u0eb2\u0e94\u0ec0\u0ea7\u0e8d|\u0ea5\u0eb8\u0e81\u0ec1\u0e8a\u0ea1\u0ec0\u0e9a\u0eb5\u0e81|\u0ea5\u0eb4\u0ec0\u0e97\u0eb5\u0ec0\u0e99\u0e8d|\u0ec0\u0ea5\u0ec2\u0e8a\u0ec2\u0e97|\u0ea5\u0eb4\u0ec0\u0e9a\u0eb5\u0ec0\u0ea5\u0e8d|\u0eaa\u0eb5\u0ea5\u0eb1\u0e87\u0e81\u0eb2|\u0ec4\u0ea5\u0ec0\u0e97\u0e99\u0eaa\u0eb0\u0ec4\u0e95|\u0ec0\u0ea5\u0e9a\u0eb2\u0e99\u0ead\u0e99|\u0ea5\u0eb2\u0ea7|\u0e84\u0eb2\u0e8a\u0eb1\u0e94\u0eaa\u0eb0\u0e96\u0eb2\u0e99|\u0e84\u0eb9\u0ec0\u0ea7\u0e94|\u0ec0\u0e81\u0ebb\u0eb2\u0eab\u0ea5\u0eb5\u0ec3\u0e95\u0ec9|\u0ec0\u0e81\u0ebb\u0eb2\u0eab\u0ea5\u0eb5\u0ec0\u0edc\u0eb7\u0ead|\u0ec2\u0e84\u0ec2\u0ea1\u0ea3\u0ead\u0e94|\u0e84\u0eb5\u0ea5\u0eb4\u0e9a\u0eb2\u0e94|\u0e81\u0eb3\u0e9b\u0eb9\u0ec0\u0e88\u0e8d|\u0ec0\u0e94\u0eb5\u0e81\u0eb4\u0e94\u0eaa\u0eb0\u0e96\u0eb2\u0e99|\u0ec0\u0e84\u0e99\u0ea2\u0ec8\u0eb2|\u0e8d\u0eb5\u0ec8\u0e9b\u0ec8\u0eb8\u0e99|\u0e88\u0ecd\u0ec1\u0e94\u0e99|\u0e88\u0eb2\u0ec4\u0ea1\u0e81\u0eb2|\u0ea7\u0eb2\u0e99\u0ebb\u0ea7\u0e95\u0eb9|\u0eab\u0ea7\u0ebd\u0e94\u0e99\u0eb2\u0ea1|\u0ea2\u0eb9\u0ec0\u0ead\u0eaa\u0ec0\u0ea7\u0eb5\u0e88\u0eb4\u0e99\u0ec4\u0ead\u0ec1\u0ea5\u0e99|\u0e9a\u0ea3\u0eb4\u0e97\u0eb4\u0e94\u0ec0\u0ea7\u0eb5\u0e88\u0eb4\u0e99\u0ec4\u0ead\u0ec1\u0ea5\u0e99|\u0ec0\u0ea7\u0ec0\u0e99\u0e8a\u0eb9\u0ec0\u0ead\u0ea5\u0eb2|\u0ea7\u0eb2\u0e95\u0eb4\u0e81\u0eb1\u0e99|\u0ead\u0eb4\u0e95\u0eb2\u0ea5\u0eb5|\u0ec4\u0ead\u0eaa\u0ec1\u0ea5\u0e99|\u0ead\u0eb5\u0ea5\u0ec8\u0eb2\u0e99|\u0ead\u0eb5\u0ea5\u0eb1\u0e81|\u0ead\u0eb8\u0e94\u0ec0\u0e9a\u0e81\u0eb4\u0eaa\u0eb0\u0e96\u0eb2\u0e99|\u0ea5\u0eb9\u0e81\u0ea7\u0e8d\u0ead\u0eb8\u0ea3|\u0ead\u0eb4\u0e99\u0ec0\u0e94\u0e8d|\u0ead\u0eb4\u0eaa\u0ea5\u0eb0\u0ec0\u0ead\u0ea7|\u0eaa\u0eb0\u0eab\u0eb0\u0ea5\u0eb1\u0e94\u0ead\u0eb2\u0ec0\u0ea1\u0ea5\u0eb4\u0e81\u0eb2|\u0ec4\u0ead\u0ec1\u0ea5\u0e99|\u0ead\u0eb4\u0e99\u0ec2\u0e94\u0ec0\u0e99\u0ec0\u0e8a\u0e8d|\u0ead\u0eb9\u0e81\u0eb2\u0e99\u0e94\u0eb2|\u0ea2\u0eb9\u0ec0\u0e84\u0ebc\u0e99|\u0eae\u0ebb\u0e87\u0e81\u0eb2\u0ea3\u0eb5|\u0ec4\u0ead\u0e97\u0eb5|\u0ec2\u0e84\u0ec0\u0ead\u0ec0\u0e8a\u0e8d|\u0e97\u0eb2\u0e99\u0e8a\u0eb2\u0ec0\u0e99\u0e8d|\u0ead\u0ea7\u0e99\u0e84\u0eb9\u0ea3\u0eb1\u0eaa|\u0ec4\u0e95\u0ec9\u0eab\u0ea7\u0eb1\u0e99|\u0eae\u0ec8\u0ead\u0e87\u0e81\u0ebb\u0e87|\u0e97\u0eb4\u0e99\u0eb4\u0ec1\u0e94\u0e94|\u0e95\u0eb8\u0e99\u0e81\u0eb5|\u0e97\u0ead\u0e87\u0e81\u0ec9\u0eb2|\u0e95\u0eb9\u0e99\u0eb4\u0ec0\u0e8a\u0e8d|\u0ec0\u0e95\u0ea3\u0eb5\u0e81\u0ec0\u0ea1\u0e99\u0eb4\u0eaa\u0eb0\u0e96\u0eb2\u0e99";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "es|ku|eo|ks|en|el|qu|ko|kn|km|kl|kk|wo|ka|dz|jv|pt|ps|de|pl|da|vo|ja|vi|cy|pa|cs|iu|it|co|is|uz|or|ik|ur|om|ca|ie|id|uk|ia|oc|ug|hy|br|hu|bo|bn|hr|bi|tw|bh|bg|tt|no|be|ts|hi|tr|nl|zu|ba|to|he|tn|tl|tk|ha|ne|az|ti|ay|th|tg|na|te|zh|as|ar|ta|gu|my|am|za|mt|ms|gn|sw|mr|sv|gl|su|af|st|mo|ss|mn|sr|sq|ml|ab|mk|aa|so|sn|mi|gd|sm|sl|mg|sk|ga|yo|si|sh|sg|yi|sd|fy|sa|fr|lv|lt|fo|rw|ru|lo|fj|ln|fi|ro|rn|rm|fa|la|xh|eu|ky|et";

  private static final String languagesValues = "\u0eaa\u0eb0\u0ec0\u0e9b\u0e99|\u0ec0\u0e84\u0eb5\u0e94|\u0ec0\u0ead\u0eaa\u0ec0\u0e9b\u0eb5\u0ea5\u0eb1\u0e99\u0ec2\u0e95|\u0e84\u0eb1\u0e94\u0e8a\u0eb0\u0ea1\u0eb5\u0ea5\u0eb5|\u0ead\u0eb1\u0e87\u0e81\u0eb4\u0e94|\u0e81\u0eb5\u0e81|\u0e84\u0eb4\u0ea7\u0e8a\u0ebb\u0ea7|\u0ec0\u0e81\u0ebb\u0eb2\u0eab\u0ea5\u0eb5|\u0e81\u0eb2\u0e99\u0eb2\u0e94\u0eb2|\u0e82\u0eb0\u0ec0\u0edd\u0e99|\u0e81\u0ebc\u0eb5\u0e99\u0ec1\u0ea5\u0e99\u0e94\u0eb4\u0e94|\u0e84\u0eb2\u0e8a\u0eb1\u0e81|\u0ea7\u0eb9\u0e9a|\u0e88\u0ecd\u0ec0\u0e88\u0e8d|\u0e9e\u0eb9\u0e96\u0eb2\u0e99\u0eb5|\u0e8a\u0eb0\u0ea7\u0eb2|\u0ec2\u0e9b\u0e95\u0eb8\u0ec0\u0e81\u0e94|\u0e9e\u0eb2\u0eaa\u0ec2\u0e95(\u0e9e\u0eb8\u0e94\u0ec2\u0e95)|\u0ec0\u0ea2\u0e8d\u0ea5\u0eb0\u0ea1\u0eb1\u0e99|\u0ec2\u0e9b\u0ec1\u0ea5\u0e99|\u0ec0\u0e94\u0e99\u0edd\u0eb2\u0e81|\u0ec2\u0ea7\u0ea5\u0eb2\u0e9e\u0eb8\u0e81|\u0e8d\u0eb5\u0ec8\u0e9b\u0eb8\u0ec8\u0e99|\u0ea7\u0ebd\u0e94\u0e99\u0eb2\u0ea1|\u0ec0\u0ea7\u0ea7|\u0e9b\u0eb1\u0e99\u0e88\u0eb2|\u0ec0\u0e8a\u0eb1\u0e81|\u0ec4\u0ead\u0e99\u0eb8\u0e81\u0e95\u0eb4\u0e95\u0eb1\u0e81|\u0ead\u0eb4\u0e95\u0eb2\u0eaa\u0eb4|\u0e84\u0ecd\u0e8a\u0eb4\u0e81\u0ec9\u0eb2|\u0ec4\u0ead\u0ec1\u0ea5\u0e99\u0e94\u0eb4\u0e94|\u0ead\u0eb8\u0e94\u0eaa\u0eb0\u0ec0\u0e9a\u0e94|\u0ec2\u0ead\u0ea5\u0eb4\u0e8d\u0eb2|\u0ec4\u0ead\u0e99\u0eb9\u0e9b\u0ebd\u0e81|\u0ead\u0eb4\u0e99\u0e94\u0eb9|\u0ec2\u0ead\u0ec2\u0ea5\u0ec2\u0ea1(\u0ead\u0eb2\u0e9f\u0eb2\u0e99)|\u0ec1\u0e84\u0e95\u0eb2\u0ec1\u0ea5\u0e99|\u0ead\u0eb4\u0e99\u0ec0\u0e95\u0eb5\u0ea5\u0eb4\u0e87|\u0ead\u0eb4\u0e99\u0ec2\u0e94\u0ec0\u0e99\u0ec0\u0e8a\u0e8d|\u0ea2\u0eb9\u0ec0\u0e84\u0ebc\u0e99|\u0ead\u0eb4\u0e99\u0ec0\u0e95\u0eb5\u0ea5\u0eb4\u0e87\u0e81\u0ea7\u0eb2|\u0ead\u0ead\u0eb1\u0e81\u0e8a\u0eb4\u0e97\u0eb1\u0e99|\u0ead\u0eb8\u0e8d\u0e81\u0ebb\u0ea7|\u0ead\u0eb2\u0ea1\u0eb4\u0ec0\u0e99\u0e8d|\u0e9a\u0eb5\u0e97\u0eb1\u0e99|\u0eae\u0ebb\u0e87\u0e81\u0eb2\u0ea5\u0eb5|\u0e97\u0eb4\u0ec0\u0e9a\u0e94|\u0e9a\u0eb8\u0e99\u0e81\u0eb2\u0ea5\u0eb5|\u0ec2\u0e84\u0ec0\u0ead\u0ec0\u0e8a\u0e8d|\u0e9a\u0eb4\u0eaa\u0ea5\u0eb2\u0ea1\u0eb2|\u0e97\u0eb0\u0ea7\u0eb5|\u0e9a\u0eb4\u0eae\u0eb2\u0ea5\u0eb4|\u0e9a\u0eb1\u0e87\u0e81\u0eb2\u0ec0\u0ea5\u0e8d|\u0e95\u0eb2\u0e94|\u0e99\u0ecd\u0ec0\u0ea7\u0ea7|\u0e9a\u0eb2\u0e8d\u0ec2\u0ea5\u0ea5\u0eb1\u0e94\u0ec0\u0e8a\u0e8d|\u0e8a\u0ead\u0e87\u0e81\u0eb2|\u0eae\u0eb4\u0e99\u0e94\u0eb4|\u0e95\u0eb8\u0ea5\u0eb2\u0e81\u0eb5|\u0ead\u0ecd\u0ea5\u0eb1\u0e99\u0e94\u0eb2|\u0e8a\u0eb9\u0ea5\u0eb9|\u0e9a\u0eb2\u0eaa\u0eaa\u0eb5|\u0e97\u0ead\u0e87\u0e81\u0ec9\u0eb2|\u0ea2\u0eb4\u0ea7|\u0ec0\u0e8a\u0e95\u0eb0\u0eaa\u0eb0\u0ea7\u0eb2\u0e99\u0eb2|\u0e95\u0eb2\u0e81\u0eb2\u0ea5\u0eb1\u0ead\u0e81|\u0ec0\u0e95\u0eb5\u0e81\u0ec0\u0ea1\u0e99|\u0ec2\u0ead\u0e8a\u0eb2|\u0ec0\u0e99\u0e9b\u0eb2\u0e99|\u0ead\u0eb2\u0ec0\u0e8a\u0eb5\u0ec4\u0e9a\u0e88\u0eb2\u0e99\u0eb5|\u0e97\u0eb4\u0e81\u0eb4\u0e99\u0ea2\u0eb2|\u0ec4\u0ead\u0ea1\u0eb2\u0ea5\u0eb2|\u0ec4\u0e97|\u0e97\u0eb2\u0e88\u0eb4\u0e94|\u0e99\u0ecd\u0ea5\u0eb9|\u0e97\u0eb4\u0ea5\u0eb9\u0e81\u0eb9|\u0e88\u0eb5\u0e99|\u0ead\u0eb1\u0e94\u0eaa\u0eb3\u0ea1\u0eb4\u0e94|\u0ead\u0eb2\u0ea5\u0eb2\u0ec0\u0e9a\u0e8d|\u0e97\u0eb0\u0ea1\u0eb4\u0e9a|\u0e81\u0eb9\u0e88\u0eb2\u0ea5\u0eb2\u0e95\u0eb5|\u0e9e\u0eb0\u0ea1\u0ec8\u0eb2|\u0ead\u0eb3\u0eae\u0eb2\u0ea5\u0eb4\u0e94|\u0e88\u0ea7\u0e87|\u0ea1\u0ead\u0e99\u0e95\u0eb2|\u0ea1\u0eb2\u0ea5\u0eb2\u0ea2\u0eb9|\u0e81\u0ebb\u0ea7\u0ea5\u0eb2\u0e99\u0eb5|\u0e8a\u0eb0\u0ea7\u0eb2\u0eae\u0eb4\u0ea5\u0eb5|\u0ea1\u0eb2\u0ea5\u0eb2\u0e97\u0eb4|\u0eaa\u0eb0\u0ea7\u0eb5\u0ec0\u0e94\u0e99|\u0e81\u0eb0\u0eaa\u0eb4\u0ec0\u0e8a\u0e8d|\u0e8a\u0eb1\u0e99\u0e94\u0eb2\u0e99\u0eb4\u0eaa|\u0ead\u0eb2\u0e9f\u0eb4\u0ebc\u0e81\u0e81\u0eb2|\u0ec0\u0e8a\u0ec2\u0eaa\u0ec2\u0e97|\u0ec2\u0ea1\u0e84\u0eb2\u0ec0\u0ea7\u0e8d|\u0e8a\u0eb4\u0eaa\u0ea7\u0eb2\u0e95\u0eb4|\u0ea1\u0ead\u0e87\u0ec2\u0e81\u0ebc|\u0ec0\u0e8a\u0eb5\u0ec0\u0e9a\u0e8d|\u0ec1\u0ead\u0ea5\u0ec0\u0e9a\u0ec0\u0e99\u0e8d|\u0ec1\u0ea1\u0ea5\u0eb0\u0ea2\u0eb2\u0ea5\u0eb3|\u0ec1\u0ead\u0e9a\u0e84\u0eb2\u0ec0\u0e8a\u0e8d|\u0ec1\u0ea1\u0eb1\u0e81\u0e8a\u0eb4\u0ec2\u0e94\u0ec0\u0e99\u0e8d|\u0ead\u0eb2\u0e9f\u0eb2|\u0ec2\u0e8a\u0ea1\u0eb2\u0eaa\u0eb4|\u0ec2\u0e8a\u0e99\u0eb2|\u0ec0\u0ea1\u0ebb\u0eb2\u0ea5\u0eb5|\u0eaa\u0eb0\u0e81\u0eb1\u0ead\u0e94\u0ec0\u0e84\u0eb5\u0e94|\u0e8a\u0eb2\u0ea1\u0ebb\u0ea7|\u0eaa\u0eb0\u0ec2\u0ea5\u0ea7\u0eb2\u0ec0\u0e99\u0e8d|\u0ea1\u0eb2\u0ea5\u0eb2\u0e81\u0eb2\u0e8a\u0eb4|\u0eaa\u0eb0\u0ec2\u0ea5\u0ea7\u0eb1\u0e81|\u0ec4\u0ead\u0ea5\u0eb4\u0e94|\u0ec2\u0ea2\u0ea5\u0eb9\u0e9a\u0eb2|\u0eaa\u0eb4\u0e87\u0eab\u0ea5\u0ecd|\u0ec0\u0e8a\u0eb5\u0ec2\u0e9a-\u0ec2\u0e84\u0ec0\u0ead\u0e97\u0ebd\u0e99|\u0eaa\u0eb1\u0e99\u0ec2\u0e84|\u0ea2\u0eb5\u0e84\u0eb4\u0e94|\u0e8a\u0eb4\u0e99\u0e94\u0eb4|\u0e9f\u0eb4\u0e99\u0ec1\u0ea5\u0e99|\u0eaa\u0eb1\u0e99\u0eaa\u0eb0\u0e81\u0eb4\u0e94|\u0e9d\u0eb1\u0ec8\u0ea5\u0e87\u0ec0\u0eaa\u0e94|\u0ec1\u0ea5\u0e95\u0eb0\u0ec0\u0ea7\u0e8d(\u0ec0\u0ea5\u0e94\u0e97\u0eb0\u0ea7\u0eb4\u0e94)|\u0ea5\u0eb4\u0e97\u0ebb\u0ea7\u0ec0\u0e99\u0e8d|\u0e9f\u0eb2\u0ec2\u0ea5\u0e94|\u0e84\u0eb4\u0e99\u0e8d\u0eb2\u0ea7\u0eb1\u0e99\u0e94\u0eb2|\u0ea5\u0eb1\u0e94\u0ec0\u0e8a\u0e8d|\u0ea5\u0eb2\u0ea7|\u0e9f\u0eb4\u0e88\u0eb4|\u0ea5\u0eb4\u0e87\u0e81\u0eb2\u0ea5\u0eb2|\u0e9f\u0eb4\u0e99|\u0ec2\u0ea5\u0ea1\u0eb1\u0e99|\u0e84\u0eb4\u0ea5\u0eb1\u0e99\u0eaa\u0eb5|\u0ec0\u0ea5\u0ec2\u0e95-\u0ec2\u0ea5\u0ec1\u0ea1\u0e99|\u0ec0\u0e9b\u0eb5\u0ec0\u0e8a\u0e8d|\u0ea5\u0eb2\u0e95\u0eb4\u0e99|\u0ec2\u0e8a\u0eaa\u0eb2|\u0ec1\u0e9a\u0eaa|\u0ec0\u0e84\u0ea7\u0e81\u0eb4\u0e94|\u0ec0\u0ead\u0eaa\u0ec2\u0e95\u0ec0\u0e99\u0e8d";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "localPatternChars", "GanjkHmsSEDFwWxhKzAeugXZ" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "ampms", ampms },
    { "shortDateFormat", "d/M/yyyy" },
    { "mediumDateFormat", "d MMM yyyy" },
    { "longDateFormat", "d MMMM yyyy" },
    { "fullDateFormat", "EEEE'\u0e97\u0eb5  'd MMMM G yyyy" },
    { "shortTimeFormat", "H:mm" },
    { "mediumTimeFormat", "H:mm:ss" },
    { "longTimeFormat", "H' \u0ec2\u0ea1\u0e87 'm'\u0e99\u0eb2\u0e97\u0eb5'" },
    { "fullTimeFormat", "H'\u0ec2\u0ea1\u0e87 'm'\u0e99\u0eb2\u0e97\u0eb5 'ss' \u0ea7\u0eb4\u0e99\u0eb2\u0e97\u0eb5" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
