/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model;

import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.model.IRootProcessor;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.EditorActivatedListener;
import org.eclipse.wb.core.model.broadcast.EditorActivatedRequest;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildGraphical;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildTree;
import org.eclipse.wb.core.model.broadcast.ObjectInfoPresentationDecorateText;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.model.property.Property;

public final class JavaInfoRootProcessor
implements IRootProcessor {
    public static final IRootProcessor INSTANCE = new JavaInfoRootProcessor();

    private JavaInfoRootProcessor() {
    }

    @Override
    public void process(JavaInfo root, List<JavaInfo> components) throws Exception {
        JavaInfoRootProcessor.processRoot(root);
    }

    private static void processRoot(final JavaInfo rootJavaInfo) throws Exception {
        rootJavaInfo.addBroadcastListener(new ObjectEventListener(){

            public void dispose() throws Exception {
                JavaInfoUtils.getState(rootJavaInfo).dispose();
            }
        });
        rootJavaInfo.addBroadcastListener(new EditorActivatedListener(){

            public void invoke(EditorActivatedRequest request) throws Exception {
                if (JavaInfoUtils.isDependencyChanged(rootJavaInfo)) {
                    request.requestReparse();
                }
            }
        });
        rootJavaInfo.addBroadcastListener(new ObjectInfoChildTree(){

            public void invoke(ObjectInfo object, boolean[] visible) throws Exception {
                if (object instanceof JavaInfo) {
                    JavaInfo javaInfo = (JavaInfo)object;
                    String visibilityTreeString = JavaInfoUtils.getParameter(javaInfo, "visible.inTree");
                    if (visibilityTreeString != null) {
                        visible[0] = Boolean.parseBoolean(visibilityTreeString);
                    } else {
                        String visibilityString = JavaInfoUtils.getParameter(javaInfo, "visible");
                        if (visibilityString != null) {
                            visible[0] = Boolean.parseBoolean(visibilityString);
                        }
                    }
                }
            }
        });
        rootJavaInfo.addBroadcastListener(new ObjectInfoChildGraphical(){

            public void invoke(ObjectInfo object, boolean[] visible) throws Exception {
                if (object instanceof JavaInfo) {
                    JavaInfo javaInfo = (JavaInfo)object;
                    String visibilityGraphString = JavaInfoUtils.getParameter(javaInfo, "visible.inGraphical");
                    if (visibilityGraphString != null) {
                        visible[0] = Boolean.parseBoolean(visibilityGraphString);
                    } else {
                        String visibilityString = JavaInfoUtils.getParameter(javaInfo, "visible");
                        if (visibilityString != null) {
                            visible[0] = Boolean.parseBoolean(visibilityString);
                        }
                    }
                }
            }
        });
        rootJavaInfo.addBroadcastListener(new ObjectInfoPresentationDecorateText(){

            public void invoke(ObjectInfo object, String[] text) throws Exception {
                JavaInfo javaInfo;
                IPreferenceStore preferences;
                if (object instanceof JavaInfo && (preferences = (javaInfo = (JavaInfo)object).getDescription().getToolkit().getPreferences()).getBoolean("general.showTextPropertySuffix")) {
                    JavaInfoRootProcessor.broadcast_presentation_decorateText(javaInfo, text);
                }
            }
        });
    }

    private static void broadcast_presentation_decorateText(JavaInfo javaInfo, String[] text) throws Exception {
        Property[] propertyArray = javaInfo.getProperties();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            GenericPropertyImpl genericProperty;
            GenericPropertyDescription propertyDescription;
            Property property = propertyArray[n2];
            if (property instanceof GenericPropertyImpl && (propertyDescription = (genericProperty = (GenericPropertyImpl)property).getDescription()) != null && propertyDescription.hasTrueTag("isText") && genericProperty.getJavaInfo() == javaInfo && genericProperty.isModified()) {
                String suffix = (String)genericProperty.getValue();
                text[0] = String.valueOf(text[0]) + " - \"" + suffix + "\"";
                break;
            }
            ++n2;
        }
    }
}

