/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.util;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;

public class ClassBasedResourceFinder {
    private final URLClassLoader m_loader;
    private static Map<URI, ClassBasedResourceFinder> s_finders = new HashMap<URI, ClassBasedResourceFinder>();

    private ClassBasedResourceFinder(URLClassLoader loader) {
        this.m_loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassBasedResourceFinder getFinder(Class clz) {
        String baseUri = clz.getName().replace(".", "/");
        String fileName = String.valueOf(baseUri) + ".class";
        URL url = clz.getResource("/" + fileName);
        String fullUrlName = url.toExternalForm();
        try {
            URL rootUrl = new URL(fullUrlName.substring(0, fullUrlName.length() - fileName.length()));
            Class<ClassBasedResourceFinder> clazz = ClassBasedResourceFinder.class;
            synchronized (ClassBasedResourceFinder.class) {
                ClassBasedResourceFinder finder = s_finders.get(rootUrl.toURI());
                if (finder == null) {
                    finder = new ClassBasedResourceFinder(new URLClassLoader(new URL[]{rootUrl}, null));
                    s_finders.put(rootUrl.toURI(), finder);
                }
                // ** MonitorExit[var6_8] (shouldn't be in output)
                return finder;
            }
        }
        catch (MalformedURLException e) {
            throw new DsfRuntimeException((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new DsfRuntimeException((Throwable)e);
        }
    }

    public URL findResource(String resourceName) {
        return this.m_loader.findResource(resourceName);
    }

    public boolean hasResource(String resourceName) {
        return this.m_loader.findResource(resourceName) != null;
    }
}

