/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom;

import org.eclipse.vjet.dsf.common.DsfVerifierConfig;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.binding.IValueBinding;
import org.eclipse.vjet.dsf.common.binding.SimpleValueBinding;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.trace.TraceCtx;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.support.DsfDomLevelNotSupportedException;
import org.eclipse.vjet.dsf.dom.support.XmlVerifier;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.TypeInfo;

public class DAttr
extends DNode
implements Attr,
IValueBinding<String> {
    private static final long serialVersionUID = 1L;
    private DElement m_ownerElement = null;
    private boolean m_isId = false;
    private IValueBinding<Object> m_valueBinding = null;
    private int m_nameAsCharsIndex = -1;
    private transient TraceCtx m_traceCtx;

    public DAttr(DDocument document, String name) {
        this(document, name, null);
    }

    public DAttr(DDocument document, String name, String value) {
        super(document, name);
        if (DsfVerifierConfig.getInstance().isVerifyNaming() && !XmlVerifier.isXMLName(name, false)) {
            throw new DOMException(5, "bad Attribute tag name: " + name);
        }
        this.m_nodeValue = value;
    }

    public DAttr(String name, String value) {
        this(null, name, value);
    }

    protected void setOwnerElement(DElement ownerElement) {
        this.m_ownerElement = ownerElement;
    }

    void setNameAsCharIndex(int index) {
        this.m_nameAsCharsIndex = index;
    }

    int getNameAsCharIndex() {
        return this.m_nameAsCharsIndex;
    }

    @Override
    public Class<String> getValueType() {
        return String.class;
    }

    @Override
    public String getValue() {
        String value = this.m_nodeValue;
        if (this.m_valueBinding != null) {
            Object oValue = this.m_valueBinding.getValue();
            value = oValue == null ? null : oValue.toString();
        }
        return value == null ? "" : value;
    }

    @Override
    public void setValue(String value) throws DOMException {
        this.setNodeValue(value);
        if (this.m_valueBinding != null) {
            this.m_valueBinding.setValue(value);
        }
    }

    @Override
    public String getName() {
        return this.getNodeName();
    }

    @Override
    public boolean getSpecified() {
        return true;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        if (this.isId() && this.getOwnerDocument() != null) {
            String oldValue = this.getValue();
            if (oldValue != null) {
                this.getDsfOwnerDocument().removeIdentifier(oldValue);
            }
            super.setNodeValue(nodeValue);
            if (nodeValue != null) {
                this.getDsfOwnerDocument().putIdentifier(nodeValue, this.m_ownerElement);
            }
        } else {
            super.setNodeValue(nodeValue);
        }
        if (this.getTraceCtx().haveInstrumenter()) {
            this.m_traceCtx.getInstrumenter().runAttributeInstrumenters(this.m_ownerElement, this, nodeValue);
        }
    }

    public void setOldValue(String oldValue) {
        this.m_nodeValue = oldValue;
    }

    @Override
    public Element getOwnerElement() {
        return this.m_ownerElement;
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        throw new DsfDomLevelNotSupportedException(3);
    }

    @Override
    public boolean isId() {
        return this.m_isId;
    }

    @Override
    public final short getNodeType() {
        return 2;
    }

    void setId(boolean isId) {
        this.m_isId = isId;
    }

    public IValueBinding<Object> getValueBinding() {
        return this.m_valueBinding;
    }

    public IValueBinding<Object> setValueBinding(IValueBinding<Object> binding) {
        IValueBinding<Object> pre = this.m_valueBinding;
        this.m_valueBinding = binding;
        return pre;
    }

    public void setObjectValue(Object value) {
        if (value instanceof String) {
            this.setNodeValue((String)value);
            if (this.m_valueBinding != null) {
                this.m_valueBinding.setValue(value);
            }
        } else {
            if (this.m_valueBinding == null) {
                this.m_valueBinding = new SimpleValueBinding<Object>(Object.class);
            }
            this.m_valueBinding.setValue(value);
        }
    }

    public Object getObjectValue() {
        if (this.m_valueBinding == null) {
            return this.getNodeValue();
        }
        return this.m_valueBinding.getValue();
    }

    @Override
    final DNode setParent(DNode parent) {
        throw new DsfRuntimeException("attribute '" + this.getName() + "' cannot have a parent");
    }

    private TraceCtx getTraceCtx() {
        if (this.m_traceCtx == null) {
            this.m_traceCtx = TraceCtx.ctx();
        }
        return this.m_traceCtx;
    }

    @Override
    public DAttr jif(String jif) {
        super.jif(jif);
        return this;
    }

    public static void main(String[] args) {
        DElement root = new DElement("root");
        root.setAttribute("a", "alpha");
    }

    @Override
    public String toString() {
        Z z = new Z();
        z.format("owning Element", this.m_ownerElement == null ? null : this.m_ownerElement.getTagName());
        z.format("isId", this.isId());
        z.format("has binding", this.m_valueBinding != null);
        z.append((Object)super.toString());
        return z.toString();
    }
}

