/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.dom;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Locale;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.DElementConstructor;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.DomUtil;
import org.eclipse.vjet.dsf.dom.support.DNamespace;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnum;

public class Html
extends DElementConstructor {
    private static HashMap<String, Constructor<?>> s_elementTypesHTML;
    private static final Class<?>[] s_elemClassSigHTML;
    private static final Object[] EMPTY_ARG;

    static {
        s_elemClassSigHTML = new Class[0];
        EMPTY_ARG = new Object[0];
        Html.populateElementTypes();
    }

    public DElement domCreateDynamicElement(String namespaceUri, String possibleQualifiedName) {
        DNamespace ns = DomUtil.getNamespace((String)namespaceUri, (String)possibleQualifiedName);
        String localName = DomUtil.getUnqualifedName((String)possibleQualifiedName);
        return this.domCreateDynamicElement(ns, localName);
    }

    public DElement domCreateDynamicElement(String unqualifiedName) {
        String tagName = unqualifiedName.toLowerCase(Locale.ENGLISH);
        Constructor<?> cnst = s_elementTypesHTML.get(tagName);
        if (cnst != null) {
            try {
                return (DElement)cnst.newInstance(EMPTY_ARG);
            }
            catch (Exception except) {
                Throwable thrw = except instanceof InvocationTargetException ? ((InvocationTargetException)except).getTargetException() : except;
                throw new IllegalStateException("HTM15 Tag '" + tagName + "' associated with an Element class that failed to construct.\n" + tagName + " with following message: " + thrw.getMessage(), except);
            }
        }
        return new DElement(tagName);
    }

    public DElement domCreateDynamicElement(DNamespace namespace, String nonQualifiedTagName) {
        DElement elem = this.domCreateDynamicElement(nonQualifiedTagName);
        elem.setDsfNamespace(namespace);
        return elem;
    }

    public DElement domCreateDynamicElement(DDocument owner, String inTagName) {
        DElement e = this.domCreateDynamicElement(inTagName);
        Html.setOwnerDocument((DDocument)owner, (DNode)e);
        return e;
    }

    public DElement domCreateDynamicElement(DDocument owner, DNamespace namespace, String inTagName) {
        DElement e = this.domCreateDynamicElement(namespace, inTagName);
        Html.setOwnerDocument((DDocument)owner, (DNode)e);
        return e;
    }

    private static synchronized void populateElementTypes() {
        if (s_elementTypesHTML != null) {
            return;
        }
        s_elementTypesHTML = new HashMap(101);
        for (HtmlTypeEnum htmlType : HtmlTypeEnum.valueIterable()) {
            Html.populateElementType(htmlType);
        }
    }

    private static void populateElementType(HtmlTypeEnum htmlType) {
        String tagName = htmlType.getName();
        Class elemClz = htmlType.getTypeClass();
        try {
            s_elementTypesHTML.put(tagName, elemClz.getConstructor(s_elemClassSigHTML));
        }
        catch (Exception except) {
            throw new RuntimeException("HTM019 OpenXML Error: Could not find proper constructor for " + elemClz.getName() + " for " + tagName, except);
        }
    }
}

