/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ccil.cowan.tagsoup.HTMLSchema;
import org.ccil.cowan.tagsoup.Schema;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;

public class HtmlParserOptions
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private List<String> m_wellformTags = new ArrayList<String>();
    final transient Schema m_schema;
    int m_flags;
    public static final short IGNORE_DUP_ID = 1;
    public static final short FIX_DUP_ID = 2;
    public static final short PRE_PROCESS_DECODE = 4;
    public static final short PRE_PROCESS_TAG_NAME = 8;
    public static final short PRE_PROC_UNKNOWN_TAG = 16;
    public static final short NO_DEFAULT_ATTR = 32;

    public HtmlParserOptions() {
        this((Schema)new HTMLSchema());
    }

    public HtmlParserOptions(Schema schema) {
        this.m_schema = schema;
    }

    public boolean isIgnoreDuplicateIds() {
        return (this.m_flags & 1) != 0;
    }

    public HtmlParserOptions setIgnoreDuplicateIds(boolean ignoreDuplicateIds) {
        if (ignoreDuplicateIds && this.isFixDuplicateIds()) {
            return this;
        }
        this.m_flags = ignoreDuplicateIds ? this.m_flags | 1 : this.m_flags & 0xFFFFFFFE;
        return this;
    }

    public HtmlParserOptions relaxElementName(String ... elementNames) {
        return this.preProcessTagName();
    }

    public HtmlParserOptions checkWellform(String ... elementNames) {
        if (elementNames == null) {
            return this;
        }
        String[] stringArray = elementNames;
        int n = elementNames.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            if (e != null && e.trim().length() > 0) {
                String small = e.toLowerCase();
                if (this.m_schema.getElementType(small) == null) {
                    throw new DsfRuntimeException("Unknown Html Element " + small);
                }
                if (this.m_wellformTags.indexOf(small) == -1) {
                    this.m_wellformTags.add(small);
                }
            }
            ++n2;
        }
        return this;
    }

    public List<String> getWellformTags() {
        return Collections.unmodifiableList(this.m_wellformTags);
    }

    public boolean isFixDuplicateIds() {
        return (this.m_flags & 2) != 0;
    }

    public HtmlParserOptions setFixDuplicateIds(boolean fixDuplicateIds) {
        if (fixDuplicateIds && this.isIgnoreDuplicateIds()) {
            this.setIgnoreDuplicateIds(false);
        }
        this.m_flags = fixDuplicateIds ? this.m_flags | 2 : this.m_flags & 0xFFFFFFFD;
        return this;
    }

    public HtmlParserOptions clone() throws CloneNotSupportedException {
        HtmlParserOptions copy = (HtmlParserOptions)super.clone();
        copy.m_wellformTags = new ArrayList<String>(this.m_wellformTags.size());
        for (String e : this.m_wellformTags) {
            copy.m_wellformTags.add(e);
        }
        return copy;
    }

    public Schema getSchema() {
        return this.m_schema;
    }

    public boolean isPreDecode() {
        return (this.m_flags & 4) != 0;
    }

    public boolean isPreProcessUnkownTag() {
        return (this.m_flags & 0x10) != 0;
    }

    public boolean isPreProcessTagName() {
        return (this.m_flags & 8) != 0;
    }

    public boolean isNoDefaultAttr() {
        return (this.m_flags & 0x20) != 0;
    }

    public HtmlParserOptions preProcessTagName() {
        this.m_flags |= 8;
        return this;
    }

    public HtmlParserOptions preProcessUnkownTag() {
        this.m_flags |= 0x10;
        return this.preProcessTagName();
    }

    public HtmlParserOptions preDecode() {
        this.m_flags |= 4;
        return this;
    }

    public HtmlParserOptions noDefaultAttr() {
        this.m_flags |= 0x20;
        return this;
    }
}

