/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsdebugger;

import org.eclipse.vjet.dsf.jsdebugger.StackFrame;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.ObjArray;

public class ContextData {
    private ObjArray m_frameStack = new ObjArray();
    private boolean m_breakNextLine;
    private int m_stopAtFrameDepth = -1;
    private boolean m_eventThreadFlag;
    private Throwable m_lastProcessedException;

    public static ContextData get(Context cx) {
        return (ContextData)cx.getDebuggerContextData();
    }

    public int frameCount() {
        return this.m_frameStack.size();
    }

    public StackFrame getFrame(int frameNumber) {
        int num = this.m_frameStack.size() - frameNumber - 1;
        return (StackFrame)this.m_frameStack.get(num);
    }

    public void pushFrame(StackFrame frame) {
        this.m_frameStack.push((Object)frame);
    }

    public void popFrame() {
        this.m_frameStack.pop();
    }

    public boolean isBreakNextLine() {
        return this.m_breakNextLine;
    }

    public void setBreakNextLine(boolean breakNextLine) {
        this.m_breakNextLine = breakNextLine;
    }

    public boolean getEventThreadFlag() {
        return this.m_eventThreadFlag;
    }

    public void setEventThreadFlag(boolean eventThreadFlag) {
        this.m_eventThreadFlag = eventThreadFlag;
    }

    public Throwable getLastProcessedException() {
        return this.m_lastProcessedException;
    }

    public void setLastProcessedException(Throwable lastProcessedException) {
        this.m_lastProcessedException = lastProcessedException;
    }

    public int getStopAtFrameDepth() {
        return this.m_stopAtFrameDepth;
    }

    public void setStopAtFrameDepth(int stopAtFrameDepth) {
        this.m_stopAtFrameDepth = stopAtFrameDepth;
    }
}

