/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsrunner;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.eclipse.vjet.dsf.jsrunner.IBrowserLauncher;

public class BrowserRemoteLauncher
implements IBrowserLauncher {
    private final String m_remoteLauncherUrl;
    public static final String IE = "IE";
    public static final String FIREFOX = "FIREFOX";
    public static final String OPERA = "OPERA";
    public static final String SAFARI = "SAFARI";
    public static final String CHROME = "CHROME";

    public BrowserRemoteLauncher(String remoteLauncherUrl) {
        this.m_remoteLauncherUrl = remoteLauncherUrl;
    }

    @Override
    public Process launch(String webUrl, BrowserType type) {
        InputStream inputStream = null;
        try {
            try {
                String bType = IE;
                if (type != null) {
                    if (type.isFireFox()) {
                        bType = FIREFOX;
                    } else if (type.isOpera()) {
                        bType = OPERA;
                    } else if (type.isSafari()) {
                        bType = SAFARI;
                    } else if (type == BrowserType.CHROME_1P) {
                        bType = CHROME;
                    }
                }
                StringBuilder sb = new StringBuilder(this.m_remoteLauncherUrl);
                sb.append("/?webUrl=").append(URLEncoder.encode(webUrl, "UTF-8")).append("&bType=").append(bType);
                URL url = new URL(sb.toString());
                URLConnection connection = url.openConnection();
                if (connection instanceof HttpURLConnection) {
                    HttpURLConnection httpC = (HttpURLConnection)connection;
                    httpC.setRequestMethod("GET");
                    httpC.addRequestProperty("Accept-Charset", "UTF-8");
                    inputStream = httpC.getInputStream();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException();
            }
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }
}

