/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsrunner;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.eclipse.vjet.dsf.jsrunner.IBrowserLauncher;

public class BrowserLauncher
implements IBrowserLauncher {
    private static final String WIN_ID = "Windows";
    private static final String WIN2K3_ID = "Windows Server 2003";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "netscape";
    private static final String UNIX_FLAG = "-remote openURL";
    private static final boolean IS_WINDOWS = BrowserLauncher.isWindowsPlatform();
    private static final BrowserLauncher s_instance = new BrowserLauncher();

    public static BrowserLauncher getInstance() {
        return s_instance;
    }

    @Override
    public Process launch(String url, BrowserType type) {
        if (type == null) {
            return BrowserLauncher.displayUrlInDefault(url);
        }
        if (type.isIE()) {
            return BrowserLauncher.displayUrlInInternetExplorer(url);
        }
        if (type.isFireFox()) {
            return BrowserLauncher.displayUrlInFirefox(url);
        }
        return BrowserLauncher.displayUrlInDefault(url);
    }

    private static Process displayUrlInInternetExplorer(String url) {
        if (BrowserLauncher.isWindows2K3Platform()) {
            return BrowserLauncher.displayUrlIn("c:\\program files (x86)\\Internet Explorer\\iexplore.exe", url);
        }
        return BrowserLauncher.displayUrlIn("c:\\program files\\Internet Explorer\\iexplore.exe", url);
    }

    private static Process displayUrlInFirefox(String url) {
        if (BrowserLauncher.isWindows2K3Platform()) {
            return BrowserLauncher.displayUrlIn("c:\\program files (x86)\\mozilla firefox\\firefox.exe", url);
        }
        return BrowserLauncher.displayUrlIn("c:\\program files\\mozilla firefox\\firefox.exe", url);
    }

    private static Process displayUrlIn(String displayersExePath, String url) {
        String[] cmd = new String[]{displayersExePath, url};
        return BrowserLauncher.executeCommand(cmd);
    }

    private static Process displayUrlInDefault(String url) {
        String cmd = null;
        try {
            if (IS_WINDOWS) {
                cmd = "rundll32 url.dll,FileProtocolHandler";
                return BrowserLauncher.displayUrlIn(cmd, url);
            }
            cmd = "netscape -remote openURL(" + url + ")";
            Process p = Runtime.getRuntime().exec(cmd);
            try {
                int exitCode = p.waitFor();
                if (exitCode != 0) {
                    cmd = "netscape " + url;
                    p = Runtime.getRuntime().exec(cmd);
                }
            }
            catch (InterruptedException x) {
                BrowserLauncher.err("Error launching browser, cmd='" + cmd + "'");
                BrowserLauncher.err("Encountered exception: " + x);
            }
            return p;
        }
        catch (IOException x) {
            BrowserLauncher.err("Could not launch browser, command=" + cmd);
            BrowserLauncher.err("Encountered exception: " + x);
            return null;
        }
    }

    private static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith(WIN_ID);
    }

    private static boolean isWindows2K3Platform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith(WIN2K3_ID);
    }

    private static void err(String message) {
        System.err.println(message);
    }

    private static Process executeCommand(String[] cmd) {
        try {
            Process proc = Runtime.getRuntime().exec(cmd);
            StreamConsumer errorStreamConsumer = new StreamConsumer(proc.getErrorStream());
            StreamConsumer outputStreamConsumer = new StreamConsumer(proc.getInputStream());
            errorStreamConsumer.start();
            outputStreamConsumer.start();
            return proc;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private static class StreamConsumer
    extends Thread {
        InputStream m_is;
        OutputStream m_os;

        StreamConsumer(InputStream is) {
            this(is, null);
        }

        StreamConsumer(InputStream is, OutputStream redirect) {
            this.m_is = is;
            this.m_os = redirect;
        }

        @Override
        public void run() {
            try {
                PrintWriter pw = null;
                if (this.m_os != null) {
                    pw = new PrintWriter(this.m_os);
                }
                InputStreamReader isr = new InputStreamReader(this.m_is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (pw == null) continue;
                    pw.println(line);
                }
                if (pw != null) {
                    pw.flush();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

