/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.js;

import java.net.URL;
import org.eclipse.vjet.dsf.html.js.JSDebug;
import org.eclipse.vjet.dsf.html.js.JSWindow;
import org.eclipse.vjet.dsf.html.js.JsHackDetectionCtx;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;

public class JSLocation
extends ScriptableObject {
    private JSWindow window = null;
    private Context cx = null;
    private Scriptable scope = null;
    private String hash = null;
    private String host = null;
    String hostname = null;
    String href = null;
    Scriptable scriptableHref = null;
    String pathname = null;
    private String port = null;
    private String protocol = null;
    private String search = null;
    private String replacement = null;

    public JSLocation(JSWindow window) {
        this.window = window;
        this.cx = window.getContext();
        this.scope = window.getScope();
        String[] functions = new String[]{"replace", "valueOf", "reload", "toString"};
        this.defineFunctionProperties(functions, JSLocation.class, 2);
        this.defineProperty("href", JSLocation.class, 2);
        this.defineProperty("host", JSLocation.class, 2);
        this.defineProperty("hostname", JSLocation.class, 2);
        this.defineProperty("pathname", JSLocation.class, 2);
        this.defineProperty("port", JSLocation.class, 2);
        this.defineProperty("protocol", JSLocation.class, 2);
        this.defineProperty("search", JSLocation.class, 2);
    }

    public String getClassName() {
        return "JSLocation";
    }

    public Scriptable getHash() {
        if (this.hash != null) {
            return Context.toObject((Object)this.hash, (Scriptable)this.scope);
        }
        String r = this.window.getURL().getRef();
        r = r == null ? "" : "#" + r;
        return Context.toObject((Object)r, (Scriptable)this.scope);
    }

    public void setHash(Object obj) {
        this.hash = obj.toString();
    }

    public Scriptable getHost() {
        if (this.host != null) {
            return Context.toObject((Object)this.host, (Scriptable)this.scope);
        }
        URL url = this.window.getURL();
        int portNumber = url.getPort();
        String hostStr = "";
        if (portNumber > 0) {
            hostStr = ":" + portNumber;
        }
        return Context.toObject((Object)(String.valueOf(url.getHost()) + hostStr), (Scriptable)this.scope);
    }

    public void setHost(Object obj) {
        this.host = obj.toString();
    }

    public Scriptable getHostname() {
        if (this.hostname != null) {
            return Context.toObject((Object)this.hostname, (Scriptable)this.scope);
        }
        String h = this.window.getURL().getHost();
        if (h == null) {
            h = "";
        }
        return Context.toObject((Object)h, (Scriptable)this.scope);
    }

    public void setHostname(Object obj) {
        this.hostname = obj.toString();
    }

    public Scriptable getHref() {
        if (this.href != null) {
            if (this.scriptableHref == null) {
                this.scriptableHref = Context.toObject((Object)this.href, (Scriptable)this.scope);
            }
            return this.scriptableHref;
        }
        this.href = this.window.getURL().toString();
        if (this.href == null) {
            this.href = "";
        }
        this.scriptableHref = Context.toObject((Object)this.href, (Scriptable)this.scope);
        return this.scriptableHref;
    }

    public void setHref(Object obj) {
        this.replace(obj);
    }

    public Scriptable getPathname() {
        if (this.pathname != null) {
            return Context.toObject((Object)this.pathname, (Scriptable)this.scope);
        }
        String p = this.getURLPath(this.window.getURL().toString());
        if (p == null) {
            p = "";
        }
        return Context.toObject((Object)p, (Scriptable)this.scope);
    }

    public void setPathname(Object obj) {
        this.pathname = obj.toString();
    }

    public Scriptable getPort() {
        if (this.port != null) {
            return Context.toObject((Object)this.port, (Scriptable)this.scope);
        }
        int portNumber = this.window.getURL().getPort();
        if (portNumber > 0) {
            return Context.toObject((Object)("" + portNumber), (Scriptable)this.scope);
        }
        return Context.toObject((Object)"", (Scriptable)this.scope);
    }

    public void setPort(Object obj) {
        this.port = obj.toString();
    }

    public Scriptable getProtocol() {
        if (this.protocol != null) {
            return Context.toObject((Object)this.protocol, (Scriptable)this.scope);
        }
        String p = this.window.getURL().getProtocol();
        p = p == null ? "" : String.valueOf(p) + ":";
        return Context.toObject((Object)p, (Scriptable)this.scope);
    }

    public void setProtocol(Object obj) {
        this.protocol = obj.toString();
    }

    public Scriptable getSearch() {
        if (this.search != null) {
            return Context.toObject((Object)this.search, (Scriptable)this.scope);
        }
        String q = this.getURLQuery(this.window.getURL().toString());
        if (q == null) {
            q = "";
        }
        return Context.toObject((Object)q, (Scriptable)this.scope);
    }

    public void setSearch(Object obj) {
        this.search = obj.toString();
    }

    public void reload(Object force) {
        if (this.window.windowState == JSWindow.IN_SERVER) {
            this.window.getJSListener().doAction(25, "location", null, null);
        }
    }

    public void replace(Object s) {
        JsHackDetectionCtx.ctx().setLocationChange(s.toString());
        JSDebug.println("JSLocation:replace: " + s);
        if (s != null) {
            if (this.window.windowState == JSWindow.IN_LOADING) {
                this.replacement = s.toString();
            } else {
                this.window.getJSListener().doAction(4, "LOCATION", s.toString(), null);
            }
        }
    }

    public String getReplacement() {
        return this.replacement;
    }

    private String getURLPath(String u) {
        if (u == null || u.trim().length() <= 0) {
            return "";
        }
        String s = u;
        int i = s.lastIndexOf(59);
        if (i > -1) {
            s = s.substring(0, i);
        }
        if ((i = s.lastIndexOf(35)) > -1) {
            s = s.substring(0, i);
        }
        if ((i = s.indexOf("://")) > -1) {
            s = s.substring(i + 3);
        }
        if ((i = (s = (i = s.indexOf(47)) > -1 ? s.substring(i) : "/").indexOf(63)) > -1) {
            s = s.substring(0, i);
        }
        return s;
    }

    private String getURLQuery(String u) {
        if (u == null || u.trim().length() <= 0) {
            return "";
        }
        String s = u;
        int i = s.indexOf(63);
        if (i < 0) {
            return "";
        }
        if ((i = (s = s.substring(i)).lastIndexOf(35)) > -1) {
            s = s.substring(0, i);
        }
        return s;
    }

    public Object valueOf(String type) {
        if (type.equals("boolean")) {
            return Boolean.TRUE;
        }
        if (type.equals("string")) {
            return this.getHref();
        }
        if (type.equals("object")) {
            return this;
        }
        if (type.equals("number")) {
            return "0";
        }
        return null;
    }

    public String toString() {
        this.href = this.window.getURL().toString();
        return this.href;
    }
}

