/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.js;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.js.JSDebug;
import org.eclipse.vjet.dsf.html.js.JSElement;
import org.eclipse.vjet.dsf.html.js.JSWindow;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.FunctionObject;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;
import org.w3c.dom.NodeList;

public class JSAllArray
extends ScriptableObject {
    private JSWindow m_window = null;
    private Context m_context = null;
    private Scriptable m_scope = null;

    private JSAllArray() {
    }

    public JSAllArray(JSWindow window) {
        JSDebug.println("JSAllArray:JSAllArray()...");
        this.m_window = window;
        this.m_context = window.getContext();
        this.m_scope = window.getScope();
    }

    public String getClassName() {
        JSDebug.println("JSAllArray:getClassName(...)");
        return "JSAllArray";
    }

    public boolean has(String name, Scriptable start) {
        JSDebug.println("JSAllArray:has... " + name);
        if (name.equals("length")) {
            return true;
        }
        NodeList elements = this.m_window.getHTMLDocument().getElementsByTagName(name);
        if (elements != null && elements.getLength() > 0) {
            return true;
        }
        DElement element = (DElement)this.m_window.getHTMLDocument().getElementById(name);
        return element != null;
    }

    public boolean has(int index, Scriptable start) {
        JSDebug.println("JSAllArray:has... " + index);
        NodeList elements = this.m_window.getHTMLDocument().getElementsByTagName("*");
        return elements != null && index >= 0 && index < elements.getLength();
    }

    public Object get(String name, Scriptable start) {
        JSDebug.println("JSAllArray:get... " + name);
        NodeList elements = null;
        if (name.equals("length")) {
            elements = this.m_window.getHTMLDocument().getElementsByTagName("*");
            if (elements != null) {
                return new Integer(elements.getLength());
            }
            return new Integer(0);
        }
        if (name.equals("Function")) {
            return NOT_FOUND;
        }
        if (name.equals("item")) {
            try {
                Class<?> thisClass = ((Object)((Object)this)).getClass();
                Class[] parameterTypes = new Class[]{Object.class};
                Method doItemMethod = thisClass.getMethod("doItem", parameterTypes);
                return new FunctionObject("doItem", (Member)doItemMethod, (Scriptable)this);
            }
            catch (Exception exception) {}
        } else if (name.equals("tags")) {
            try {
                Class<?> thisClass = ((Object)((Object)this)).getClass();
                Class[] parameterTypes = new Class[]{Object.class};
                Method doTagsMethod = thisClass.getMethod("doTags", parameterTypes);
                return new FunctionObject("doTags", (Member)doTagsMethod, (Scriptable)this);
            }
            catch (Exception exception) {}
        }
        Object obj = super.get(name, start);
        if (obj != NOT_FOUND) {
            return obj;
        }
        DElement element = (DElement)this.m_window.getHTMLDocument().getElementById(name);
        if (element != null) {
            JSElement jsElement = new JSElement(this.m_window, (BaseHtmlElement)element);
            super.put(name, start, (Object)jsElement);
            return jsElement;
        }
        elements = this.m_window.getHTMLDocument().getElementsByTagName(name);
        if (elements == null) {
            return Scriptable.NOT_FOUND;
        }
        int length = elements.getLength();
        Object[] htmlElements = new BaseHtmlElement[length];
        int i = 0;
        while (i < length) {
            htmlElements[i] = (BaseHtmlElement)elements.item(i);
            ++i;
        }
        if (length > 1) {
            return this.m_context.newArray(this.m_scope, htmlElements);
        }
        return Scriptable.NOT_FOUND;
    }

    public Object get(int index, Scriptable start) {
        JSDebug.println("JSAllArray:get... " + index);
        NodeList elements = this.m_window.getHTMLDocument().getElementsByTagName("*");
        if (elements == null || index < 0 || index >= elements.getLength()) {
            return Scriptable.NOT_FOUND;
        }
        return Context.toObject((Object)elements.item(index), (Scriptable)this.m_scope);
    }

    public Object[] getIds() {
        JSDebug.println("JSAllArray:getIds...");
        return new Object[0];
    }

    public Object getDefaultValue(Class typeHint) {
        JSDebug.println("JSAllArray:getDefaultValue(Class)..." + typeHint);
        if (typeHint.equals(Boolean.class)) {
            return Boolean.TRUE;
        }
        if (typeHint.equals(String.class)) {
            return "[object JSAllArray]";
        }
        return Scriptable.NOT_FOUND;
    }

    public boolean hasInstance(Scriptable value) {
        JSDebug.println("JSAllArray:hasInstance(Scriptable)...");
        Scriptable proto = value.getPrototype();
        while (proto != null) {
            if (!proto.equals((Object)this)) continue;
            return true;
        }
        return false;
    }

    public Object doItem(Object name) {
        JSDebug.println("JSAllArray:doItem(Object)..." + name);
        return this.get(name.toString(), (Scriptable)this);
    }

    public Object doTags(Object name) {
        JSDebug.println("JSAllArray:doTags(Object)..." + name);
        NodeList elements = this.m_window.getHTMLDocument().getElementsByTagName(name.toString());
        if (elements == null) {
            return this.m_context.newArray(this.m_scope, 0);
        }
        int length = elements.getLength();
        Object[] htmlElements = new BaseHtmlElement[length];
        int i = 0;
        while (i < length) {
            htmlElements[i] = (BaseHtmlElement)elements.item(i);
            ++i;
        }
        return this.m_context.newArray(this.m_scope, htmlElements);
    }

    public Object findObjById(String name) {
        Object obj = super.get(name, (Scriptable)this);
        if (obj == Scriptable.NOT_FOUND) {
            return null;
        }
        return obj;
    }
}

